/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Pool<T> {
    private final String name;
    private final List<T> pool;
    private final Map<Feature, Integer> features = new EnumMap<Feature, Integer>(Feature.class);

    public Pool(String string) {
        this.name = string;
        this.pool = new ArrayList<T>();
    }

    public String getName() {
        return this.name;
    }

    public T get(int n) {
        return this.pool.get(n);
    }

    public int indexOf(T t) {
        return this.pool.indexOf(t);
    }

    public void put(int n, T t) {
        if (n == this.pool.size()) {
            this.pool.add(t);
        } else {
            this.pool.set(n, t);
        }
    }

    public int size() {
        return this.pool.size();
    }

    public void logInfo(Logger logger) {
        logger.info("Pool " + this.name + " Entries: " + this.size());
    }

    public void setFeature(Feature feature, int n) {
        this.features.put(feature, n);
    }

    public int getFeature(Feature feature, int n) {
        Integer n2 = this.features.get((Object)feature);
        return n2 == null ? n : n2;
    }

    public static enum Feature {
        NUM_SENONES,
        NUM_GAUSSIANS_PER_STATE,
        NUM_STREAMS;

    }
}

