/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.CompositeSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.Utilities;

public class SenoneHMM
implements HMM {
    private final Unit unit;
    private final Unit baseUnit;
    private final SenoneSequence senoneSequence;
    private final float[][] transitionMatrix;
    private final HMMPosition position;
    private static int objectCount;
    private final HMMState[] hmmStates;

    public SenoneHMM(Unit unit, SenoneSequence senoneSequence, float[][] fArray, HMMPosition hMMPosition) {
        this.unit = unit;
        this.senoneSequence = senoneSequence;
        this.transitionMatrix = fArray;
        this.position = hMMPosition;
        Utilities.objectTracker("HMM", objectCount++);
        this.hmmStates = new HMMState[fArray.length];
        for (int i = 0; i < this.hmmStates.length; ++i) {
            this.hmmStates[i] = new SenoneHMMState(this, i);
        }
        this.baseUnit = unit.getBaseUnit();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public Unit getBaseUnit() {
        return this.baseUnit;
    }

    @Override
    public HMMState getState(int n) {
        return this.hmmStates[n];
    }

    @Override
    public int getOrder() {
        return this.getSenoneSequence().getSenones().length;
    }

    public SenoneSequence getSenoneSequence() {
        return this.senoneSequence;
    }

    public boolean isComposite() {
        Senone[] senoneArray;
        for (Senone senone : senoneArray = this.getSenoneSequence().getSenones()) {
            if (!(senone instanceof CompositeSenone)) continue;
            return true;
        }
        return false;
    }

    public float[][] getTransitionMatrix() {
        return this.transitionMatrix;
    }

    public float getTransitionProbability(int n, int n2) {
        return this.transitionMatrix[n][n2];
    }

    @Override
    public HMMPosition getPosition() {
        return this.position;
    }

    public boolean isFiller() {
        return this.unit.isFiller();
    }

    public boolean isContextDependent() {
        return this.unit.isContextDependent();
    }

    @Override
    public HMMState getInitialState() {
        return this.getState(0);
    }

    public String toString() {
        String string = this.isComposite() ? "HMM@" : "HMM";
        return string + '(' + this.unit + "):" + (Object)((Object)this.position);
    }

    public int hashCode() {
        return this.getSenoneSequence().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SenoneHMM) {
            SenoneHMM senoneHMM = (SenoneHMM)object;
            return this.getSenoneSequence().equals(senoneHMM.getSenoneSequence());
        }
        return false;
    }
}

