/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;

public class SenoneHMMState
implements HMMState {
    private final SenoneHMM hmm;
    private final int state;
    HMMStateArc[] arcs;
    private final boolean isEmitting;
    private Senone senone;
    private final int hashCode;
    private static int objectCount;

    SenoneHMMState(SenoneHMM senoneHMM, int n) {
        this.hmm = senoneHMM;
        this.state = n;
        boolean bl = this.isEmitting = senoneHMM.getTransitionMatrix().length - 1 != this.state;
        if (this.isEmitting) {
            SenoneSequence senoneSequence = senoneHMM.getSenoneSequence();
            this.senone = senoneSequence.getSenones()[this.state];
        }
        Utilities.objectTracker("HMMState", objectCount++);
        this.hashCode = senoneHMM.hashCode() + 37 * this.state;
    }

    @Override
    public HMM getHMM() {
        return this.hmm;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public float getScore(Data data) {
        return this.senone.getScore(data);
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        this.hmm.getSenoneSequence();
        return this.senone.calculateComponentScore(data);
    }

    public Senone getSenone() {
        return this.senone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SenoneHMMState)) {
            return false;
        }
        SenoneHMMState senoneHMMState = (SenoneHMMState)object;
        return this.hmm == senoneHMMState.hmm && this.state == senoneHMMState.state;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public final boolean isEmitting() {
        return this.isEmitting;
    }

    @Override
    public HMMStateArc[] getSuccessors() {
        if (this.arcs == null) {
            ArrayList<HMMStateArc> arrayList = new ArrayList<HMMStateArc>();
            float[][] fArray = this.hmm.getTransitionMatrix();
            for (int i = 0; i < fArray.length; ++i) {
                if (!(fArray[this.state][i] > -3.4028235E38f)) continue;
                HMMStateArc hMMStateArc = new HMMStateArc(this.hmm.getState(i), fArray[this.state][i]);
                arrayList.add(hMMStateArc);
            }
            this.arcs = arrayList.toArray(new HMMStateArc[arrayList.size()]);
        }
        return this.arcs;
    }

    @Override
    public boolean isExitState() {
        return !this.isEmitting;
    }

    public String toString() {
        return "HMMS " + this.hmm + " state " + this.state;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.senone.getMixtureComponents();
    }

    @Override
    public long getMixtureId() {
        return this.senone.getID();
    }

    @Override
    public float[] getLogMixtureWeights() {
        return this.senone.getLogMixtureWeights();
    }
}

