/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSet;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.PrunableMixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.SetBasedGaussianMixture;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sphinx3Loader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4String(mandatory=true)
    public static final String PROP_LOCATION = "location";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "mixtureComponentScoreFloor";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    @S4Integer(defaultValue=4)
    public static final String PROP_TOPN = "topGaussiansNum";
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    private static final int CONTEXT_SIZE = 1;
    protected Properties modelProps;
    protected Pool<float[]> meansPool;
    protected Pool<float[]> variancePool;
    protected Pool<float[][]> transitionsPool;
    protected GaussianWeights mixtureWeights;
    private int numStates;
    private int numStreams;
    private int numBase;
    private int numGaussiansPerState;
    private int[] vectorLength;
    private int[] senone2ci;
    protected Pool<float[][]> meanTransformationMatrixPool;
    protected Pool<float[]> meanTransformationVectorPool;
    protected Pool<float[][]> varianceTransformationMatrixPool;
    protected Pool<float[]> varianceTransformationVectorPool;
    protected float[][] transformMatrix;
    private MixtureComponentSet[] phoneticTiedMixtures;
    protected Pool<Senone> senonePool;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    protected LogMath logMath;
    private UnitManager unitManager;
    private boolean swap;
    private static final String DENSITY_FILE_VERSION = "1.0";
    private static final String MIXW_FILE_VERSION = "1.0";
    private static final String TMAT_FILE_VERSION = "1.0";
    private static final String TRANSFORM_FILE_VERSION = "0.1";
    protected Logger logger;
    private URL location;
    protected float distFloor;
    protected float mixtureWeightFloor;
    protected float varianceFloor;
    private int topGauNum;
    protected boolean useCDUnits;
    private boolean loaded;
    private long calculatedCheckSum = 0L;

    public Sphinx3Loader(URL uRL, UnitManager unitManager, float f, float f2, float f3, int n, boolean bl) {
        this.init(uRL, unitManager, f, f2, f3, n, bl, Logger.getLogger(this.getClass().getName()));
    }

    public Sphinx3Loader(String string, UnitManager unitManager, float f, float f2, float f3, int n, boolean bl) throws MalformedURLException, ClassNotFoundException {
        this.init(ConfigurationManagerUtils.resourceToURL(string), unitManager, f, f2, f3, n, bl, Logger.getLogger(this.getClass().getName()));
    }

    protected void init(URL uRL, UnitManager unitManager, float f, float f2, float f3, int n, boolean bl, Logger logger) {
        this.logMath = LogMath.getLogMath();
        this.location = uRL;
        this.logger = logger;
        this.unitManager = unitManager;
        this.distFloor = f;
        this.mixtureWeightFloor = f2;
        this.varianceFloor = f3;
        this.topGauNum = n;
        this.useCDUnits = bl;
    }

    public Sphinx3Loader() {
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public int getNumGaussiansPerState() {
        return this.numGaussiansPerState;
    }

    public int[] getVectorLength() {
        return this.vectorLength;
    }

    public int[] getSenone2Ci() {
        return this.senone2ci;
    }

    public String getLocation() {
        return this.location.getPath();
    }

    public boolean hasTiedMixtures() {
        String string = this.modelProps.getProperty("-model", "cont");
        return string.equals("ptm");
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.init(ConfigurationManagerUtils.getResource(PROP_LOCATION, propertySheet), (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER), propertySheet.getFloat(PROP_MC_FLOOR), propertySheet.getFloat(PROP_MW_FLOOR), propertySheet.getFloat(PROP_VARIANCE_FLOOR), propertySheet.getInt(PROP_TOPN), propertySheet.getBoolean(PROP_USE_CD_UNITS), propertySheet.getLogger());
    }

    protected InputStream getDataStream(String string) throws IOException, URISyntaxException {
        return new URL(Utilities.pathJoin(this.location.toString(), string)).openStream();
    }

    @Override
    public void load() throws IOException {
        if (!this.loaded) {
            TimerPool.getTimer(this, "Load AM").start();
            this.hmmManager = new HMMManager();
            this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
            this.meanTransformationMatrixPool = null;
            this.meanTransformationVectorPool = null;
            this.varianceTransformationMatrixPool = null;
            this.varianceTransformationVectorPool = null;
            this.transformMatrix = null;
            try {
                this.loadModelFiles();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            this.loaded = true;
            TimerPool.getTimer(this, "Load AM").stop();
        }
    }

    protected HMMManager getHmmManager() {
        return this.hmmManager;
    }

    protected Pool<float[][]> getMatrixPool() {
        return this.transitionsPool;
    }

    protected GaussianWeights getMixtureWeightsPool() {
        return this.mixtureWeights;
    }

    protected void loadModelFiles() throws IOException, URISyntaxException {
        this.meansPool = this.loadDensityFile("means", -3.4028235E38f);
        this.variancePool = this.loadDensityFile("variances", this.varianceFloor);
        this.mixtureWeights = this.loadMixtureWeights("mixture_weights", this.mixtureWeightFloor);
        this.transitionsPool = this.loadTransitionMatrices("transition_matrices");
        this.transformMatrix = this.loadTransformMatrix("feature_transform");
        this.modelProps = this.loadModelProps("feat.params");
        if (this.hasTiedMixtures()) {
            this.getSenoneToCIPhone();
            this.senonePool = this.createTiedSenonePool(this.distFloor, this.varianceFloor);
        } else {
            this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        }
        InputStream inputStream = this.getDataStream("mdef");
        if (inputStream == null) {
            throw new IOException("can't find model definition");
        }
        this.loadHMMPool(this.useCDUnits, inputStream);
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void getSenoneToCIPhone() throws IOException, URISyntaxException {
        InputStream inputStream = this.getDataStream("mdef");
        if (inputStream == null) {
            throw new IOException("can't find model definition");
        }
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.logger.fine("Loading HMM file from " + this.location);
        extendedStreamTokenizer.expectString(MODEL_VERSION);
        this.numBase = extendedStreamTokenizer.getInt("numBase");
        extendedStreamTokenizer.expectString("n_base");
        int n = extendedStreamTokenizer.getInt("numTri");
        extendedStreamTokenizer.expectString("n_tri");
        int n2 = extendedStreamTokenizer.getInt("numStateMap");
        extendedStreamTokenizer.expectString("n_state_map");
        int n3 = extendedStreamTokenizer.getInt("numTiedState");
        extendedStreamTokenizer.expectString("n_tied_state");
        this.senone2ci = new int[n3];
        extendedStreamTokenizer.getInt("numContextIndependentTiedState");
        extendedStreamTokenizer.expectString("n_tied_ci_state");
        int n4 = extendedStreamTokenizer.getInt("numTiedTransitionMatrices");
        extendedStreamTokenizer.expectString("n_tied_tmat");
        int n5 = n2 / (n + this.numBase);
        assert (n3 == this.mixtureWeights.getStatesNum());
        assert (n4 == this.transitionsPool.size());
        for (int i = 0; i < this.numBase + n; ++i) {
            int n6;
            for (n6 = 0; n6 < 5; ++n6) {
                extendedStreamTokenizer.getString();
            }
            n6 = extendedStreamTokenizer.getInt("tmat");
            for (int j = 0; j < n5 - 1; ++j) {
                this.senone2ci[extendedStreamTokenizer.getInt((String)"j")] = n6;
            }
            extendedStreamTokenizer.expectString("N");
            assert (n6 < n4);
        }
        extendedStreamTokenizer.close();
    }

    protected Pool<Senone> createSenonePool(float f, float f2) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int n = this.meansPool.size();
        int n2 = this.variancePool.size();
        int n3 = this.mixtureWeights.getGauPerState();
        int n4 = this.mixtureWeights.getStatesNum();
        int n5 = this.mixtureWeights.getStreamsNum();
        int n6 = 0;
        this.logger.fine("Senones " + n4);
        this.logger.fine("Gaussians Per Senone " + n3);
        this.logger.fine("Means " + n);
        this.logger.fine("Variances " + n2);
        assert (n3 > 0);
        assert (n2 == n4 * n3);
        assert (n == n4 * n3);
        float[][] fArray = this.meanTransformationMatrixPool == null ? (float[][])null : this.meanTransformationMatrixPool.get(0);
        float[] fArray2 = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] fArray3 = this.varianceTransformationMatrixPool == null ? (float[][])null : this.varianceTransformationMatrixPool.get(0);
        float[] fArray4 = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        for (int i = 0; i < n4; ++i) {
            MixtureComponent[] mixtureComponentArray = new MixtureComponent[n3 * n5];
            for (int j = 0; j < n3; ++j) {
                mixtureComponentArray[j] = new MixtureComponent(this.meansPool.get(n6), fArray, fArray2, this.variancePool.get(n6), fArray3, fArray4, f, f2);
                ++n6;
            }
            GaussianMixture gaussianMixture = new GaussianMixture(this.mixtureWeights, mixtureComponentArray, i);
            pool.put(i, gaussianMixture);
        }
        return pool;
    }

    private Pool<Senone> createTiedSenonePool(float f, float f2) {
        Serializable serializable;
        int n;
        Pool<Senone> pool = new Pool<Senone>("senones");
        int n2 = this.meansPool.size();
        int n3 = this.variancePool.size();
        int n4 = this.mixtureWeights.getGauPerState();
        int n5 = this.mixtureWeights.getStatesNum();
        int n6 = this.mixtureWeights.getStreamsNum();
        this.logger.fine("Senones " + n5);
        this.logger.fine("Gaussians Per State " + n4);
        this.logger.fine("Means " + n2);
        this.logger.fine("Variances " + n3);
        assert (n4 > 0);
        assert (n3 == this.numBase * n4 * n6);
        assert (n2 == this.numBase * n4 * n6);
        float[][] fArray = this.meanTransformationMatrixPool == null ? (float[][])null : this.meanTransformationMatrixPool.get(0);
        float[] fArray2 = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] fArray3 = this.varianceTransformationMatrixPool == null ? (float[][])null : this.varianceTransformationMatrixPool.get(0);
        float[] fArray4 = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        this.phoneticTiedMixtures = new MixtureComponentSet[this.numBase];
        for (n = 0; n < this.numBase; ++n) {
            serializable = new ArrayList<PrunableMixtureComponent[]>();
            for (int i = 0; i < n6; ++i) {
                PrunableMixtureComponent[] prunableMixtureComponentArray = new PrunableMixtureComponent[n4];
                for (int j = 0; j < n4; ++j) {
                    int n7 = n * n4 * n6 + i * n4 + j;
                    prunableMixtureComponentArray[j] = new PrunableMixtureComponent(this.meansPool.get(n7), fArray, fArray2, this.variancePool.get(n7), fArray3, fArray4, f, f2, j);
                }
                serializable.add(prunableMixtureComponentArray);
            }
            this.phoneticTiedMixtures[n] = new MixtureComponentSet((ArrayList<PrunableMixtureComponent[]>)serializable, this.topGauNum);
        }
        for (n = 0; n < n5; ++n) {
            serializable = new SetBasedGaussianMixture(this.mixtureWeights, this.phoneticTiedMixtures[this.senone2ci[n]], n);
            pool.put(n, (Senone)serializable);
        }
        return pool;
    }

    public Pool<float[]> loadDensityFile(String string, float f) throws IOException, URISyntaxException {
        int n;
        Properties properties = new Properties();
        int n2 = 0;
        DataInputStream dataInputStream = this.readS3BinaryHeader(string, properties);
        String string2 = properties.getProperty("version");
        if (string2 == null || !string2.equals("1.0")) {
            throw new IOException("Unsupported version in " + string);
        }
        String string3 = properties.getProperty("chksum0");
        boolean bl = string3 != null && string3.equals("yes");
        this.resetChecksum();
        int n3 = this.readInt(dataInputStream);
        int n4 = this.readInt(dataInputStream);
        int n5 = this.readInt(dataInputStream);
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = this.readInt(dataInputStream);
        }
        n = this.readInt(dataInputStream);
        this.logger.fine("Number of states " + n3);
        this.logger.fine("Number of streams " + n4);
        this.logger.fine("Number of gaussians per state " + n5);
        this.logger.fine("Vector length " + nArray.length);
        this.logger.fine("Raw length " + n);
        for (int i = 0; i < n4; ++i) {
            n2 += nArray[i];
        }
        assert (n == n5 * n2 * n3);
        Pool<float[]> pool = new Pool<float[]>(string);
        pool.setFeature(Pool.Feature.NUM_SENONES, n3);
        pool.setFeature(Pool.Feature.NUM_STREAMS, n4);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, n5);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n5; ++k) {
                    float[] fArray = this.readFloatArray(dataInputStream, nArray[j]);
                    Utilities.floorData(fArray, f);
                    pool.put(i * n4 * n5 + j * n5 + k, fArray);
                }
            }
        }
        this.validateChecksum(dataInputStream, bl);
        dataInputStream.close();
        this.numStates = n3;
        this.numStreams = n4;
        this.numGaussiansPerState = n5;
        this.vectorLength = nArray;
        return pool;
    }

    public DataInputStream readS3BinaryHeader(String string, Properties properties) throws IOException, URISyntaxException {
        String string2;
        InputStream inputStream = this.getDataStream(string);
        if (inputStream == null) {
            throw new IOException("Can't open " + string);
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        String string3 = this.readWord(dataInputStream);
        if (!string3.equals("s3")) {
            throw new IOException("Not proper s3 binary file " + string);
        }
        while ((string2 = this.readWord(dataInputStream)) != null && !string2.equals("endhdr")) {
            String string4 = this.readWord(dataInputStream);
            properties.setProperty(string2, string4);
        }
        int n = dataInputStream.readInt();
        if (n == 287454020) {
            this.logger.fine("Not swapping " + string);
            this.swap = false;
        } else if (Utilities.swapInteger(n) == 287454020) {
            this.logger.fine("Swapping  " + string);
            this.swap = true;
        } else {
            throw new IOException("Corrupted S3 file " + string);
        }
        return dataInputStream;
    }

    String readWord(DataInputStream dataInputStream) throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isWhitespace(c = this.readChar(dataInputStream))) {
        }
        do {
            stringBuilder.append(c);
        } while (!Character.isWhitespace(c = this.readChar(dataInputStream)));
        return stringBuilder.toString();
    }

    private char readChar(DataInputStream dataInputStream) throws IOException {
        return (char)dataInputStream.readByte();
    }

    private void resetChecksum() {
        this.calculatedCheckSum = 0L;
    }

    private void validateChecksum(DataInputStream dataInputStream, boolean bl) throws IOException {
        if (!bl) {
            return;
        }
        int n = (int)this.calculatedCheckSum;
        int n2 = this.readInt(dataInputStream);
        if (n2 != n) {
            throw new IOException("Invalid checksum " + Long.toHexString(this.calculatedCheckSum) + " must be " + Integer.toHexString(n2));
        }
    }

    public int readInt(DataInputStream dataInputStream) throws IOException {
        int n = this.swap ? Utilities.readLittleEndianInt(dataInputStream) : dataInputStream.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)n & 0xFFFFFFFFL;
        return n;
    }

    public float readFloat(DataInputStream dataInputStream) throws IOException {
        int n = this.swap ? Utilities.readLittleEndianInt(dataInputStream) : dataInputStream.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)n & 0xFFFFFFFFL;
        return Float.intBitsToFloat(n);
    }

    public float[] readFloatArray(DataInputStream dataInputStream, int n) throws IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.readFloat(dataInputStream);
        }
        return fArray;
    }

    protected void loadHMMPool(boolean bl, InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        Object object6;
        String string2;
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.logger.fine("Loading HMM file from: " + this.location);
        extendedStreamTokenizer.expectString(MODEL_VERSION);
        int n = extendedStreamTokenizer.getInt("numBase");
        extendedStreamTokenizer.expectString("n_base");
        int n2 = extendedStreamTokenizer.getInt("numTri");
        extendedStreamTokenizer.expectString("n_tri");
        int n3 = extendedStreamTokenizer.getInt("numStateMap");
        extendedStreamTokenizer.expectString("n_state_map");
        int n4 = extendedStreamTokenizer.getInt("numTiedState");
        extendedStreamTokenizer.expectString("n_tied_state");
        int n5 = extendedStreamTokenizer.getInt("numContextIndependentTiedState");
        extendedStreamTokenizer.expectString("n_tied_ci_state");
        int n6 = extendedStreamTokenizer.getInt("numTiedTransitionMatrices");
        extendedStreamTokenizer.expectString("n_tied_tmat");
        int n7 = n3 / (n2 + n);
        assert (n4 == this.mixtureWeights.getStatesNum());
        assert (n6 == this.transitionsPool.size());
        for (int i = 0; i < n; ++i) {
            string2 = extendedStreamTokenizer.getString();
            object6 = extendedStreamTokenizer.getString();
            object5 = extendedStreamTokenizer.getString();
            String string3 = extendedStreamTokenizer.getString();
            string = extendedStreamTokenizer.getString();
            int n8 = extendedStreamTokenizer.getInt("tmat");
            object4 = new int[n7 - 1];
            for (int j = 0; j < n7 - 1; ++j) {
                object4[j] = extendedStreamTokenizer.getInt("j");
                assert (object4[j] >= 0 && object4[j] < n5);
            }
            extendedStreamTokenizer.expectString("N");
            assert (((String)object6).equals("-"));
            assert (object5.equals("-"));
            assert (string3.equals("-"));
            assert (n8 < n6);
            object3 = this.unitManager.getUnit(string2, string.equals(FILLER));
            this.contextIndependentUnits.put(((Unit)object3).getName(), (Unit)object3);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + object3);
            }
            if (((Unit)object3).isFiller() && ((Unit)object3).getName().equals(SILENCE_CIPHONE)) {
                object3 = UnitManager.SILENCE;
            }
            object2 = this.transitionsPool.get(n8);
            SenoneSequence senoneSequence = this.getSenoneSequence((int[])object4);
            object = new SenoneHMM((Unit)object3, senoneSequence, (float[][])object2, HMMPosition.lookup(string3));
            this.hmmManager.put((HMM)object);
        }
        if (this.hmmManager.get(HMMPosition.UNDEFINED, UnitManager.SILENCE) == null) {
            throw new IOException("Could not find SIL unit in acoustic model");
        }
        String string4 = "";
        string2 = null;
        object6 = null;
        object5 = null;
        for (int i = 0; i < n2; ++i) {
            Object object7;
            Object object8;
            Unit[] unitArray;
            Object object9;
            string = extendedStreamTokenizer.getString();
            String string5 = extendedStreamTokenizer.getString();
            object4 = extendedStreamTokenizer.getString();
            object3 = extendedStreamTokenizer.getString();
            object2 = extendedStreamTokenizer.getString();
            int n9 = extendedStreamTokenizer.getInt("tmat");
            object = new int[n7 - 1];
            for (int j = 0; j < n7 - 1; ++j) {
                object[j] = extendedStreamTokenizer.getInt("j");
                assert (object[j] >= n5 && object[j] < n4);
            }
            extendedStreamTokenizer.expectString("N");
            assert (!string5.equals("-"));
            assert (!((String)object4).equals("-"));
            assert (!((String)object3).equals("-"));
            assert (((String)object2).equals("n/a"));
            assert (n9 < n6);
            if (!bl) continue;
            String string6 = string + ' ' + string5 + ' ' + (String)object4;
            if (string6.equals(string4)) {
                object9 = string2;
            } else {
                unitArray = new Unit[]{this.contextIndependentUnits.get(string5)};
                object8 = new Unit[]{this.contextIndependentUnits.get(object4)};
                object7 = LeftRightContext.get(unitArray, object8);
                object9 = this.unitManager.getUnit(string, false, (Context)object7);
            }
            string4 = string6;
            string2 = object9;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + object9);
            }
            unitArray = (Unit[])this.transitionsPool.get(n9);
            object8 = object5;
            if (object8 == null || !this.sameSenoneSequence((int[])object, (int[])object6)) {
                object8 = this.getSenoneSequence((int[])object);
            }
            object5 = object8;
            object6 = object;
            object7 = new SenoneHMM((Unit)object9, (SenoneSequence)object8, (float[][])unitArray, HMMPosition.lookup((String)object3));
            this.hmmManager.put((HMM)object7);
        }
        extendedStreamTokenizer.close();
    }

    protected boolean sameSenoneSequence(int[] nArray, int[] nArray2) {
        if (nArray.length == nArray2.length) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected SenoneSequence getSenoneSequence(int[] nArray) {
        Senone[] senoneArray = new Senone[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            senoneArray[i] = this.senonePool.get(nArray[i]);
        }
        return new SenoneSequence(senoneArray);
    }

    protected GaussianWeights loadMixtureWeights(String string, float f) throws IOException, URISyntaxException {
        this.logger.fine("Loading mixture weights from: " + string);
        Properties properties = new Properties();
        DataInputStream dataInputStream = this.readS3BinaryHeader(string, properties);
        String string2 = properties.getProperty("version");
        if (string2 == null || !string2.equals("1.0")) {
            throw new IOException("Unsupported version in " + string);
        }
        String string3 = properties.getProperty("chksum0");
        boolean bl = string3 != null && string3.equals("yes");
        this.resetChecksum();
        int n = this.readInt(dataInputStream);
        int n2 = this.readInt(dataInputStream);
        int n3 = this.readInt(dataInputStream);
        int n4 = this.readInt(dataInputStream);
        GaussianWeights gaussianWeights = new GaussianWeights(string, n, n3, n2);
        this.logger.fine("Number of states " + n);
        this.logger.fine("Number of streams " + n2);
        this.logger.fine("Number of gaussians per state " + n3);
        assert (n4 == n * n2 * n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float[] fArray = this.readFloatArray(dataInputStream, n3);
                Utilities.normalize(fArray);
                Utilities.floorData(fArray, f);
                this.logMath.linearToLog(fArray);
                gaussianWeights.put(i, j, fArray);
            }
        }
        this.validateChecksum(dataInputStream, bl);
        dataInputStream.close();
        return gaussianWeights;
    }

    protected Pool<float[][]> loadTransitionMatrices(String string) throws IOException, URISyntaxException {
        this.logger.fine("Loading transition matrices from: " + string);
        Properties properties = new Properties();
        DataInputStream dataInputStream = this.readS3BinaryHeader(string, properties);
        String string2 = properties.getProperty("version");
        if (string2 == null || !string2.equals("1.0")) {
            throw new IOException("Unsupported version in " + string);
        }
        String string3 = properties.getProperty("chksum0");
        boolean bl = string3 != null && string3.equals("yes");
        this.resetChecksum();
        Pool<float[][]> pool = new Pool<float[][]>(string);
        int n = this.readInt(dataInputStream);
        int n2 = this.readInt(dataInputStream);
        int n3 = this.readInt(dataInputStream);
        int n4 = this.readInt(dataInputStream);
        assert (n4 == n3 * n2 * n);
        for (int i = 0; i < n; ++i) {
            float[][] fArrayArray = new float[n3][];
            fArrayArray[n3 - 1] = new float[n3];
            this.logMath.linearToLog(fArrayArray[n3 - 1]);
            for (int j = 0; j < n2; ++j) {
                fArrayArray[j] = this.readFloatArray(dataInputStream, n3);
                Utilities.nonZeroFloor(fArrayArray[j], 0.0f);
                Utilities.normalize(fArrayArray[j]);
                this.logMath.linearToLog(fArrayArray[j]);
            }
            pool.put(i, fArrayArray);
        }
        this.validateChecksum(dataInputStream, bl);
        dataInputStream.close();
        return pool;
    }

    protected float[][] loadTransformMatrix(String string) throws IOException {
        DataInputStream dataInputStream;
        this.logger.fine("Loading transform matrix from: " + string);
        Properties properties = new Properties();
        try {
            dataInputStream = this.readS3BinaryHeader(string, properties);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        catch (IOException iOException) {
            return null;
        }
        String string2 = properties.getProperty("version");
        if (string2 == null || !string2.equals(TRANSFORM_FILE_VERSION)) {
            throw new IOException("Unsupported version in " + string);
        }
        String string3 = properties.getProperty("chksum0");
        boolean bl = string3 != null && string3.equals("yes");
        this.resetChecksum();
        this.readInt(dataInputStream);
        int n = this.readInt(dataInputStream);
        int n2 = this.readInt(dataInputStream);
        int n3 = this.readInt(dataInputStream);
        assert (n3 == n * n2);
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = this.readFloatArray(dataInputStream, n2);
        }
        this.validateChecksum(dataInputStream, bl);
        dataInputStream.close();
        return fArrayArray;
    }

    public void clearGauScores() {
        if (this.phoneticTiedMixtures == null) {
            return;
        }
        for (MixtureComponentSet mixtureComponentSet : this.phoneticTiedMixtures) {
            mixtureComponentSet.clearStoredScores();
        }
    }

    public void setGauScoresQueueLength(int n) {
        if (this.phoneticTiedMixtures == null) {
            return;
        }
        for (MixtureComponentSet mixtureComponentSet : this.phoneticTiedMixtures) {
            mixtureComponentSet.setScoreQueueLength(n);
        }
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.transitionsPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Loading tied-state acoustic model from: " + this.location);
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.transitionsPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        if (this.meanTransformationMatrixPool != null) {
            this.meanTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.meanTransformationVectorPool != null) {
            this.meanTransformationVectorPool.logInfo(this.logger);
        }
        if (this.varianceTransformationMatrixPool != null) {
            this.varianceTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.varianceTransformationVectorPool != null) {
            this.varianceTransformationVectorPool.logInfo(this.logger);
        }
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public Properties getProperties() {
        return this.modelProps;
    }

    protected Properties loadModelProps(String string) throws MalformedURLException, IOException, URISyntaxException {
        String string2;
        Properties properties = new Properties();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getDataStream(string)));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split(" ");
            properties.put(stringArray[0], stringArray[1]);
        }
        return properties;
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusteredDensityFileData) {
        for (int i = 0; i < this.meansPool.size(); ++i) {
            int n = clusteredDensityFileData.getClassIndex(i);
            float[] fArray = new float[this.getVectorLength()[0]];
            float[] fArray2 = this.meansPool.get(i);
            for (int j = 0; j < this.numStreams; ++j) {
                for (int k = 0; k < this.getVectorLength()[j]; ++k) {
                    fArray[k] = 0.0f;
                    for (int i2 = 0; i2 < this.getVectorLength()[j]; ++i2) {
                        int n2 = k;
                        fArray[n2] = fArray[n2] + transform.getAs()[n][j][k][i2] * fArray2[i2];
                    }
                    int n3 = k;
                    fArray[n3] = fArray[n3] + transform.getBs()[n][j][k];
                }
                System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            }
        }
    }
}

