/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.CompositeSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TiedStateAcousticModel
implements AcousticModel {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_COMPOSITES = "useComposites";
    protected String name;
    protected Logger logger;
    protected Loader loader;
    protected UnitManager unitManager;
    private boolean useComposites;
    private Properties properties;
    private final transient Map<String, SenoneSequence> compositeSenoneSequenceCache = new HashMap<String, SenoneSequence>();
    private boolean allocated;

    public TiedStateAcousticModel(Loader loader, UnitManager unitManager, boolean bl) {
        this.loader = loader;
        this.unitManager = unitManager;
        this.useComposites = bl;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public TiedStateAcousticModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.loader = (Loader)propertySheet.getComponent(PROP_LOADER);
        this.unitManager = (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER);
        this.useComposites = propertySheet.getBoolean(PROP_USE_COMPOSITES);
        this.logger = propertySheet.getLogger();
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.loader.load();
            this.logInfo();
            this.allocated = true;
        }
    }

    @Override
    public void deallocate() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HMM getCompositeHMM(Unit unit, HMMPosition hMMPosition) {
        Unit unit2 = this.unitManager.getUnit(unit.getName(), unit.isFiller(), Context.EMPTY_CONTEXT);
        SenoneSequence senoneSequence = this.getCompositeSenoneSequence(unit, hMMPosition);
        SenoneHMM senoneHMM = (SenoneHMM)this.lookupNearestHMM(unit2, HMMPosition.UNDEFINED, true);
        float[][] fArray = senoneHMM.getTransitionMatrix();
        return new SenoneHMM(unit, senoneSequence, fArray, hMMPosition);
    }

    @Override
    public HMM lookupNearestHMM(Unit unit, HMMPosition hMMPosition, boolean bl) {
        if (bl) {
            return this.lookupHMM(unit, hMMPosition);
        }
        HMMManager hMMManager = this.loader.getHMMManager();
        HMM hMM = hMMManager.get(hMMPosition, unit);
        if (hMM != null) {
            return hMM;
        }
        if (this.useComposites && hMM == null && this.isComposite(unit) && (hMM = this.getCompositeHMM(unit, hMMPosition)) != null) {
            hMMManager.put(hMM);
        }
        if (hMM == null) {
            hMM = this.getHMMAtAnyPosition(unit);
        }
        if (hMM == null) {
            hMM = this.getHMMInSilenceContext(unit, hMMPosition);
        }
        if (hMM == null) {
            Unit unit2 = this.lookupUnit(unit.getName());
            assert (unit.isContextDependent());
            if (unit2 == null) {
                this.logger.severe("Can't find HMM for " + unit.getName());
            }
            assert (unit2 != null);
            assert (!unit2.isContextDependent());
            hMM = hMMManager.get(HMMPosition.UNDEFINED, unit2);
        }
        assert (hMM != null);
        return hMM;
    }

    private boolean isComposite(Unit unit) {
        if (unit.isFiller()) {
            return false;
        }
        Context context = unit.getContext();
        if (context instanceof LeftRightContext) {
            LeftRightContext leftRightContext = (LeftRightContext)context;
            if (leftRightContext.getRightContext() == null) {
                return true;
            }
            if (leftRightContext.getLeftContext() == null) {
                return true;
            }
        }
        return false;
    }

    private Unit lookupUnit(String string) {
        return this.loader.getContextIndependentUnits().get(string);
    }

    @Override
    public Iterator<HMM> getHMMIterator() {
        return this.loader.getHMMManager().iterator();
    }

    @Override
    public Iterator<Unit> getContextIndependentUnitIterator() {
        return this.loader.getContextIndependentUnits().values().iterator();
    }

    public SenoneSequence getCompositeSenoneSequence(Unit unit, HMMPosition hMMPosition) {
        Object object;
        String string = unit.toString();
        SenoneSequence senoneSequence = this.compositeSenoneSequenceCache.get(string);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("getCompositeSenoneSequence: " + unit + senoneSequence == null ? "" : "Cached");
        }
        if (senoneSequence != null) {
            return senoneSequence;
        }
        Context context = unit.getContext();
        ArrayList<SenoneSequence> arrayList = new ArrayList<SenoneSequence>();
        Object object2 = this.getHMMIterator();
        while (object2.hasNext()) {
            Unit object3;
            object = (SenoneHMM)object2.next();
            if (((SenoneHMM)object).getPosition() != hMMPosition || !(object3 = ((SenoneHMM)object).getUnit()).isPartialMatch(unit.getName(), context)) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("collected: " + ((SenoneHMM)object).getUnit());
            }
            arrayList.add(((SenoneHMM)object).getSenoneSequence());
        }
        if (arrayList.isEmpty()) {
            object2 = this.unitManager.getUnit(unit.getName(), unit.isFiller());
            object = this.lookupHMM((Unit)object2, HMMPosition.UNDEFINED);
            arrayList.add(((SenoneHMM)object).getSenoneSequence());
        }
        int n = 0;
        for (SenoneSequence senoneSequence2 : arrayList) {
            if (senoneSequence2.getSenones().length <= n) continue;
            n = senoneSequence2.getSenones().length;
        }
        object = new ArrayList();
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            HashSet<Senone> hashSet = new HashSet<Senone>();
            for (SenoneSequence senoneSequence3 : arrayList) {
                if (i >= senoneSequence3.getSenones().length) continue;
                Senone senone = senoneSequence3.getSenones()[i];
                hashSet.add(senone);
            }
            object.add(CompositeSenone.create(hashSet, f));
        }
        senoneSequence = SenoneSequence.create((List<CompositeSenone>)object);
        this.compositeSenoneSequenceCache.put(unit.toString(), senoneSequence);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(unit + " consists of " + object.size() + " composite senones");
            if (this.logger.isLoggable(Level.FINEST)) {
                senoneSequence.dump("am");
            }
        }
        return senoneSequence;
    }

    @Override
    public int getLeftContextSize() {
        return this.loader.getLeftContextSize();
    }

    @Override
    public int getRightContextSize() {
        return this.loader.getRightContextSize();
    }

    private SenoneHMM lookupHMM(Unit unit, HMMPosition hMMPosition) {
        return (SenoneHMM)this.loader.getHMMManager().get(hMMPosition, unit);
    }

    public Senone getSenone(long l) {
        return this.loader.getSenonePool().get((int)l);
    }

    protected void logInfo() {
        if (this.loader != null) {
            this.loader.logInfo();
        }
        this.logger.info("CompositeSenoneSequences: " + this.compositeSenoneSequenceCache.size());
    }

    private SenoneHMM getHMMAtAnyPosition(Unit unit) {
        HMMManager hMMManager = this.loader.getHMMManager();
        for (HMMPosition hMMPosition : HMMPosition.values()) {
            SenoneHMM senoneHMM = (SenoneHMM)hMMManager.get(hMMPosition, unit);
            if (senoneHMM == null) continue;
            return senoneHMM;
        }
        return null;
    }

    private SenoneHMM getHMMInSilenceContext(Unit unit, HMMPosition hMMPosition) {
        SenoneHMM senoneHMM = null;
        HMMManager hMMManager = this.loader.getHMMManager();
        Context context = unit.getContext();
        if (context instanceof LeftRightContext) {
            LeftRightContext leftRightContext = (LeftRightContext)context;
            Unit[] unitArray = leftRightContext.getLeftContext();
            Unit[] unitArray2 = leftRightContext.getRightContext();
            Unit[] unitArray3 = this.hasNonSilenceFiller(unitArray) ? this.replaceNonSilenceFillerWithSilence(unitArray) : unitArray;
            Unit[] unitArray4 = this.hasNonSilenceFiller(unitArray2) ? this.replaceNonSilenceFillerWithSilence(unitArray2) : unitArray2;
            if (unitArray3 != unitArray || unitArray4 != unitArray2) {
                LeftRightContext leftRightContext2 = LeftRightContext.get(unitArray3, unitArray4);
                Unit unit2 = this.unitManager.getUnit(unit.getName(), unit.isFiller(), leftRightContext2);
                senoneHMM = (SenoneHMM)hMMManager.get(hMMPosition, unit2);
                if (senoneHMM == null) {
                    senoneHMM = this.getHMMAtAnyPosition(unit2);
                }
            }
        }
        return senoneHMM;
    }

    private boolean hasNonSilenceFiller(Unit[] unitArray) {
        if (unitArray == null) {
            return false;
        }
        for (Unit unit : unitArray) {
            if (!unit.isFiller() || unit.equals(UnitManager.SILENCE)) continue;
            return true;
        }
        return false;
    }

    private Unit[] replaceNonSilenceFillerWithSilence(Unit[] unitArray) {
        Unit[] unitArray2 = new Unit[unitArray.length];
        for (int i = 0; i < unitArray.length; ++i) {
            unitArray2[i] = unitArray[i].isFiller() && !unitArray[i].equals(UnitManager.SILENCE) ? UnitManager.SILENCE : unitArray[i];
        }
        return unitArray2;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties.load(TiedStateAcousticModel.class.getResource("model.props").openStream());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.properties;
    }
}

