/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.ScoreCachingSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.util.LogMath;
import java.util.Arrays;

public class DiagGmm
extends ScoreCachingSenone {
    private int id;
    private float[] gconsts;
    private float[] invVars;
    private float[] meansInvVars;

    public DiagGmm(int n, KaldiTextParser kaldiTextParser) {
        this.id = n;
        kaldiTextParser.expectToken("<DiagGMM>");
        kaldiTextParser.expectToken("<GCONSTS>");
        this.gconsts = kaldiTextParser.getFloatArray();
        kaldiTextParser.expectToken("<WEIGHTS>");
        kaldiTextParser.getFloatArray();
        kaldiTextParser.expectToken("<MEANS_INVVARS>");
        this.meansInvVars = kaldiTextParser.getFloatArray();
        kaldiTextParser.expectToken("<INV_VARS>");
        this.invVars = kaldiTextParser.getFloatArray();
        kaldiTextParser.expectToken("</DiagGMM>");
    }

    public int getId() {
        return this.id;
    }

    @Override
    public float calculateScore(Data data) {
        float f = -3.4028235E38f;
        LogMath logMath = LogMath.getLogMath();
        float[] fArray = this.calculateComponentScore(data);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float f2 = Float.valueOf(fArray[i]);
            f = logMath.addAsLinear(f, f2.floatValue());
        }
        return f;
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        int n;
        float[] fArray = FloatData.toFloatData(data).getValues();
        if (fArray.length != (n = this.meansInvVars.length / this.gconsts.length)) {
            String string = "feature vector must be of length %d, got %d";
            String string2 = String.format(string, n, fArray.length);
            throw new IllegalArgumentException(string2);
        }
        float[] fArray2 = Arrays.copyOf(this.gconsts, this.gconsts.length);
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                int n2 = i * fArray.length + j;
                int n3 = i;
                fArray2[n3] = fArray2[n3] + this.meansInvVars[n2] * fArray[j];
                int n4 = i;
                fArray2[n4] = fArray2[n4] - 0.5f * this.invVars[n2] * fArray[j] * fArray[j];
            }
            fArray2[i] = LogMath.getLogMath().lnToLog(fArray2[i]);
        }
        return fArray2;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void dump(String string) {
        System.out.format("%s DiagGmm: ID %d\n", string, this.id);
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return null;
    }

    @Override
    public float[] getLogMixtureWeights() {
        return null;
    }
}

