/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Scanner;

public class KaldiTextParser {
    private final Scanner scanner;

    public KaldiTextParser(String string) throws IOException, MalformedURLException {
        File file = new File(string, "final.mdl");
        InputStream inputStream = new URL(file.getPath()).openStream();
        File file2 = new File(string, "tree");
        InputStream inputStream2 = new URL(file2.getPath()).openStream();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        this.scanner = new Scanner(sequenceInputStream);
    }

    public String getToken() {
        return this.scanner.next();
    }

    public int getInt() {
        return this.scanner.nextInt();
    }

    public float parseFloat() {
        return this.scanner.nextFloat();
    }

    public int[] getIntArray() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : this.getTokenList("[", "]")) {
            arrayList.add(Integer.parseInt(string));
        }
        Object object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public float[] getFloatArray() {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (String string : this.getTokenList("[", "]")) {
            arrayList.add(Float.valueOf(Float.parseFloat(string)));
        }
        Object object = new float[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return object;
    }

    public List<String> getTokenList(String string, String string2) {
        String string3;
        this.expectToken(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!string2.equals(string3 = this.scanner.next())) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    public void expectToken(String string) {
        String string2 = this.scanner.next();
        this.assertToken(string, string2);
    }

    public void assertToken(String string, String string2) {
        if (string2.equals(string)) {
            return;
        }
        String string3 = String.format("'%s' expected, '%s' got", string, string2);
        throw new InputMismatchException(string3);
    }
}

