/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.HmmState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.Triple;
import edu.cmu.sphinx.util.LogMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransitionModel {
    private Map<Integer, List<HmmState>> phoneStates;
    private Map<Triple, Integer> transitionStates;
    private float[] logProbabilities;

    public TransitionModel(KaldiTextParser kaldiTextParser) {
        int n;
        kaldiTextParser.expectToken("<TransitionModel>");
        this.parseTopology(kaldiTextParser);
        kaldiTextParser.expectToken("<Triples>");
        this.transitionStates = new HashMap<Triple, Integer>();
        int n2 = kaldiTextParser.getInt();
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n = kaldiTextParser.getInt();
            int n4 = kaldiTextParser.getInt();
            int n5 = kaldiTextParser.getInt();
            Triple triple = new Triple(n, n4, n5);
            this.transitionStates.put(triple, n3);
            n3 += this.phoneStates.get(n).get(n4).getTransitions().size();
        }
        kaldiTextParser.expectToken("</Triples>");
        kaldiTextParser.expectToken("<LogProbs>");
        this.logProbabilities = kaldiTextParser.getFloatArray();
        kaldiTextParser.expectToken("</LogProbs>");
        kaldiTextParser.expectToken("</TransitionModel>");
        LogMath logMath = LogMath.getLogMath();
        for (n = 0; n < this.logProbabilities.length; ++n) {
            this.logProbabilities[n] = logMath.lnToLog(this.logProbabilities[n]);
        }
    }

    private void parseTopology(KaldiTextParser kaldiTextParser) {
        String string;
        kaldiTextParser.expectToken("<Topology>");
        this.phoneStates = new HashMap<Integer, List<HmmState>>();
        while ("<TopologyEntry>".equals(string = kaldiTextParser.getToken())) {
            kaldiTextParser.assertToken("<TopologyEntry>", string);
            kaldiTextParser.expectToken("<ForPhones>");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (!"</ForPhones>".equals(string = kaldiTextParser.getToken())) {
                arrayList.add(Integer.parseInt(string));
            }
            ArrayList<HmmState> arrayList2 = new ArrayList<HmmState>(3);
            while ("<State>".equals(string = kaldiTextParser.getToken())) {
                int n = kaldiTextParser.getInt();
                string = kaldiTextParser.getToken();
                if (!"<PdfClass>".equals(string)) continue;
                int n2 = kaldiTextParser.getInt();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                while ("<Transition>".equals(string = kaldiTextParser.getToken())) {
                    arrayList3.add(kaldiTextParser.getInt());
                    kaldiTextParser.getToken();
                }
                kaldiTextParser.assertToken("</State>", string);
                arrayList2.add(new HmmState(n, n2, arrayList3));
            }
            for (Integer n : arrayList) {
                this.phoneStates.put(n, arrayList2);
            }
        }
        kaldiTextParser.assertToken("</Topology>", string);
    }

    public float[][] getTransitionMatrix(int n, int[] nArray) {
        float[][] fArray = new float[4][4];
        Arrays.fill(fArray[3], -3.4028235E38f);
        for (HmmState hmmState : this.phoneStates.get(n)) {
            int n2 = hmmState.getId();
            Arrays.fill(fArray[n2], -3.4028235E38f);
            Triple triple = new Triple(n, n2, nArray[n2]);
            int n3 = this.transitionStates.get(triple);
            for (Integer n4 : hmmState.getTransitions()) {
                fArray[n2][n4.intValue()] = this.logProbabilities[n3++];
            }
        }
        return fArray;
    }
}

