/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSetScores;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.PrunableMixtureComponent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class MixtureComponentSet {
    private int scoresQueueLen;
    private boolean toStoreScore;
    private LinkedList<MixtureComponentSetScores> storedScores;
    MixtureComponentSetScores curScores;
    private ArrayList<PrunableMixtureComponent[]> components;
    private ArrayList<PrunableMixtureComponent[]> topComponents;
    private int numStreams;
    private int topGauNum;
    private int gauNum;
    private long gauCalcSampleNumber;
    private Comparator<PrunableMixtureComponent> componentComparator = new Comparator<PrunableMixtureComponent>(){

        @Override
        public int compare(PrunableMixtureComponent prunableMixtureComponent, PrunableMixtureComponent prunableMixtureComponent2) {
            return (int)(prunableMixtureComponent.getStoredScore() - prunableMixtureComponent2.getStoredScore());
        }
    };

    public MixtureComponentSet(ArrayList<PrunableMixtureComponent[]> arrayList, int n) {
        this.components = arrayList;
        this.numStreams = arrayList.size();
        this.topGauNum = n;
        this.gauNum = arrayList.get(0).length;
        this.topComponents = new ArrayList();
        for (int i = 0; i < this.numStreams; ++i) {
            PrunableMixtureComponent[] prunableMixtureComponentArray = new PrunableMixtureComponent[n];
            for (int j = 0; j < n; ++j) {
                prunableMixtureComponentArray[j] = arrayList.get(i)[j];
            }
            this.topComponents.add(prunableMixtureComponentArray);
        }
        this.gauCalcSampleNumber = -1L;
        this.toStoreScore = false;
        this.storedScores = new LinkedList();
        this.curScores = null;
    }

    private void storeScores(MixtureComponentSetScores mixtureComponentSetScores) {
        this.storedScores.add(mixtureComponentSetScores);
        while (this.storedScores.size() > this.scoresQueueLen) {
            this.storedScores.poll();
        }
    }

    private MixtureComponentSetScores getStoredScores(long l) {
        if (this.storedScores.isEmpty()) {
            return null;
        }
        if (this.storedScores.peekLast().getFrameStartSample() < l) {
            return null;
        }
        for (MixtureComponentSetScores mixtureComponentSetScores : this.storedScores) {
            if (mixtureComponentSetScores.getFrameStartSample() != l) continue;
            return mixtureComponentSetScores;
        }
        return null;
    }

    private MixtureComponentSetScores createFromTopGau(long l) {
        MixtureComponentSetScores mixtureComponentSetScores = new MixtureComponentSetScores(this.numStreams, this.topGauNum, l);
        for (int i = 0; i < this.numStreams; ++i) {
            for (int j = 0; j < this.topGauNum; ++j) {
                mixtureComponentSetScores.setScore(i, j, this.topComponents.get(i)[j].getStoredScore());
                mixtureComponentSetScores.setGauId(i, j, this.topComponents.get(i)[j].getId());
            }
        }
        return mixtureComponentSetScores;
    }

    private void insertTopComponent(PrunableMixtureComponent[] prunableMixtureComponentArray, PrunableMixtureComponent prunableMixtureComponent) {
        for (int i = 0; i < prunableMixtureComponentArray.length - 1; ++i) {
            if (prunableMixtureComponent.getPartialScore() < prunableMixtureComponentArray[i].getPartialScore()) {
                prunableMixtureComponentArray[i - 1] = prunableMixtureComponent;
                return;
            }
            prunableMixtureComponentArray[i] = prunableMixtureComponentArray[i + 1];
        }
        if (prunableMixtureComponent.getPartialScore() < prunableMixtureComponentArray[prunableMixtureComponentArray.length - 1].getPartialScore()) {
            prunableMixtureComponentArray[prunableMixtureComponentArray.length - 2] = prunableMixtureComponent;
        } else {
            prunableMixtureComponentArray[prunableMixtureComponentArray.length - 1] = prunableMixtureComponent;
        }
    }

    private boolean isInTopComponents(PrunableMixtureComponent[] prunableMixtureComponentArray, PrunableMixtureComponent prunableMixtureComponent) {
        for (PrunableMixtureComponent prunableMixtureComponent2 : prunableMixtureComponentArray) {
            if (prunableMixtureComponent2.getId() != prunableMixtureComponent.getId()) continue;
            return true;
        }
        return false;
    }

    private void updateTopScores(float[] fArray) {
        int n = fArray.length / this.numStreams;
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.numStreams; ++i) {
            System.arraycopy(fArray, i * n, fArray2, 0, n);
            PrunableMixtureComponent[] prunableMixtureComponentArray = this.topComponents.get(i);
            PrunableMixtureComponent[] prunableMixtureComponentArray2 = this.components.get(i);
            for (PrunableMixtureComponent prunableMixtureComponent : prunableMixtureComponentArray) {
                prunableMixtureComponent.updateScore(fArray2);
            }
            Arrays.sort(prunableMixtureComponentArray, this.componentComparator);
            float f = prunableMixtureComponentArray[0].getPartialScore();
            for (PrunableMixtureComponent prunableMixtureComponent : prunableMixtureComponentArray2) {
                if (this.isInTopComponents(prunableMixtureComponentArray, prunableMixtureComponent) || !prunableMixtureComponent.isTopComponent(fArray2, f)) continue;
                this.insertTopComponent(prunableMixtureComponentArray, prunableMixtureComponent);
                f = prunableMixtureComponentArray[0].getPartialScore();
            }
        }
    }

    public void updateTopScores(Data data) {
        if (data instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        long l = FloatData.toFloatData(data).getFirstSampleNumber();
        if (this.toStoreScore) {
            this.curScores = this.getStoredScores(l);
        } else if (this.curScores != null && this.curScores.getFrameStartSample() != l) {
            this.curScores = null;
        }
        if (this.curScores != null) {
            return;
        }
        float[] fArray = FloatData.toFloatData(data).getValues();
        this.updateTopScores(fArray);
        this.curScores = this.createFromTopGau(l);
        if (this.toStoreScore) {
            this.storeScores(this.curScores);
        }
    }

    private void updateScores(float[] fArray) {
        int n = fArray.length / this.numStreams;
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.numStreams; ++i) {
            System.arraycopy(fArray, i * n, fArray2, 0, n);
            for (PrunableMixtureComponent prunableMixtureComponent : this.components.get(i)) {
                prunableMixtureComponent.updateScore(fArray2);
            }
        }
    }

    public void updateScores(Data data) {
        long l;
        if (data instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        if (this.gauCalcSampleNumber != (l = FloatData.toFloatData(data).getFirstSampleNumber())) {
            float[] fArray = FloatData.toFloatData(data).getValues();
            this.updateScores(fArray);
            this.gauCalcSampleNumber = l;
        }
    }

    public void clearStoredScores() {
        this.storedScores.clear();
    }

    public void setScoreQueueLength(int n) {
        this.toStoreScore = n > 0;
        this.scoresQueueLen = n;
    }

    public int getTopGauNum() {
        return this.topGauNum;
    }

    public int getGauNum() {
        return this.gauNum;
    }

    public float getTopGauScore(int n, int n2) {
        return this.curScores.getScore(n, n2);
    }

    public int getTopGauId(int n, int n2) {
        return this.curScores.getGauId(n, n2);
    }

    public float getGauScore(int n, int n2) {
        return this.components.get(n)[n2].getStoredScore();
    }

    public int getGauId(int n, int n2) {
        return this.components.get(n)[n2].getId();
    }

    private <T> T[] concatenate(T[] TArray, T[] TArray2) {
        int n = TArray.length;
        int n2 = TArray2.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n + n2);
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray2, 0, objectArray, n, n2);
        return objectArray;
    }

    protected MixtureComponent[] toArray() {
        MixtureComponent[] mixtureComponentArray = new PrunableMixtureComponent[]{};
        for (int i = 0; i < this.numStreams; ++i) {
            this.concatenate(mixtureComponentArray, (Object[])this.components.get(i));
        }
        return mixtureComponentArray;
    }

    protected int dimension() {
        int n = 0;
        for (int i = 0; i < this.numStreams; ++i) {
            n += this.components.get(i)[0].getMean().length;
        }
        return n;
    }

    protected int size() {
        int n = 0;
        for (int i = 0; i < this.numStreams; ++i) {
            n += this.components.get(0).length;
        }
        return n;
    }
}

