/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSet;

public class SetBasedGaussianMixture
extends GaussianMixture {
    private MixtureComponentSet mixtureComponentSet;

    public SetBasedGaussianMixture(GaussianWeights gaussianWeights, MixtureComponentSet mixtureComponentSet, int n) {
        super(gaussianWeights, null, n);
        this.mixtureComponentSet = mixtureComponentSet;
    }

    @Override
    public float calculateScore(Data data) {
        this.mixtureComponentSet.updateTopScores(data);
        float f = 0.0f;
        for (int i = 0; i < this.mixtureWeights.getStreamsNum(); ++i) {
            float f2 = -3.4028235E38f;
            for (int j = 0; j < this.mixtureComponentSet.getTopGauNum(); ++j) {
                float f3 = this.mixtureComponentSet.getTopGauScore(i, j);
                int n = this.mixtureComponentSet.getTopGauId(i, j);
                f2 = this.logMath.addAsLinear(f2, f3 + this.mixtureWeights.get(this.id, i, n));
            }
            f += f2;
        }
        return f;
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        this.mixtureComponentSet.updateScores(data);
        float[] fArray = new float[this.mixtureComponentSet.size()];
        int n = 0;
        for (int i = 0; i < this.mixtureWeights.getStreamsNum(); ++i) {
            for (int j = 0; j < this.mixtureComponentSet.getGauNum(); ++j) {
                fArray[n++] = this.mixtureComponentSet.getGauScore(i, j) + this.mixtureWeights.get(this.id, i, this.mixtureComponentSet.getGauId(i, j));
            }
        }
        return fArray;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponentSet.toArray();
    }

    @Override
    public int dimension() {
        return this.mixtureComponentSet.dimension();
    }

    @Override
    public int numComponents() {
        return this.mixtureComponentSet.size();
    }
}

