/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.util.LogMath;

class Buffer {
    private double[] numerator;
    private double denominator;
    private boolean wasUsed;
    private boolean isLog;
    private int id;

    Buffer(int n, boolean bl, int n2) {
        this.id = n2;
        this.isLog = bl;
        this.wasUsed = false;
        this.numerator = new double[n];
        if (bl) {
            this.denominator = -3.4028234663852886E38;
            for (int i = 0; i < n; ++i) {
                this.numerator[i] = -3.4028234663852886E38;
            }
        }
    }

    void accumulate(float f, int n) {
        assert (false);
        assert (this.numerator != null);
        assert (!this.isLog);
        int n2 = n;
        this.numerator[n2] = this.numerator[n2] + (double)f;
        this.denominator += (double)f;
        this.wasUsed = true;
    }

    void logAccumulate(float f, int n, LogMath logMath) {
        assert (this.numerator != null);
        assert (this.isLog);
        this.numerator[n] = logMath.addAsLinear((float)this.numerator[n], f);
        this.denominator = logMath.addAsLinear((float)this.denominator, f);
        this.wasUsed = true;
    }

    void accumulate(double[] dArray, double d) {
        assert (this.numerator != null);
        assert (dArray != null);
        assert (this.numerator.length == dArray.length);
        assert (!this.isLog);
        for (int i = 0; i < this.numerator.length; ++i) {
            int n = i;
            this.numerator[n] = this.numerator[n] + dArray[i];
        }
        this.denominator += d;
        this.wasUsed = true;
    }

    void logAccumulate(float[] fArray, float f, LogMath logMath) {
        assert (this.numerator != null);
        assert (fArray != null);
        assert (this.numerator.length == fArray.length);
        assert (this.isLog);
        for (int i = 0; i < this.numerator.length; ++i) {
            this.numerator[i] = logMath.addAsLinear((float)this.numerator[i], fArray[i]);
        }
        this.denominator = logMath.addAsLinear((float)this.denominator, f);
        this.wasUsed = true;
    }

    void normalize() {
        assert (!this.isLog);
        if (this.denominator == 0.0) {
            System.out.println("Empty denominator: " + this.id);
            this.wasUsed = false;
            return;
        }
        double d = 1.0 / this.denominator;
        int n = 0;
        while (n < this.numerator.length) {
            int n2 = n++;
            this.numerator[n2] = this.numerator[n2] * d;
        }
        this.denominator = 1.0;
    }

    void logNormalize() {
        assert (this.isLog);
        int n = 0;
        while (n < this.numerator.length) {
            int n2 = n++;
            this.numerator[n2] = this.numerator[n2] - this.denominator;
        }
        this.denominator = 0.0;
    }

    void logNormalizeNonZero(float[] fArray) {
        assert (this.isLog);
        assert (fArray.length == this.numerator.length);
        for (int i = 0; i < this.numerator.length; ++i) {
            if (fArray[i] == -3.4028235E38f) continue;
            int n = i;
            this.numerator[n] = this.numerator[n] - this.denominator;
        }
        this.denominator = 0.0;
    }

    void normalizeToSum() {
        assert (!this.isLog);
        float f = 0.0f;
        for (double d : this.numerator) {
            f = (float)((double)f + d);
        }
        float f2 = (float)(1.0 / (double)f);
        int n = 0;
        while (n < this.numerator.length) {
            int n2 = n++;
            this.numerator[n2] = this.numerator[n2] * (double)f2;
        }
        this.denominator = 1.0;
    }

    void logNormalizeToSum(LogMath logMath) {
        float f;
        assert (this.isLog);
        float f2 = f = -3.4028235E38f;
        for (double d : this.numerator) {
            if (d == (double)f) continue;
            f2 = logMath.addAsLinear(f2, (float)d);
        }
        for (int i = 0; i < this.numerator.length; ++i) {
            if (this.numerator[i] == (double)f) continue;
            int n = i;
            this.numerator[n] = this.numerator[n] - (double)f2;
        }
        this.denominator = 0.0;
    }

    protected boolean floor(float f) {
        assert (!this.isLog);
        boolean bl = false;
        for (int i = 0; i < this.numerator.length; ++i) {
            if (!(this.numerator[i] < (double)f)) continue;
            bl = true;
            this.numerator[i] = f;
        }
        return bl;
    }

    protected boolean logFloor(float f) {
        assert (this.isLog);
        boolean bl = false;
        for (int i = 0; i < this.numerator.length; ++i) {
            if (!(this.numerator[i] < (double)f)) continue;
            bl = true;
            this.numerator[i] = f;
        }
        return bl;
    }

    protected float getValue(int n) {
        return (float)this.numerator[n];
    }

    protected void setValue(int n, float f) {
        this.numerator[n] = f;
    }

    protected float[] getValues() {
        float[] fArray = new float[this.numerator.length];
        for (int i = 0; i < this.numerator.length; ++i) {
            fArray[i] = (float)this.numerator[i];
        }
        return fArray;
    }

    protected boolean wasUsed() {
        return this.wasUsed;
    }

    public void dump() {
        System.out.println("Denominator= " + this.denominator);
        System.out.println("Numerators= ");
        for (int i = 0; i < this.numerator.length; ++i) {
            System.out.println("[" + i + "]= " + this.numerator[i]);
        }
    }
}

