/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StreamFactory;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4String;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModelInitializerLoader
implements Loader {
    private static final String SILENCE_CIPHONE = "SIL";
    public static final String MODEL_VERSION = "0.3";
    private static final int CONTEXT_SIZE = 1;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private int vectorLength = 39;
    private Map<String, Unit> contextIndependentUnits;
    private Map<String, Integer> phoneList;
    private HMMManager hmmManager;
    @S4String(defaultValue="model")
    public static final String MODEL_NAME = "modelName";
    @S4String(defaultValue=".")
    public static final String LOCATION = "location";
    @S4String(defaultValue="phonelist")
    public static final String PHONE_LIST = "phones";
    @S4String(defaultValue="data")
    public static final String DATA_DIR = "dataDir";
    @S4String(defaultValue="model.props")
    public static final String PROP_FILE = "propsFile";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    private UnitManager unitManager;
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    private LogMath logMath;
    private Logger logger;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        this.logger = propertySheet.getLogger();
        this.unitManager = (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER);
        this.hmmManager = new HMMManager();
        this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
        this.phoneList = new LinkedHashMap<String, Integer>();
        this.meanTransformationMatrixPool = this.createDummyMatrixPool("meanTransformationMatrix");
        this.meanTransformationVectorPool = this.createDummyVectorPool("meanTransformationMatrix");
        this.varianceTransformationMatrixPool = this.createDummyMatrixPool("varianceTransformationMatrix");
        this.varianceTransformationVectorPool = this.createDummyVectorPool("varianceTransformationMatrix");
        String string = propertySheet.getString(MODEL_NAME);
        String string2 = propertySheet.getString(LOCATION);
        String string3 = propertySheet.getString(PHONE_LIST);
        String string4 = propertySheet.getString(DATA_DIR);
        this.logger.info("Creating Sphinx3 acoustic model: " + string);
        this.logger.info("    Path      : " + string2);
        this.logger.info("    phonelist : " + string3);
        this.logger.info("    dataDir   : " + string4);
        boolean bl = propertySheet.getBoolean(PROP_USE_CD_UNITS);
        assert (!bl);
        try {
            this.loadPhoneList(propertySheet, bl, StreamFactory.getInputStream(string2, string3), string2 + File.separator + string3);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            this.printPhoneListHelp();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printPhoneListHelp() {
        System.out.println("The format for the phone list file is:");
        System.out.println("\tversion 0.1");
        System.out.println("\tsame_sized_models yes");
        System.out.println("\tn_state 3");
        System.out.println("\ttmat_skip (no|yes)");
        System.out.println("\tAA");
        System.out.println("\tAE");
        System.out.println("\tAH");
        System.out.println("\t...");
        System.out.println("Or:");
        System.out.println("\tversion 0.1");
        System.out.println("\tsame_sized_models no");
        System.out.println("\ttmat_skip (no|yes)");
        System.out.println("\tAA 5");
        System.out.println("\tAE 3");
        System.out.println("\tAH 4");
        System.out.println("\t...");
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void addModelToSenonePool(Pool<Senone> pool, int[] nArray, float f, float f2) {
        assert (pool != null);
        int n = this.mixtureWeights.getGauPerState();
        assert (n > 0);
        for (int n2 : nArray) {
            MixtureComponent[] mixtureComponentArray = new MixtureComponent[n];
            for (int i = 0; i < n; ++i) {
                int n3 = n2 * n + i;
                mixtureComponentArray[i] = new MixtureComponent(this.meansPool.get(n3), this.meanTransformationMatrixPool.get(0), this.meanTransformationVectorPool.get(0), this.variancePool.get(n3), this.varianceTransformationMatrixPool.get(0), this.varianceTransformationVectorPool.get(0), f, f2);
            }
            GaussianMixture gaussianMixture = new GaussianMixture(this.mixtureWeights, mixtureComponentArray, n2);
            pool.put(n2, gaussianMixture);
        }
    }

    private void addModelToDensityPool(Pool<float[]> pool, int[] nArray, int n, int n2) throws IOException {
        assert (pool != null);
        assert (nArray != null);
        int n3 = nArray.length;
        int n4 = pool.getFeature(Pool.Feature.NUM_SENONES, 0);
        pool.setFeature(Pool.Feature.NUM_SENONES, n3 + n4);
        n4 = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        if (n4 == -1) {
            pool.setFeature(Pool.Feature.NUM_STREAMS, n);
        } else assert (n4 == n);
        n4 = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        if (n4 == -1) {
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, n2);
        } else assert (n4 == n2);
        assert (n == 1);
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                float[] fArray = new float[this.vectorLength];
                int n6 = n5 * n2 + j;
                pool.put(n6, fArray);
            }
        }
    }

    private void floorData(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
        }
    }

    private void normalize(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        if (f != 0.0f) {
            f = 1.0f / f;
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = fArray[i] * f;
            }
        }
    }

    private void loadPhoneList(PropertySheet propertySheet, boolean bl, InputStream inputStream, String string) throws IOException {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.meansPool = new Pool("means");
        this.variancePool = new Pool("variances");
        this.matrixPool = new Pool("transitionmatrices");
        this.senonePool = new Pool("senones");
        float f = propertySheet.getFloat(PROP_MC_FLOOR);
        float f2 = propertySheet.getFloat(PROP_MW_FLOOR);
        float f3 = 0.0f;
        float f4 = propertySheet.getFloat(PROP_VARIANCE_FLOOR);
        this.logger.info("Loading phone list file from: ");
        this.logger.info(string);
        String string2 = "0.1";
        extendedStreamTokenizer.expectString("version");
        extendedStreamTokenizer.expectString(string2);
        extendedStreamTokenizer.expectString("same_sized_models");
        boolean bl2 = extendedStreamTokenizer.getString().equals("yes");
        if (bl2) {
            extendedStreamTokenizer.expectString("n_state");
            n = extendedStreamTokenizer.getInt("numBase");
        }
        extendedStreamTokenizer.expectString("tmat_skip");
        boolean bl3 = extendedStreamTokenizer.getString().equals("yes");
        int n4 = 0;
        int n5 = 0;
        while (true) {
            String string3 = extendedStreamTokenizer.getString();
            if (extendedStreamTokenizer.isEOF()) break;
            int n6 = n;
            if (!bl2) {
                n6 = extendedStreamTokenizer.getInt("ModelSize");
            }
            this.phoneList.put(string3, n6);
            this.logger.fine("Phone: " + string3 + " size: " + n6);
            int[] nArray = new int[n6];
            String string4 = "-";
            for (int i = 0; i < n6; ++i) {
                nArray[i] = n4++;
            }
            Unit unit = this.unitManager.getUnit(string3, string3.equals(SILENCE_CIPHONE));
            this.contextIndependentUnits.put(unit.getName(), unit);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit + " with " + n6 + " states");
            }
            this.addModelToDensityPool(this.meansPool, nArray, n2, n3);
            this.addModelToDensityPool(this.variancePool, nArray, n2, n3);
            this.addModelToTransitionMatrixPool(this.matrixPool, n5, nArray.length, f3, bl3);
            this.addModelToSenonePool(this.senonePool, nArray, f, f4);
            float[][] fArray = this.matrixPool.get(n5);
            SenoneSequence senoneSequence = this.getSenoneSequence(nArray);
            SenoneHMM senoneHMM = new SenoneHMM(unit, senoneSequence, fArray, HMMPosition.lookup(string4));
            this.hmmManager.put(senoneHMM);
            ++n5;
        }
        this.mixtureWeights = this.initMixtureWeights(n4, n2, n3, f2);
        extendedStreamTokenizer.close();
    }

    private SenoneSequence getSenoneSequence(int[] nArray) {
        Senone[] senoneArray = new Senone[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            senoneArray[i] = this.senonePool.get(nArray[i]);
        }
        return new SenoneSequence(senoneArray);
    }

    private GaussianWeights initMixtureWeights(int n, int n2, int n3, float f) {
        assert (n2 == 1);
        GaussianWeights gaussianWeights = new GaussianWeights("mixtureweights", n, n3, n2);
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[n3];
            this.floorData(fArray, f);
            this.normalize(fArray);
            this.logMath.linearToLog(fArray);
            gaussianWeights.put(i, 0, fArray);
        }
        return gaussianWeights;
    }

    private void addModelToTransitionMatrixPool(Pool<float[][]> pool, int n, int n2, float f, boolean bl) throws IOException {
        assert (pool != null);
        int n3 = n2 + 1;
        float[][] fArray = new float[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                fArray[i][j] = 0.0f;
                if (i >= n3 - 1) continue;
                if (j == i || j == i + 1) {
                    fArray[i][j] = f;
                }
                if (!bl || j != i + 2) continue;
                fArray[i][j] = f;
            }
            this.normalize(fArray[i]);
            this.logMath.linearToLog(fArray[i]);
        }
        pool.put(n, fArray);
    }

    private Pool<float[][]> createDummyMatrixPool(String string) {
        Pool<float[][]> pool = new Pool<float[][]>(string);
        float[][] fArray = new float[this.vectorLength][this.vectorLength];
        this.logger.info("creating dummy matrix pool " + string);
        for (int i = 0; i < this.vectorLength; ++i) {
            for (int j = 0; j < this.vectorLength; ++j) {
                fArray[i][j] = i == j ? 1.0f : 0.0f;
            }
        }
        pool.put(0, fArray);
        return pool;
    }

    private Pool<float[]> createDummyVectorPool(String string) {
        this.logger.info("creating dummy vector pool " + string);
        Pool<float[]> pool = new Pool<float[]>(string);
        float[] fArray = new float[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            fArray[i] = 0.0f;
        }
        pool.put(0, fArray);
        return pool;
    }

    @Override
    public void load() throws IOException {
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.matrixPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return null;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Sphinx3Loader");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.meanTransformationMatrixPool.logInfo(this.logger);
        this.meanTransformationVectorPool.logInfo(this.logger);
        this.varianceTransformationMatrixPool.logInfo(this.logger);
        this.varianceTransformationVectorPool.logInfo(this.logger);
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusteredDensityFileData) {
    }
}

