/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Saver;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StreamFactory;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sphinx3Saver
implements Saver {
    @S4Boolean(defaultValue=true)
    public static final String PROP_SPARSE_FORM = "sparseForm";
    protected boolean sparseForm;
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Component(type=Loader.class)
    public static final String LOADER = "loader";
    @S4Integer(defaultValue=39)
    public static final String PROP_VECTOR_LENGTH = "vectorLength";
    protected Logger logger;
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    protected static final int CONTEXT_SIZE = 1;
    private String checksum;
    private boolean doCheckSum;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private int vectorLength;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    protected LogMath logMath;
    private boolean binary;
    private String location;
    private boolean swap;
    protected static final String DENSITY_FILE_VERSION = "1.0";
    protected static final String MIXW_FILE_VERSION = "1.0";
    protected static final String TMAT_FILE_VERSION = "1.0";
    @S4String(defaultValue=".")
    public static final String SAVE_LOCATION = "saveLocation";
    @S4String(mandatory=false, defaultValue="")
    public static final String DATA_LOCATION = "dataLocation";
    private String dataDir;
    @S4String(mandatory=false, defaultValue="")
    public static final String DEF_FILE = "definitionFile";
    public boolean useCDUnits;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.location = propertySheet.getString(SAVE_LOCATION);
        this.dataDir = propertySheet.getString(DATA_LOCATION);
        this.sparseForm = propertySheet.getBoolean(PROP_SPARSE_FORM);
        this.useCDUnits = propertySheet.getBoolean(PROP_USE_CD_UNITS);
        this.logMath = LogMath.getLogMath();
        this.vectorLength = propertySheet.getInt(PROP_VECTOR_LENGTH);
        Loader loader = (Loader)propertySheet.getComponent(LOADER);
        this.hmmManager = loader.getHMMManager();
        this.meansPool = loader.getMeansPool();
        this.variancePool = loader.getVariancePool();
        this.mixtureWeights = loader.getMixtureWeights();
        this.matrixPool = loader.getTransitionMatrixPool();
        this.senonePool = loader.getSenonePool();
        this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
        this.checksum = "no";
        this.doCheckSum = this.checksum != null && this.checksum.equals("yes");
        this.swap = false;
    }

    protected String getCheckSum() {
        return this.checksum;
    }

    protected boolean getDoCheckSum() {
        return this.doCheckSum;
    }

    protected String getLocation() {
        return this.location;
    }

    @Override
    public void save(String string, boolean bl) throws IOException {
        this.logger.info("Saving acoustic model: " + string);
        this.logger.info("    Path      : " + this.location);
        this.logger.info("    modellName: " + string);
        this.logger.info("    dataDir   : " + this.dataDir);
        if (this.binary) {
            this.saveDensityFileBinary(this.meansPool, this.dataDir + "means", true);
            this.saveDensityFileBinary(this.variancePool, this.dataDir + "variances", true);
            this.saveMixtureWeightsBinary(this.mixtureWeights, this.dataDir + "mixture_weights", true);
            this.saveTransitionMatricesBinary(this.matrixPool, this.dataDir + "transition_matrices", true);
        } else {
            this.saveDensityFileAscii(this.meansPool, this.dataDir + "means.ascii", true);
            this.saveDensityFileAscii(this.variancePool, this.dataDir + "variances.ascii", true);
            this.saveMixtureWeightsAscii(this.mixtureWeights, this.dataDir + "mixture_weights.ascii", true);
            this.saveTransitionMatricesAscii(this.matrixPool, this.dataDir + "transition_matrices.ascii", true);
        }
        this.saveHMMPool(this.useCDUnits, StreamFactory.getOutputStream(this.location, "mdef", true), this.location + File.separator + "mdef");
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void saveDensityFileAscii(Pool<float[]> pool, String string, boolean bl) throws FileNotFoundException, IOException {
        this.logger.info("Saving density file to: ");
        this.logger.info(string);
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, string, bl);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + string);
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.print("param ");
        int n = pool.getFeature(Pool.Feature.NUM_SENONES, -1);
        printWriter.print(n + " ");
        int n2 = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        printWriter.print(n2 + " ");
        int n3 = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        printWriter.println(n3);
        for (int i = 0; i < n; ++i) {
            printWriter.println("mgau " + i);
            printWriter.println("feat 0");
            for (int j = 0; j < n3; ++j) {
                printWriter.print("density \t" + j);
                int n4 = i * n3 + j;
                float[] fArray = pool.get(n4);
                for (int k = 0; k < this.vectorLength; ++k) {
                    printWriter.print(" " + fArray[k]);
                }
                printWriter.println();
            }
        }
        outputStream.close();
    }

    private void saveDensityFileBinary(Pool<float[]> pool, String string, boolean bl) throws FileNotFoundException, IOException {
        int n;
        Properties properties = new Properties();
        int n2 = 0;
        this.logger.info("Saving density file to: ");
        this.logger.info(string);
        properties.setProperty("version", "1.0");
        properties.setProperty("chksum0", this.checksum);
        DataOutputStream dataOutputStream = this.writeS3BinaryHeader(this.location, string, properties, bl);
        int n3 = pool.getFeature(Pool.Feature.NUM_SENONES, -1);
        int n4 = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        int n5 = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        this.writeInt(dataOutputStream, n3);
        this.writeInt(dataOutputStream, n4);
        this.writeInt(dataOutputStream, n5);
        int n6 = 0;
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = this.vectorLength;
            this.writeInt(dataOutputStream, nArray[n]);
            n6 += n5 * n3 * nArray[n];
        }
        assert (n4 == 1);
        assert (n6 == n5 * n3 * this.vectorLength);
        this.writeInt(dataOutputStream, n6);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n7 = n * n4 * n5 + i * n5 + j;
                    float[] fArray = pool.get(n7);
                    this.writeFloatArray(dataOutputStream, fArray);
                }
            }
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        this.writeInt(dataOutputStream, n2);
        dataOutputStream.close();
    }

    protected DataOutputStream writeS3BinaryHeader(String string, String string2, Properties properties, boolean bl) throws IOException {
        OutputStream outputStream = StreamFactory.getOutputStream(string, string2, bl);
        if (this.doCheckSum) assert (false) : "Checksum not supported";
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.writeWord(dataOutputStream, "s3\n");
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            this.writeWord(dataOutputStream, string3 + ' ' + string4 + '\n');
        }
        this.writeWord(dataOutputStream, "endhdr\n");
        this.writeInt(dataOutputStream, 287454020);
        return dataOutputStream;
    }

    void writeWord(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeBytes(string);
    }

    protected void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        if (this.swap) {
            dataOutputStream.writeInt(Utilities.swapInteger(n));
        } else {
            dataOutputStream.writeInt(n);
        }
    }

    protected void writeFloat(DataOutputStream dataOutputStream, float f) throws IOException {
        if (this.swap) {
            dataOutputStream.writeFloat(Utilities.swapFloat(f));
        } else {
            dataOutputStream.writeFloat(f);
        }
    }

    protected void writeFloatArray(DataOutputStream dataOutputStream, float[] fArray) throws IOException {
        for (float f : fArray) {
            this.writeFloat(dataOutputStream, f);
        }
    }

    private void saveHMMPool(boolean bl, OutputStream outputStream, String string) throws FileNotFoundException, IOException {
        Senone[] senoneArray;
        Object object;
        String string2;
        String string3;
        Object object2;
        Object object3;
        Object object4;
        Unit unit;
        SenoneHMM senoneHMM;
        this.logger.info("Saving HMM file to: ");
        this.logger.info(string);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + string);
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (HMM hMM : this.hmmManager) {
            n4 += hMM.getOrder() + 1;
            if (((SenoneHMM)hMM).isContextDependent()) {
                ++n2;
                continue;
            }
            ++n;
            n3 += hMM.getOrder();
        }
        printWriter.println(MODEL_VERSION);
        printWriter.println(n + " n_base");
        printWriter.println(n2 + " n_tri");
        printWriter.println(n4 + " n_state_map");
        int n5 = this.mixtureWeights.getStatesNum();
        printWriter.println(n5 + " n_tied_state");
        printWriter.println(n3 + " n_tied_ci_state");
        int n6 = n;
        assert (n6 == this.matrixPool.size());
        printWriter.println(n6 + " n_tied_tmat");
        printWriter.println("#");
        printWriter.println("# Columns definitions");
        printWriter.println("#base lft  rt p attrib tmat      ... state id's ...");
        for (HMM hMM : this.hmmManager) {
            senoneHMM = (SenoneHMM)hMM;
            if (senoneHMM.isContextDependent()) continue;
            unit = senoneHMM.getUnit();
            object4 = unit.getName();
            printWriter.print((String)object4 + '\t');
            object3 = "-";
            printWriter.print((String)object3 + "   ");
            object2 = "-";
            printWriter.print((String)object2 + ' ');
            string3 = senoneHMM.getPosition().toString();
            printWriter.print(string3 + '\t');
            string2 = unit.isFiller() ? FILLER : "n/a";
            printWriter.print(string2 + '\t');
            int n7 = this.matrixPool.indexOf(senoneHMM.getTransitionMatrix());
            assert (n7 < n6);
            printWriter.print(n7 + "\t");
            object = senoneHMM.getSenoneSequence();
            for (Senone senoneArray2 : senoneArray = ((SenoneSequence)object).getSenones()) {
                int n8 = this.senonePool.indexOf(senoneArray2);
                assert (n8 >= 0 && n8 < n3);
                printWriter.print(n8 + "\t");
            }
            printWriter.println("N");
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Saved " + unit);
        }
        for (HMM hMM : this.hmmManager) {
            Senone[] senoneArray3;
            senoneHMM = (SenoneHMM)hMM;
            if (!senoneHMM.isContextDependent()) continue;
            unit = senoneHMM.getUnit();
            object4 = (LeftRightContext)unit.getContext();
            object3 = ((LeftRightContext)object4).getLeftContext();
            object2 = ((LeftRightContext)object4).getRightContext();
            assert (((Unit[])object3).length == 1 && ((Unit[])object2).length == 1);
            string3 = unit.getName();
            printWriter.print(string3 + '\t');
            string2 = object3[0].getName();
            printWriter.print(string2 + "   ");
            String string4 = object2[0].getName();
            printWriter.print(string4 + ' ');
            object = senoneHMM.getPosition().toString();
            printWriter.print((String)object + '\t');
            Object object5 = senoneArray = unit.isFiller() ? "filler" : "n/a";
            assert (senoneArray.equals("n/a"));
            printWriter.print((String)senoneArray + '\t');
            int n9 = this.matrixPool.indexOf(senoneHMM.getTransitionMatrix());
            assert (n9 < n6);
            printWriter.print(n9 + "\t");
            SenoneSequence senoneSequence = senoneHMM.getSenoneSequence();
            for (Senone senone : senoneArray3 = senoneSequence.getSenones()) {
                int n10 = this.senonePool.indexOf(senone);
                assert (n10 >= 0 && n10 < n5);
                printWriter.print(n10 + "\t");
            }
            printWriter.println("N");
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Saved " + unit);
        }
        outputStream.close();
    }

    private void saveMixtureWeightsAscii(GaussianWeights gaussianWeights, String string, boolean bl) throws FileNotFoundException, IOException {
        this.logger.info("Saving mixture weights to: ");
        this.logger.info(string);
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, string, bl);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + string);
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.print("mixw ");
        int n = gaussianWeights.getStatesNum();
        printWriter.print(n + " ");
        int n2 = gaussianWeights.getStreamsNum();
        printWriter.print(n2 + " ");
        int n3 = gaussianWeights.getGauPerState();
        printWriter.println(n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4;
                printWriter.print("mixw [" + i + " " + j + "] ");
                float[] fArray = new float[n3];
                float[] fArray2 = new float[n3];
                for (int k = 0; k < n3; ++k) {
                    fArray2[k] = gaussianWeights.get(i, j, k);
                }
                this.logMath.logToLinear(fArray2, fArray);
                float f = 0.0f;
                for (n4 = 0; n4 < n3; ++n4) {
                    f += fArray[n4];
                }
                printWriter.println(f);
                printWriter.print("\n\t");
                for (n4 = 0; n4 < n3; ++n4) {
                    printWriter.print(" " + fArray[n4]);
                }
                printWriter.println();
            }
        }
        outputStream.close();
    }

    private void saveMixtureWeightsBinary(GaussianWeights gaussianWeights, String string, boolean bl) throws FileNotFoundException, IOException {
        this.logger.info("Saving mixture weights to: ");
        this.logger.info(string);
        Properties properties = new Properties();
        properties.setProperty("version", "1.0");
        if (this.doCheckSum) {
            properties.setProperty("chksum0", this.checksum);
        }
        DataOutputStream dataOutputStream = this.writeS3BinaryHeader(this.location, string, properties, bl);
        int n = gaussianWeights.getStatesNum();
        int n2 = gaussianWeights.getStreamsNum();
        int n3 = gaussianWeights.getGauPerState();
        this.writeInt(dataOutputStream, n);
        this.writeInt(dataOutputStream, n2);
        this.writeInt(dataOutputStream, n3);
        assert (n2 == 1);
        int n4 = n3 * n * n2;
        this.writeInt(dataOutputStream, n4);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float[] fArray = new float[n3];
                float[] fArray2 = new float[n3];
                for (int k = 0; k < n3; ++k) {
                    fArray2[k] = gaussianWeights.get(i, j, k);
                }
                this.logMath.logToLinear(fArray2, fArray);
                this.writeFloatArray(dataOutputStream, fArray);
            }
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        dataOutputStream.close();
    }

    protected void saveTransitionMatricesAscii(Pool<float[][]> pool, String string, boolean bl) throws FileNotFoundException, IOException {
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, string, bl);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + string);
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        this.logger.info("Saving transition matrices to: ");
        this.logger.info(string);
        int n = pool.size();
        assert (n > 0);
        float[][] fArray = pool.get(0);
        int n2 = fArray[0].length;
        printWriter.println("tmat " + n + ' ' + n2);
        for (int i = 0; i < n; ++i) {
            printWriter.println("tmat [" + i + ']');
            fArray = pool.get(i);
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (j < n2 - 1) {
                        if (this.sparseForm) {
                            if (k < j) {
                                printWriter.print("\t");
                            }
                            if (k == j || k == j + 1) {
                                printWriter.print((float)this.logMath.logToLinear(fArray[j][k]));
                            }
                        } else {
                            printWriter.print((float)this.logMath.logToLinear(fArray[j][k]));
                        }
                        if (n2 - 1 == k) {
                            printWriter.println();
                        } else {
                            printWriter.print(" ");
                        }
                    }
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.fine("tmat j " + j + " k " + k + " tm " + fArray[j][k]);
                }
            }
        }
        outputStream.close();
    }

    protected void saveTransitionMatricesBinary(Pool<float[][]> pool, String string, boolean bl) throws IOException {
        this.logger.info("Saving transition matrices to: ");
        this.logger.info(string);
        Properties properties = new Properties();
        properties.setProperty("version", "1.0");
        if (this.doCheckSum) {
            properties.setProperty("chksum0", this.checksum);
        }
        DataOutputStream dataOutputStream = this.writeS3BinaryHeader(this.location, string, properties, bl);
        int n = pool.size();
        assert (n > 0);
        this.writeInt(dataOutputStream, n);
        float[][] fArray = pool.get(0);
        int n2 = fArray[0].length;
        int n3 = n2 - 1;
        this.writeInt(dataOutputStream, n3);
        this.writeInt(dataOutputStream, n2);
        int n4 = n2 * n3 * n;
        this.writeInt(dataOutputStream, n4);
        for (int i = 0; i < n; ++i) {
            int n5;
            fArray = pool.get(i);
            float[] fArray2 = fArray[n2 - 1];
            float[] fArray3 = new float[fArray2.length];
            for (n5 = 0; n5 < n2; ++n5) {
                assert (fArray3[n5] == 0.0f);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                fArray2 = fArray[n5];
                fArray3 = new float[fArray2.length];
                this.logMath.logToLinear(fArray2, fArray3);
                this.writeFloatArray(dataOutputStream, fArray3);
            }
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        dataOutputStream.close();
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Sphinx3Saver");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.meanTransformationMatrixPool.logInfo(this.logger);
        this.meanTransformationVectorPool.logInfo(this.logger);
        this.varianceTransformationMatrixPool.logInfo(this.logger);
        this.varianceTransformationVectorPool.logInfo(this.logger);
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }
}

