/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Saver;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.TiedStateAcousticModel;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.HMMPoolManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4String;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TrainerAcousticModel
extends TiedStateAcousticModel {
    @S4Component(type=Saver.class)
    public static final String SAVER = "saver";
    private Saver saver;
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    @S4String(defaultValue="sphinx3.binary")
    public static final String PROP_FORMAT_SAVE = "saveFormat";
    public String saveFormat;
    public static final int ALL_MODELS = -1;
    private HMMPoolManager hmmPoolManager;

    public TrainerAcousticModel(Loader loader, UnitManager unitManager, boolean bl, Saver saver, String string) throws IOException {
        super(loader, unitManager, bl);
        this.saver = saver;
        this.hmmPoolManager = new HMMPoolManager(loader);
        this.saveFormat = string;
        this.logInfo();
    }

    public TrainerAcousticModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.saver = (Saver)propertySheet.getComponent(SAVER);
        try {
            this.hmmPoolManager = new HMMPoolManager(this.loader);
        }
        catch (IOException iOException) {
            throw new PropertyException(iOException);
        }
        this.saveFormat = propertySheet.getString(PROP_FORMAT_SAVE);
        this.logInfo();
    }

    public void save(String string) throws IOException {
        this.saver.save(string, true);
        this.logger.info("saved models with " + this.saver);
    }

    public void load() throws IOException, FileNotFoundException {
        this.logInfo();
        this.hmmPoolManager = new HMMPoolManager(this.loader);
    }

    public void resetBuffers() {
        this.hmmPoolManager.resetBuffers();
    }

    public void accumulate(int n, TrainerScore[] trainerScoreArray, TrainerScore[] trainerScoreArray2) {
        this.hmmPoolManager.accumulate(n, trainerScoreArray, trainerScoreArray2);
    }

    public void accumulate(int n, TrainerScore[] trainerScoreArray) {
        this.hmmPoolManager.accumulate(n, trainerScoreArray);
    }

    public void updateLogLikelihood() {
        this.hmmPoolManager.updateLogLikelihood();
    }

    public float normalize() {
        float f = this.hmmPoolManager.normalize();
        this.hmmPoolManager.update();
        return f;
    }
}

