/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;

public class TrainerScore {
    private Data feature;
    private float logOutputProbability;
    private float logScalingFactor;
    private int senoneID;
    private HMMState hmmState;
    private Senone senone;
    private float logAlpha;
    private float logBeta;
    private float logGamma;
    private float[] logComponentGamma;
    private float[] logComponentProb;
    private static float logLikelihood;

    public TrainerScore(Data data, float f, int n) {
        this.feature = data;
        this.logOutputProbability = f;
        this.senoneID = n;
        this.logScalingFactor = 0.0f;
        this.logAlpha = 0.0f;
        this.logBeta = 0.0f;
        this.logGamma = 0.0f;
        this.logComponentProb = new float[1];
        this.logComponentProb[0] = 0.0f;
        this.logComponentGamma = new float[1];
        this.logComponentGamma[0] = 0.0f;
    }

    public TrainerScore(Data data, float f, HMMState hMMState, float f2, float f3, float[] fArray) {
        int n;
        this.feature = data;
        this.hmmState = hMMState;
        this.logScalingFactor = 0.0f;
        if (hMMState != null && hMMState.isEmitting()) {
            n = hMMState.getState();
            SenoneHMM senoneHMM = (SenoneHMM)hMMState.getHMM();
            SenoneSequence senoneSequence = senoneHMM.getSenoneSequence();
            this.senone = senoneSequence.getSenones()[n];
        }
        this.logOutputProbability = f;
        this.logAlpha = f2;
        this.logBeta = f3;
        this.logGamma = f2 + f3;
        if (fArray != null) {
            this.logComponentProb = new float[fArray.length];
            this.logComponentGamma = new float[fArray.length];
            for (n = 0; n < fArray.length; ++n) {
                this.logComponentProb[n] = fArray[n];
                this.logComponentGamma[n] = fArray[n] + this.logGamma;
            }
        } else {
            this.logComponentProb = null;
            this.logComponentGamma = null;
        }
    }

    public TrainerScore(Data data, float f, HMMState hMMState, float f2, float[] fArray) {
        this(data, f, hMMState, f2, 0.0f, fArray);
    }

    public TrainerScore(Data data, float f, HMMState hMMState, float[] fArray) {
        this(data, f, hMMState, 0.0f, 0.0f, fArray);
    }

    public TrainerScore(Data data, float f, HMMState hMMState) {
        this(data, f, hMMState, 0.0f, 0.0f, null);
    }

    public Data getData() {
        return this.feature;
    }

    public float getScore() {
        return this.logOutputProbability;
    }

    public float getAlpha() {
        return this.logAlpha;
    }

    public float getBeta() {
        return this.logBeta;
    }

    public static float getLogLikelihood() {
        return logLikelihood;
    }

    public float getGamma() {
        return this.logGamma;
    }

    public float[] getComponentGamma() {
        return this.logComponentGamma;
    }

    public float getScalingFactor() {
        return this.logScalingFactor;
    }

    public static void setLogLikelihood(float f) {
        logLikelihood = f;
    }

    public void setAlpha(float f) {
        this.logAlpha = f;
    }

    public void setBeta(float f) {
        this.logBeta = f;
    }

    public void setGamma() {
        this.logGamma = this.logAlpha + this.logBeta + this.logScalingFactor;
        if (this.logComponentGamma != null) {
            for (int i = 0; i < this.logComponentGamma.length; ++i) {
                this.logComponentGamma[i] = this.logComponentProb[i] + this.logGamma;
                if (!(this.logComponentGamma[i] < -3.4028235E38f)) continue;
                this.logComponentGamma[i] = -3.4028235E38f;
            }
        }
    }

    public void setScalingFactor(float f) {
        this.logScalingFactor = f;
    }

    public int getSenoneID() {
        return this.senoneID;
    }

    public Senone getSenone() {
        return this.senone;
    }

    public HMMState getState() {
        return this.hmmState;
    }
}

