/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.trivial;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;

class TrivialHMMState
implements HMMState {
    private static final HMMStateArc[] EMPTY_ARC = new HMMStateArc[0];
    private final HMM hmm;
    private final int which;
    private final boolean isFinal;

    TrivialHMMState(HMM hMM, int n, boolean bl) {
        this.hmm = hMM;
        this.which = n;
        this.isFinal = bl;
    }

    @Override
    public HMM getHMM() {
        return this.hmm;
    }

    @Override
    public int getState() {
        return this.which;
    }

    @Override
    public float getScore(Data data) {
        return 0.0f;
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        return new float[((FloatData)data).getValues().length];
    }

    @Override
    public boolean isEmitting() {
        return !this.isFinal;
    }

    @Override
    public HMMStateArc[] getSuccessors() {
        if (this.isFinal) {
            return EMPTY_ARC;
        }
        HMMStateArc[] hMMStateArcArray = new HMMStateArc[]{new HMMStateArc(this, 0.0f), new HMMStateArc(this.hmm.getState(this.which + 1), 0.0f)};
        return hMMStateArcArray;
    }

    @Override
    public boolean isExitState() {
        return this.isFinal;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return null;
    }

    @Override
    public long getMixtureId() {
        return 0L;
    }

    @Override
    public float[] getLogMixtureWeights() {
        return null;
    }
}

