/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.aflat;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPool;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.aflat.PhoneLoop;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class AFlatLinguist
implements Linguist,
Configurable {
    @S4Component(type=Grammar.class)
    public static final String GRAMMAR = "grammar";
    @S4Component(type=UnitManager.class)
    public static final String UNIT_MANAGER = "unitManager";
    @S4Component(type=AcousticModel.class)
    public static final String ACOUSTIC_MODEL = "acousticModel";
    @S4Boolean(defaultValue=false)
    public static final String ADD_OUT_OF_GRAMMAR_BRANCH = "addOutOfGrammarBranch";
    @S4Double(defaultValue=1.0)
    public static final String OUT_OF_GRAMMAR_PROBABILITY = "outOfGrammarProbability";
    @S4Double(defaultValue=1.0)
    public static final String PHONE_INSERTION_PROBABILITY = "phoneInsertionProbability";
    @S4Component(type=AcousticModel.class)
    public static final String PHONE_LOOP_ACOUSTIC_MODEL = "phoneLoopAcousticModel";
    private Grammar grammar;
    private AcousticModel acousticModel;
    private AcousticModel phoneLoopAcousticModel;
    private UnitManager unitManager;
    private float logWordInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logUnitInsertionProbability;
    private float logFillerInsertionProbability;
    private float languageWeight;
    private float logOutOfGrammarBranchProbability;
    private float logPhoneInsertionProbability;
    private boolean addOutOfGrammarBranch;
    private SearchGraph searchGraph;
    private Logger logger;
    private HMMPool hmmPool;
    SearchStateArc outOfGrammarGraph;
    public Runtime runtime = Runtime.getRuntime();
    private long counterForMemoryLogging = 0L;
    private Map<GrammarNode, int[]> nodeToNextUnitArrayMap;
    private Map<GrammarNode, Set<Unit>> nodeToUnitSetMap;
    private final SearchStateArc[] EMPTY_ARCS = new SearchStateArc[0];
    final Map<SearchState, SearchStateArc[]> successorCache = new HashMap<SearchState, SearchStateArc[]>();

    public AFlatLinguist(AcousticModel acousticModel, Grammar grammar, UnitManager unitManager, double d, double d2, double d3, double d4, float f, boolean bl, double d5, double d6, AcousticModel acousticModel2) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.acousticModel = acousticModel;
        this.grammar = grammar;
        this.unitManager = unitManager;
        LogMath logMath = LogMath.getLogMath();
        this.logWordInsertionProbability = logMath.linearToLog(d);
        this.logSilenceInsertionProbability = logMath.linearToLog(d2);
        this.logUnitInsertionProbability = logMath.linearToLog(d3);
        this.logFillerInsertionProbability = logMath.linearToLog(d4);
        this.languageWeight = f;
        this.addOutOfGrammarBranch = bl;
        this.logOutOfGrammarBranchProbability = logMath.linearToLog(d5);
        this.logPhoneInsertionProbability = logMath.linearToLog(this.logPhoneInsertionProbability);
        if (bl) {
            this.phoneLoopAcousticModel = acousticModel2;
        }
    }

    public AFlatLinguist() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.acousticModel = (AcousticModel)propertySheet.getComponent(ACOUSTIC_MODEL);
        this.grammar = (Grammar)propertySheet.getComponent(GRAMMAR);
        this.unitManager = (UnitManager)propertySheet.getComponent(UNIT_MANAGER);
        LogMath logMath = LogMath.getLogMath();
        this.logWordInsertionProbability = logMath.linearToLog(propertySheet.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = logMath.linearToLog(propertySheet.getDouble("silenceInsertionProbability"));
        this.logUnitInsertionProbability = logMath.linearToLog(propertySheet.getDouble("unitInsertionProbability"));
        this.logFillerInsertionProbability = logMath.linearToLog(propertySheet.getDouble("fillerInsertionProbability"));
        this.languageWeight = propertySheet.getFloat("languageWeight");
        this.addOutOfGrammarBranch = propertySheet.getBoolean(ADD_OUT_OF_GRAMMAR_BRANCH);
        this.logOutOfGrammarBranchProbability = logMath.linearToLog(propertySheet.getDouble(OUT_OF_GRAMMAR_PROBABILITY));
        this.logPhoneInsertionProbability = logMath.linearToLog(propertySheet.getDouble(PHONE_INSERTION_PROBABILITY));
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel = (AcousticModel)propertySheet.getComponent(PHONE_LOOP_ACOUSTIC_MODEL);
        }
    }

    @Override
    public SearchGraph getSearchGraph() {
        this.logger.info("Generated Search Graph");
        this.logger.info("Total Memory= " + this.runtime.totalMemory() / 0x100000L + " MB");
        this.logger.info("Free Memory = " + this.runtime.freeMemory() / 0x100000L + " MB");
        return this.searchGraph;
    }

    protected void setupAcousticModel(PropertySheet propertySheet) throws PropertyException {
        this.acousticModel = (AcousticModel)propertySheet.getComponent(ACOUSTIC_MODEL);
    }

    @Override
    public void allocate() throws IOException {
        this.logger.info("Allocating DFLAT");
        this.allocateAcousticModel();
        this.grammar.allocate();
        this.hmmPool = new HMMPool(this.acousticModel, this.logger, this.unitManager);
        this.nodeToNextUnitArrayMap = new HashMap<GrammarNode, int[]>();
        this.nodeToUnitSetMap = new HashMap<GrammarNode, Set<Unit>>();
        Timer timer = TimerPool.getTimer(this, "compileGrammar");
        timer.start();
        this.compileGrammar();
        timer.stop();
        this.logger.info("Done allocating  DFLAT");
    }

    protected void allocateAcousticModel() throws IOException {
        this.acousticModel.allocate();
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel.allocate();
        }
    }

    @Override
    public void deallocate() {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        this.grammar.deallocate();
    }

    public float getLogSilenceInsertionProbability() {
        return this.logSilenceInsertionProbability;
    }

    private void compileGrammar() {
        this.logger.info("Compiling Grammar");
        Set<GrammarNode> set = this.grammar.getGrammarNodes();
        for (GrammarNode grammarNode : set) {
            this.initUnitMaps(grammarNode);
        }
        this.logger.info("Free Memory before generating Search Graph= " + this.runtime.freeMemory() / 0x100000L + " MB");
        this.searchGraph = new DynamicFlatSearchGraph();
    }

    private void initUnitMaps(GrammarNode grammarNode) {
        HashSet<Unit> hashSet;
        HashSet<GrammarNode> hashSet2;
        if (this.nodeToNextUnitArrayMap.get(grammarNode) == null) {
            GrammarArc[] grammarArcArray;
            hashSet2 = new HashSet<GrammarNode>();
            hashSet = new HashSet<Unit>();
            for (GrammarArc grammarArc : grammarArcArray = grammarNode.getSuccessors()) {
                GrammarNode grammarNode2 = grammarArc.getGrammarNode();
                this.collectNextUnits(grammarNode2, hashSet2, hashSet);
            }
            int[] nArray = new int[hashSet.size()];
            int n = 0;
            for (Unit unit : hashSet) {
                nArray[n++] = unit.getBaseID();
            }
            this.nodeToNextUnitArrayMap.put(grammarNode, nArray);
        }
        if (this.nodeToUnitSetMap.get(grammarNode) == null) {
            hashSet2 = new HashSet();
            hashSet = new HashSet();
            this.collectNextUnits(grammarNode, hashSet2, hashSet);
            this.nodeToUnitSetMap.put(grammarNode, hashSet);
        }
    }

    private void collectNextUnits(GrammarNode grammarNode, Set<GrammarNode> set, Set<Unit> set2) {
        if (set.contains(grammarNode)) {
            return;
        }
        set.add(grammarNode);
        if (grammarNode.isFinalNode()) {
            set2.add(UnitManager.SILENCE);
        } else if (!grammarNode.isEmpty()) {
            Pronunciation[] pronunciationArray;
            Word word = grammarNode.getWord();
            for (Pronunciation pronunciation : pronunciationArray = word.getPronunciations()) {
                set2.add(pronunciation.getUnits()[0]);
            }
        } else {
            GrammarArc[] grammarArcArray;
            for (GrammarArc grammarArc : grammarArcArray = grammarNode.getSuccessors()) {
                GrammarNode grammarNode2 = grammarArc.getGrammarNode();
                this.collectNextUnits(grammarNode2, set, set2);
            }
        }
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
    }

    class DynamicFlatSearchGraph
    implements SearchGraph {
        DynamicFlatSearchGraph() {
        }

        @Override
        public SearchState getInitialState() {
            InitialState initialState = new InitialState();
            initialState.addArc(new GrammarState(AFlatLinguist.this.grammar.getInitialNode()));
            return initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 5;
        }

        @Override
        public boolean getWordTokenFirst() {
            return true;
        }
    }

    class HMMStateSearchState
    extends FlatSearchState
    implements HMMSearchState,
    ScoreProvider {
        private final FullHMMSearchState fullHMMSearchState;
        private final HMMState hmmState;
        private final float probability;

        HMMStateSearchState(FullHMMSearchState fullHMMSearchState, HMMState hMMState) {
            this(fullHMMSearchState, hMMState, 0.0f);
        }

        HMMStateSearchState(FullHMMSearchState fullHMMSearchState, HMMState hMMState, float f) {
            this.probability = f;
            this.fullHMMSearchState = fullHMMSearchState;
            this.hmmState = hMMState;
        }

        @Override
        public float getInsertionProbability() {
            return this.probability;
        }

        public int hashCode() {
            return 7 * this.fullHMMSearchState.hashCode() + this.hmmState.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof HMMStateSearchState) {
                HMMStateSearchState hMMStateSearchState = (HMMStateSearchState)object;
                return hMMStateSearchState.fullHMMSearchState.equals(this.fullHMMSearchState) && hMMStateSearchState.hmmState.equals(this.hmmState);
            }
            return false;
        }

        @Override
        public boolean isEmitting() {
            return this.hmmState.isEmitting();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedSuccessors();
            if (searchStateArcArray == null) {
                if (this.hmmState.isExitState()) {
                    searchStateArcArray = this.fullHMMSearchState.getNextArcs();
                } else {
                    HMMStateArc[] hMMStateArcArray = this.hmmState.getSuccessors();
                    searchStateArcArray = new SearchStateArc[hMMStateArcArray.length];
                    for (int i = 0; i < searchStateArcArray.length; ++i) {
                        searchStateArcArray[i] = new HMMStateSearchState(this.fullHMMSearchState, hMMStateArcArray[i].getHMMState(), hMMStateArcArray[i].getLogProbability());
                    }
                }
                this.cacheSuccessors(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        @Override
        public int getOrder() {
            return this.isEmitting() ? 4 : 0;
        }

        @Override
        public String getSignature() {
            return "HSSS " + this.fullHMMSearchState.getSignature() + '-' + this.hmmState;
        }

        @Override
        public HMMState getHMMState() {
            return this.hmmState;
        }

        @Override
        public float getScore(Data data) {
            return this.hmmState.getScore(data);
        }

        @Override
        public float[] getComponentScore(Data data) {
            return this.hmmState.calculateComponentScore(data);
        }
    }

    class FullHMMSearchState
    extends FlatSearchState
    implements UnitSearchState {
        private final PronunciationState pState;
        private final int index;
        private final int lc;
        private final int rc;
        private final HMM hmm;
        private final boolean isLastUnitOfWord;

        FullHMMSearchState(PronunciationState pronunciationState, int n, int n2) {
            this(pronunciationState, n, n2, pronunciationState.getPronunciation().getUnits()[n + 1].getBaseID());
        }

        FullHMMSearchState(PronunciationState pronunciationState, int n, int n2, int n3) {
            this.pState = pronunciationState;
            this.index = n;
            this.lc = n2;
            this.rc = n3;
            int n4 = pronunciationState.getPronunciation().getUnits()[n].getBaseID();
            int n5 = AFlatLinguist.this.hmmPool.buildID(n4, n2, n3);
            this.hmm = AFlatLinguist.this.hmmPool.getHMM(n5, this.getPosition());
            this.isLastUnitOfWord = n == pronunciationState.getPronunciation().getUnits().length - 1;
        }

        @Override
        public float getInsertionProbability() {
            Unit unit = this.hmm.getBaseUnit();
            if (unit.isSilence()) {
                return AFlatLinguist.this.logSilenceInsertionProbability;
            }
            if (unit.isFiller()) {
                return AFlatLinguist.this.logFillerInsertionProbability;
            }
            return AFlatLinguist.this.logUnitInsertionProbability;
        }

        @Override
        public String toString() {
            return this.hmm.getUnit().toString();
        }

        public int hashCode() {
            return this.pState.getGrammarState().getGrammarNode().hashCode() * 29 + this.pState.getPronunciation().hashCode() * 19 + this.index * 7 + 43 * this.lc + this.rc;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FullHMMSearchState) {
                FullHMMSearchState fullHMMSearchState = (FullHMMSearchState)object;
                return this.pState.getGrammarState().getGrammarNode() == fullHMMSearchState.pState.getGrammarState().getGrammarNode() && this.pState.getPronunciation() == fullHMMSearchState.pState.getPronunciation() && this.index == fullHMMSearchState.index && this.lc == fullHMMSearchState.lc && this.rc == fullHMMSearchState.rc;
            }
            return false;
        }

        @Override
        public Unit getUnit() {
            return this.hmm.getBaseUnit();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedSuccessors();
            if (searchStateArcArray == null) {
                searchStateArcArray = new SearchStateArc[]{new HMMStateSearchState(this, this.hmm.getInitialState())};
                this.cacheSuccessors(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        boolean isLastUnitOfWord() {
            return this.isLastUnitOfWord;
        }

        HMMPosition getPosition() {
            int n = this.pState.getPronunciation().getUnits().length;
            if (n == 1) {
                return HMMPosition.SINGLE;
            }
            if (this.index == 0) {
                return HMMPosition.BEGIN;
            }
            if (this.index == n - 1) {
                return HMMPosition.END;
            }
            return HMMPosition.INTERNAL;
        }

        HMM getHMM() {
            return this.hmm;
        }

        @Override
        public int getOrder() {
            return 3;
        }

        @Override
        public String getSignature() {
            return "HSS " + this.pState.getGrammarState().getGrammarNode() + this.pState.getPronunciation() + this.index + '-' + this.rc + '-' + this.lc;
        }

        int getRC() {
            return this.rc;
        }

        SearchStateArc[] getNextArcs() {
            SearchStateArc[] searchStateArcArray;
            int n = this.getHMM().getBaseUnit().getBaseID();
            if (!this.isLastUnitOfWord()) {
                searchStateArcArray = this.pState.getSuccessors(n, this.index + 1);
            } else {
                GrammarState grammarState = this.pState.getGrammarState();
                searchStateArcArray = grammarState.getNextGrammarStates(n, this.getRC());
            }
            return searchStateArcArray;
        }
    }

    class PronunciationState
    extends FlatSearchState
    implements WordSearchState {
        private final GrammarState gs;
        private final Pronunciation pronunciation;

        PronunciationState(GrammarState grammarState, Pronunciation pronunciation) {
            this.gs = grammarState;
            this.pronunciation = pronunciation;
        }

        @Override
        public float getInsertionProbability() {
            if (this.pronunciation.getWord().isFiller()) {
                return 0.0f;
            }
            return AFlatLinguist.this.logWordInsertionProbability;
        }

        public int hashCode() {
            return 13 * this.gs.hashCode() + this.pronunciation.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PronunciationState) {
                PronunciationState pronunciationState = (PronunciationState)object;
                return pronunciationState.gs.equals(this.gs) && pronunciationState.pronunciation.equals(this.pronunciation);
            }
            return false;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedSuccessors();
            if (searchStateArcArray == null) {
                searchStateArcArray = this.getSuccessors(this.gs.getLC(), 0);
                this.cacheSuccessors(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        SearchStateArc[] getSuccessors(int n, int n2) {
            SearchStateArc[] searchStateArcArray;
            if (n2 == this.pronunciation.getUnits().length - 1) {
                if (this.isContextIndependentUnit(this.pronunciation.getUnits()[n2])) {
                    searchStateArcArray = new SearchStateArc[]{new FullHMMSearchState(this, n2, n, 0)};
                } else {
                    int[] nArray = this.gs.getNextUnits();
                    searchStateArcArray = new SearchStateArc[nArray.length];
                    for (int i = 0; i < searchStateArcArray.length; ++i) {
                        searchStateArcArray[i] = new FullHMMSearchState(this, n2, n, nArray[i]);
                    }
                }
            } else {
                searchStateArcArray = new SearchStateArc[]{new FullHMMSearchState(this, n2, n)};
            }
            return searchStateArcArray;
        }

        @Override
        public Pronunciation getPronunciation() {
            return this.pronunciation;
        }

        private boolean isContextIndependentUnit(Unit unit) {
            return unit.isFiller();
        }

        @Override
        public String getSignature() {
            return "PS " + this.gs.getSignature() + '-' + this.pronunciation;
        }

        @Override
        public String toString() {
            return this.pronunciation.getWord().getSpelling();
        }

        @Override
        public int getOrder() {
            return 2;
        }

        GrammarState getGrammarState() {
            return this.gs;
        }

        @Override
        public boolean isWordStart() {
            return true;
        }
    }

    class InitialState
    extends FlatSearchState {
        private final List<SearchStateArc> nextArcs;

        InitialState() {
            this.nextArcs = new ArrayList<SearchStateArc>();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.nextArcs.toArray(new SearchStateArc[this.nextArcs.size()]);
        }

        public void addArc(SearchStateArc searchStateArc) {
            this.nextArcs.add(searchStateArc);
        }

        @Override
        public String getSignature() {
            return "initialState";
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public String toString() {
            return this.getSignature();
        }
    }

    public class GrammarState
    extends FlatSearchState {
        private final GrammarNode node;
        private final int lc;
        private final int nextBaseID;
        private final float languageProbability;

        GrammarState(GrammarNode grammarNode) {
            this(grammarNode, 0.0f, UnitManager.SILENCE.getBaseID());
        }

        GrammarState(GrammarNode grammarNode, float f, int n) {
            this(grammarNode, f, n, 0);
        }

        GrammarState(GrammarNode grammarNode, float f, int n, int n2) {
            this.lc = n;
            this.nextBaseID = n2;
            this.node = grammarNode;
            this.languageProbability = f;
        }

        @Override
        public float getLanguageProbability() {
            return this.languageProbability * AFlatLinguist.this.languageWeight;
        }

        public int hashCode() {
            return this.node.hashCode() * 17 + this.lc * 7 + this.nextBaseID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof GrammarState) {
                GrammarState grammarState = (GrammarState)object;
                return grammarState.node == this.node && this.lc == grammarState.lc && this.nextBaseID == grammarState.nextBaseID;
            }
            return false;
        }

        @Override
        public boolean isFinal() {
            return this.node.isFinalNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray;
            AFlatLinguist.this.counterForMemoryLogging++;
            if (AFlatLinguist.this.counterForMemoryLogging % 500000L == 0L) {
                AFlatLinguist.this.logger.info("Free Memory= " + AFlatLinguist.this.runtime.freeMemory() / 0x100000L + " MB" + "\tMax Memory= " + AFlatLinguist.this.runtime.maxMemory() / 0x100000L + "MB");
            }
            if ((searchStateArcArray = this.getCachedSuccessors()) == null) {
                if (this.isFinal()) {
                    searchStateArcArray = AFlatLinguist.this.EMPTY_ARCS;
                } else if (this.node.isEmpty()) {
                    searchStateArcArray = this.getNextGrammarStates(this.lc, this.nextBaseID);
                } else {
                    Word word = this.node.getWord();
                    Pronunciation[] pronunciationArray = word.getPronunciations();
                    pronunciationArray = this.filter(pronunciationArray, this.nextBaseID);
                    SearchStateArc[] searchStateArcArray2 = AFlatLinguist.this.addOutOfGrammarBranch ? new SearchStateArc[pronunciationArray.length + 1] : new SearchStateArc[pronunciationArray.length];
                    for (int i = 0; i < pronunciationArray.length; ++i) {
                        searchStateArcArray2[i] = new PronunciationState(this, pronunciationArray[i]);
                    }
                    SearchStateArc[] searchStateArcArray3 = new SearchStateArc[]{this};
                    if (AFlatLinguist.this.addOutOfGrammarBranch) {
                        PhoneLoop phoneLoop = new PhoneLoop(AFlatLinguist.this.acousticModel, AFlatLinguist.this.logOutOfGrammarBranchProbability, AFlatLinguist.this.logPhoneInsertionProbability, searchStateArcArray3);
                        searchStateArcArray2[pronunciationArray.length] = phoneLoop.getPhoneLoop();
                    }
                    searchStateArcArray = searchStateArcArray2;
                }
                this.cacheSuccessors(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        SearchStateArc[] getNextGrammarStates(int n, int n2) {
            GrammarArc[] grammarArcArray = this.node.getSuccessors();
            grammarArcArray = this.filter(grammarArcArray, n2);
            SearchStateArc[] searchStateArcArray = new SearchStateArc[grammarArcArray.length];
            for (int i = 0; i < grammarArcArray.length; ++i) {
                GrammarArc grammarArc = grammarArcArray[i];
                searchStateArcArray[i] = new GrammarState(grammarArc.getGrammarNode(), grammarArc.getProbability(), n, n2);
            }
            return searchStateArcArray;
        }

        @Override
        public String getSignature() {
            return "GS " + this.node + "-lc-" + AFlatLinguist.this.hmmPool.getUnit(this.lc) + "-rc-" + AFlatLinguist.this.hmmPool.getUnit(this.nextBaseID);
        }

        @Override
        public int getOrder() {
            return 1;
        }

        GrammarArc[] filter(GrammarArc[] grammarArcArray, int n) {
            if (n != 0) {
                ArrayList<GrammarArc> arrayList = new ArrayList<GrammarArc>();
                for (GrammarArc grammarArc : grammarArcArray) {
                    GrammarNode grammarNode = grammarArc.getGrammarNode();
                    if (!this.hasEntryContext(grammarNode, n)) continue;
                    arrayList.add(grammarArc);
                }
                grammarArcArray = arrayList.toArray(new GrammarArc[arrayList.size()]);
            }
            return grammarArcArray;
        }

        private boolean hasEntryContext(GrammarNode grammarNode, int n) {
            Set set = (Set)AFlatLinguist.this.nodeToUnitSetMap.get(grammarNode);
            return set.contains(AFlatLinguist.this.hmmPool.getUnit(n));
        }

        Pronunciation[] filter(Pronunciation[] pronunciationArray, int n) {
            return pronunciationArray;
        }

        int getLC() {
            return this.lc;
        }

        int getNextBaseID() {
            return this.nextBaseID;
        }

        int[] getNextUnits() {
            return (int[])AFlatLinguist.this.nodeToNextUnitArrayMap.get(this.node);
        }

        @Override
        public String toString() {
            return this.node + "[" + AFlatLinguist.this.hmmPool.getUnit(this.lc) + ',' + AFlatLinguist.this.hmmPool.getUnit(this.nextBaseID) + ']';
        }

        GrammarNode getGrammarNode() {
            return this.node;
        }
    }

    abstract class FlatSearchState
    implements SearchState,
    SearchStateArc {
        static final int ANY = 0;

        FlatSearchState() {
        }

        @Override
        public abstract SearchStateArc[] getSuccessors();

        @Override
        public abstract String getSignature();

        @Override
        public abstract int getOrder();

        @Override
        public boolean isEmitting() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public Object getLexState() {
            return null;
        }

        @Override
        public String toPrettyString() {
            return this.toString();
        }

        public String toString() {
            return this.getSignature();
        }

        @Override
        public WordSequence getWordHistory() {
            return null;
        }

        @Override
        public SearchState getState() {
            return this;
        }

        @Override
        public float getProbability() {
            return this.getLanguageProbability() + this.getInsertionProbability();
        }

        @Override
        public float getLanguageProbability() {
            return 0.0f;
        }

        @Override
        public float getInsertionProbability() {
            return 0.0f;
        }

        SearchStateArc[] getCachedSuccessors() {
            return AFlatLinguist.this.successorCache.get(this);
        }

        void cacheSuccessors(SearchStateArc[] searchStateArcArray) {
            AFlatLinguist.this.successorCache.put(this, searchStateArcArray);
        }
    }
}

