/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.allphone.AllphoneSearchGraph;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AllphoneLinguist
implements Linguist {
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Double(defaultValue=0.05)
    public static final String PROP_PIP = "phoneInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CD = "useContextDependentPhones";
    private AcousticModel acousticModel;
    private ArrayList<HMM> ciHMMs;
    private ArrayList<HMM> fillerHMMs;
    private ArrayList<HMM> leftContextSilHMMs;
    private HashMap<SenoneSequence, ArrayList<Unit>> senonesToUnits;
    private HashMap<Unit, HashMap<Unit, ArrayList<HMM>>> cdHMMs;
    private float pip;
    private boolean useCD;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.acousticModel = (AcousticModel)propertySheet.getComponent(PROP_ACOUSTIC_MODEL);
        this.pip = LogMath.getLogMath().linearToLog(propertySheet.getFloat(PROP_PIP));
        this.useCD = propertySheet.getBoolean(PROP_CD);
        if (this.useCD) {
            this.createContextDependentSuccessors();
        } else {
            this.createContextIndependentSuccessors();
        }
    }

    @Override
    public SearchGraph getSearchGraph() {
        return new AllphoneSearchGraph(this);
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
    }

    @Override
    public void allocate() throws IOException {
    }

    @Override
    public void deallocate() throws IOException {
    }

    public AcousticModel getAcousticModel() {
        return this.acousticModel;
    }

    public float getPhoneInsertionProb() {
        return this.pip;
    }

    public boolean useContextDependentPhones() {
        return this.useCD;
    }

    public ArrayList<HMM> getCISuccessors() {
        return this.ciHMMs;
    }

    public ArrayList<HMM> getCDSuccessors(Unit unit, Unit unit2) {
        if (unit.isFiller()) {
            return this.leftContextSilHMMs;
        }
        if (unit2 == UnitManager.SILENCE) {
            return this.fillerHMMs;
        }
        return this.cdHMMs.get(unit).get(unit2);
    }

    public ArrayList<Unit> getUnits(SenoneSequence senoneSequence) {
        return this.senonesToUnits.get(senoneSequence);
    }

    private void createContextIndependentSuccessors() {
        Iterator<HMM> iterator = this.acousticModel.getHMMIterator();
        this.ciHMMs = new ArrayList();
        this.senonesToUnits = new HashMap();
        while (iterator.hasNext()) {
            HMM hMM = iterator.next();
            if (hMM.getUnit().isContextDependent()) continue;
            SenoneSequence senoneSequence = ((SenoneHMM)hMM).getSenoneSequence();
            ArrayList<Unit> arrayList = this.senonesToUnits.get(senoneSequence);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.senonesToUnits.put(senoneSequence, arrayList);
            }
            arrayList.add(hMM.getUnit());
            this.ciHMMs.add(hMM);
        }
    }

    private void createContextDependentSuccessors() {
        this.cdHMMs = new HashMap();
        this.senonesToUnits = new HashMap();
        this.fillerHMMs = new ArrayList();
        this.leftContextSilHMMs = new ArrayList();
        Iterator<HMM> iterator = this.acousticModel.getHMMIterator();
        while (iterator.hasNext()) {
            ArrayList<HMM> arrayList;
            HMM hMM = iterator.next();
            SenoneSequence senoneSequence = ((SenoneHMM)hMM).getSenoneSequence();
            ArrayList<Unit> arrayList2 = this.senonesToUnits.get(senoneSequence);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                this.senonesToUnits.put(senoneSequence, arrayList2);
            }
            arrayList2.add(hMM.getUnit());
            if (hMM.getUnit().isFiller()) {
                this.fillerHMMs.add(hMM);
                continue;
            }
            if (!hMM.getUnit().isContextDependent()) continue;
            LeftRightContext leftRightContext = (LeftRightContext)hMM.getUnit().getContext();
            Unit unit = leftRightContext.getLeftContext()[0];
            if (unit == UnitManager.SILENCE) {
                this.leftContextSilHMMs.add(hMM);
                continue;
            }
            Unit unit2 = hMM.getUnit().getBaseUnit();
            HashMap<Unit, ArrayList<HMM>> hashMap = this.cdHMMs.get(unit);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.cdHMMs.put(unit, hashMap);
            }
            if ((arrayList = hashMap.get(unit2)) == null) {
                arrayList = new ArrayList();
                hashMap.put(unit2, arrayList);
            }
            arrayList.add(hMM);
        }
        this.leftContextSilHMMs.addAll(this.fillerHMMs);
    }
}

