/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.allphone.AllphoneLinguist;
import edu.cmu.sphinx.linguist.allphone.PhoneNonEmittingSearchState;
import java.util.ArrayList;

public class PhoneHmmSearchState
implements SearchState,
SearchStateArc,
ScoreProvider {
    private HMMState state;
    private AllphoneLinguist linguist;
    private float insertionProb;
    private float languageProb;

    public PhoneHmmSearchState(HMMState hMMState, AllphoneLinguist allphoneLinguist, float f, float f2) {
        this.state = hMMState;
        this.linguist = allphoneLinguist;
        this.insertionProb = f;
        this.languageProb = f2;
    }

    @Override
    public SearchState getState() {
        return this;
    }

    public int getBaseId() {
        return ((SenoneHMM)this.state.getHMM()).getBaseUnit().getBaseID();
    }

    @Override
    public float getProbability() {
        return this.getLanguageProbability() + this.getInsertionProbability();
    }

    @Override
    public float getLanguageProbability() {
        return this.languageProb;
    }

    @Override
    public float getInsertionProbability() {
        return this.insertionProb;
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        if (this.state.isExitState()) {
            ArrayList<Unit> arrayList = this.linguist.getUnits(((SenoneHMM)this.state.getHMM()).getSenoneSequence());
            SearchStateArc[] searchStateArcArray = new SearchStateArc[arrayList.size()];
            for (int i = 0; i < searchStateArcArray.length; ++i) {
                searchStateArcArray[i] = new PhoneNonEmittingSearchState(arrayList.get(i), this.linguist, this.insertionProb, this.languageProb);
            }
            return searchStateArcArray;
        }
        HMMStateArc[] hMMStateArcArray = this.state.getSuccessors();
        SearchStateArc[] searchStateArcArray = new SearchStateArc[hMMStateArcArray.length];
        for (int i = 0; i < hMMStateArcArray.length; ++i) {
            searchStateArcArray[i] = new PhoneHmmSearchState(hMMStateArcArray[i].getHMMState(), this.linguist, this.insertionProb, this.languageProb);
        }
        return searchStateArcArray;
    }

    @Override
    public boolean isEmitting() {
        return this.state.isEmitting();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public String toPrettyString() {
        return "HMM " + this.state.toString();
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public WordSequence getWordHistory() {
        return null;
    }

    @Override
    public Object getLexState() {
        return null;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public float getScore(Data data) {
        return this.state.getScore(data);
    }

    @Override
    public float[] getComponentScore(Data data) {
        return this.state.calculateComponentScore(data);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PhoneHmmSearchState)) {
            return false;
        }
        SenoneSequence senoneSequence = ((SenoneHMM)((PhoneHmmSearchState)object).state.getHMM()).getSenoneSequence();
        SenoneSequence senoneSequence2 = ((SenoneHMM)this.state.getHMM()).getSenoneSequence();
        return senoneSequence2.equals(senoneSequence);
    }

    public int hashCode() {
        return ((SenoneHMM)this.state.getHMM()).getSenoneSequence().hashCode() + this.state.getState() * 37;
    }
}

