/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.allphone.AllphoneLinguist;
import edu.cmu.sphinx.linguist.allphone.PhoneWordSearchState;

public class PhoneNonEmittingSearchState
implements SearchState,
SearchStateArc {
    protected Unit unit;
    protected AllphoneLinguist linguist;
    private float insertionProb;
    private float languageProb;

    public PhoneNonEmittingSearchState(Unit unit, AllphoneLinguist allphoneLinguist, float f, float f2) {
        this.unit = unit;
        this.linguist = allphoneLinguist;
        this.insertionProb = f;
        this.languageProb = f2;
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        SearchStateArc[] searchStateArcArray = new SearchStateArc[]{new PhoneWordSearchState(this.unit, this.linguist, this.insertionProb, this.languageProb)};
        return searchStateArcArray;
    }

    @Override
    public boolean isEmitting() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public String toPrettyString() {
        return "Unit " + this.unit.toString();
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public WordSequence getWordHistory() {
        return null;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public SearchState getState() {
        return this;
    }

    @Override
    public float getProbability() {
        return this.getLanguageProbability() + this.getInsertionProbability();
    }

    @Override
    public float getLanguageProbability() {
        return this.languageProb;
    }

    @Override
    public float getInsertionProbability() {
        return this.insertionProb;
    }

    @Override
    public Object getLexState() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PhoneNonEmittingSearchState)) {
            return false;
        }
        boolean bl = ((PhoneNonEmittingSearchState)object).unit.getBaseID() == this.unit.getBaseID();
        boolean bl2 = ((PhoneNonEmittingSearchState)object).unit.getContext().equals(this.unit.getContext());
        return bl && bl2;
    }

    public int hashCode() {
        return this.unit.getContext().hashCode() * 91 + this.unit.getBaseID();
    }
}

