/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.TextDictionary;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MappingDictionary
extends TextDictionary
implements Dictionary {
    @S4String(mandatory=true, defaultValue="")
    public static final String PROP_MAP_FILE = "mapFile";
    private URL mappingFile;
    private final Map<String, String> mapping = new HashMap<String, String>();

    public MappingDictionary(URL uRL, URL uRL2, URL uRL3, List<URL> list, String string, UnitManager unitManager) {
        super(uRL2, uRL3, list, string, unitManager);
        this.mappingFile = uRL;
    }

    public MappingDictionary() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.mappingFile = ConfigurationManagerUtils.getResource(PROP_MAP_FILE, propertySheet);
    }

    @Override
    public void allocate() throws IOException {
        super.allocate();
        if (!this.mappingFile.getFile().equals("")) {
            this.loadMapping(this.mappingFile.openStream());
        }
    }

    @Override
    protected Unit getCIUnit(String string, boolean bl) {
        if (this.mapping.containsKey(string)) {
            string = this.mapping.get(string);
        }
        return this.unitManager.getUnit(string, bl, Context.EMPTY_CONTEXT);
    }

    protected void loadMapping(InputStream inputStream) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != 2) {
                throw new IOException("Wrong file format");
            }
            this.mapping.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
    }
}

