/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.List;

public class Pronunciation {
    public static final Pronunciation UNKNOWN = new Pronunciation(Unit.EMPTY_ARRAY, null, 1.0f);
    private Word word;
    private final Unit[] units;
    private final String tag;
    private final float probability;

    public Pronunciation(Unit[] unitArray, String string, float f) {
        this.units = unitArray;
        this.tag = string;
        this.probability = f;
    }

    protected Pronunciation(List<Unit> list, String string, float f) {
        Unit[] unitArray = list.toArray(new Unit[list.size()]);
        this.units = unitArray;
        this.tag = string;
        this.probability = f;
    }

    protected Pronunciation(List<Unit> list) {
        this(list, null, 1.0f);
    }

    public void setWord(Word word) {
        if (this.word != null) {
            throw new Error("Word of Pronunciation cannot be set twice.");
        }
        this.word = word;
    }

    public Word getWord() {
        return this.word;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public String getTag() {
        return this.tag;
    }

    public float getProbability() {
        return this.probability;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.word).append('(');
        for (Unit unit : this.units) {
            stringBuilder.append(unit).append(' ');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toDetailedString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.word).append(' ');
        for (Unit unit : this.units) {
            stringBuilder.append(unit).append(' ');
        }
        stringBuilder.append("\n   class: ").append(" tag: ").append(this.tag).append(" prob: ").append(this.probability);
        return stringBuilder.toString();
    }
}

