/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.g2p.G2PConverter;
import edu.cmu.sphinx.linguist.g2p.Path;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Logger;

public class TextDictionary
implements Dictionary {
    protected Logger logger;
    protected URL wordDictionaryFile;
    protected URL fillerDictionaryFile;
    protected List<URL> addendaUrlList;
    private String wordReplacement;
    protected URL g2pModelFile;
    protected int g2pMaxPron = 0;
    protected UnitManager unitManager;
    protected Map<String, String> dictionary;
    protected Map<String, Word> wordDictionary;
    protected G2PConverter g2pDecoder;
    protected static final String FILLER_TAG = "-F-";
    protected Set<String> fillerWords;
    protected boolean allocated;

    public TextDictionary(String string, String string2, List<URL> list, boolean bl, String string3, UnitManager unitManager) throws MalformedURLException, ClassNotFoundException {
        this(ConfigurationManagerUtils.resourceToURL(string), ConfigurationManagerUtils.resourceToURL(string2), list, string3, unitManager);
    }

    public TextDictionary(URL uRL, URL uRL2, List<URL> list, String string, UnitManager unitManager) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.wordDictionaryFile = uRL;
        this.fillerDictionaryFile = uRL2;
        this.addendaUrlList = list;
        this.wordReplacement = string;
        this.unitManager = unitManager;
    }

    public TextDictionary(URL uRL, URL uRL2, List<URL> list, boolean bl, String string, UnitManager unitManager, URL uRL3, int n) {
        this(uRL, uRL2, list, string, unitManager);
        this.g2pModelFile = uRL3;
        this.g2pMaxPron = n;
    }

    public TextDictionary() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.wordDictionaryFile = ConfigurationManagerUtils.getResource("dictionaryPath", propertySheet);
        this.fillerDictionaryFile = ConfigurationManagerUtils.getResource("fillerPath", propertySheet);
        this.addendaUrlList = propertySheet.getResourceList("addenda");
        this.wordReplacement = propertySheet.getString("wordReplacement");
        this.unitManager = (UnitManager)propertySheet.getComponent("unitManager");
        this.g2pModelFile = ConfigurationManagerUtils.getResource("g2pModelPath", propertySheet);
        this.g2pMaxPron = propertySheet.getInt("g2pMaxPron");
    }

    public URL getWordDictionaryFile() {
        return this.wordDictionaryFile;
    }

    public URL getFillerDictionaryFile() {
        return this.fillerDictionaryFile;
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.dictionary = new HashMap<String, String>();
            this.wordDictionary = new HashMap<String, Word>();
            Timer timer = TimerPool.getTimer(this, "Load Dictionary");
            this.fillerWords = new HashSet<String>();
            timer.start();
            this.logger.info("Loading dictionary from: " + this.wordDictionaryFile);
            this.loadDictionary(this.wordDictionaryFile.openStream(), false);
            this.loadCustomDictionaries(this.addendaUrlList);
            this.logger.info("Loading filler dictionary from: " + this.fillerDictionaryFile);
            this.loadDictionary(this.fillerDictionaryFile.openStream(), true);
            if (this.g2pModelFile != null && !this.g2pModelFile.getPath().equals("")) {
                this.g2pDecoder = new G2PConverter(this.g2pModelFile);
            }
            timer.stop();
        }
    }

    @Override
    public void deallocate() {
        if (this.allocated) {
            this.dictionary = null;
            this.g2pDecoder = null;
            this.allocated = false;
        }
    }

    protected void loadDictionary(InputStream inputStream, boolean bl) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty()) continue;
            int n = this.getSpaceIndex(string);
            if (n < 0) {
                throw new Error("Error loading word: " + string);
            }
            String string2 = string.substring(0, n);
            if (this.dictionary.containsKey(string2)) {
                String string3;
                int n2 = 2;
                while (this.dictionary.containsKey(string3 = String.format("%s(%d)", string2, n2++))) {
                }
                string2 = string3;
            }
            if (bl) {
                this.dictionary.put(string2, FILLER_TAG + string);
                this.fillerWords.add(string2);
                continue;
            }
            this.dictionary.put(string2, string);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
    }

    private int getSpaceIndex(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ' ' && string.charAt(i) != '\t') continue;
            return i;
        }
        return -1;
    }

    protected Unit getCIUnit(String string, boolean bl) {
        return this.unitManager.getUnit(string, bl, Context.EMPTY_CONTEXT);
    }

    @Override
    public Word getSentenceStartWord() {
        return this.getWord("<s>");
    }

    @Override
    public Word getSentenceEndWord() {
        return this.getWord("</s>");
    }

    @Override
    public Word getSilenceWord() {
        return this.getWord("<sil>");
    }

    @Override
    public Word getWord(String string) {
        Word word = this.wordDictionary.get(string);
        if (word != null) {
            return word;
        }
        String string2 = this.dictionary.get(string);
        if (string2 == null) {
            this.logger.info("The dictionary is missing a phonetic transcription for the word '" + string + "'");
            if (this.wordReplacement != null) {
                word = this.getWord(this.wordReplacement);
            } else if (this.g2pModelFile != null && !this.g2pModelFile.getPath().equals("")) {
                this.logger.info("Generating phonetic transcription(s) for the word '" + string + "' using g2p model");
                word = this.extractPronunciation(string);
                this.wordDictionary.put(string, word);
            }
        } else {
            word = this.processEntry(string);
        }
        return word;
    }

    private Word extractPronunciation(String string) {
        ArrayList<Path> arrayList = this.g2pDecoder.phoneticize(string, this.g2pMaxPron);
        LinkedList<Pronunciation> linkedList = new LinkedList<Pronunciation>();
        for (Path pronunciationArray : arrayList) {
            int n = pronunciationArray.getPath().size();
            ArrayList<Unit> arrayList2 = new ArrayList<Unit>(n);
            for (String string2 : pronunciationArray.getPath()) {
                arrayList2.add(this.getCIUnit(string2, false));
            }
            if (arrayList2.size() == 0) {
                arrayList2.add(UnitManager.SILENCE);
            }
            linkedList.add(new Pronunciation(arrayList2));
        }
        Pronunciation[] pronunciationArray = linkedList.toArray(new Pronunciation[linkedList.size()]);
        Word word = this.createWord(string, pronunciationArray, false);
        for (Pronunciation pronunciation : pronunciationArray) {
            pronunciation.setWord(word);
        }
        return word;
    }

    private Word createWord(String string, Pronunciation[] pronunciationArray, boolean bl) {
        Word word = new Word(string, pronunciationArray, bl);
        this.dictionary.put(string, word.toString());
        return word;
    }

    private Word processEntry(String pronunciationArray) {
        Object object;
        Pronunciation[] pronunciationArray2;
        String string;
        LinkedList<Pronunciation> linkedList = new LinkedList<Pronunciation>();
        int n = 0;
        boolean bl = false;
        do {
            pronunciationArray2 = pronunciationArray;
            if (++n > 1) {
                pronunciationArray2 = (String)pronunciationArray2 + '(' + n + ')';
            }
            if ((string = this.dictionary.get(pronunciationArray2)) == null) continue;
            object = new StringTokenizer(string);
            Pronunciation[] pronunciationArray3 = ((StringTokenizer)object).nextToken();
            bl = pronunciationArray3.startsWith(FILLER_TAG);
            int n2 = ((StringTokenizer)object).countTokens();
            ArrayList<Unit> arrayList = new ArrayList<Unit>(n2);
            for (int i = 0; i < n2; ++i) {
                String string2 = ((StringTokenizer)object).nextToken();
                arrayList.add(this.getCIUnit(string2, bl));
            }
            linkedList.add(new Pronunciation(arrayList));
        } while (string != null);
        pronunciationArray2 = linkedList.toArray(new Pronunciation[linkedList.size()]);
        object = this.createWord((String)pronunciationArray, pronunciationArray2, bl);
        for (Pronunciation pronunciation : pronunciationArray2) {
            pronunciation.setWord((Word)object);
        }
        this.wordDictionary.put((String)pronunciationArray, (Word)object);
        return object;
    }

    public String toString() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.dictionary);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append("   ").append((String)entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Word[] getFillerWords() {
        Word[] wordArray = new Word[this.fillerWords.size()];
        int n = 0;
        for (String string : this.fillerWords) {
            wordArray[n++] = this.getWord(string);
        }
        return wordArray;
    }

    public void dump() {
        System.out.print(this.toString());
    }

    private void loadCustomDictionaries(List<URL> list) throws IOException {
        if (list != null) {
            for (URL uRL : list) {
                this.logger.info("Loading addendum dictionary from: " + uRL);
                this.loadDictionary(uRL.openStream(), false);
            }
        }
    }
}

