/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;

public class Word
implements Comparable<Word> {
    public static final Word UNKNOWN;
    private final String spelling;
    private final Pronunciation[] pronunciations;
    private final boolean isFiller;

    public Word(String string, Pronunciation[] pronunciationArray, boolean bl) {
        this.spelling = string;
        this.pronunciations = pronunciationArray;
        this.isFiller = bl;
    }

    public String getSpelling() {
        return this.spelling;
    }

    public boolean isFiller() {
        return this.isFiller;
    }

    public boolean isSentenceEndWord() {
        return "</s>".equals(this.spelling);
    }

    public boolean isSentenceStartWord() {
        return "<s>".equals(this.spelling);
    }

    public Pronunciation[] getPronunciations() {
        return this.pronunciations;
    }

    public Pronunciation getMostLikelyPronunciation() {
        float f = Float.NEGATIVE_INFINITY;
        Pronunciation pronunciation = null;
        for (Pronunciation pronunciation2 : this.pronunciations) {
            if (!(pronunciation2.getProbability() > f)) continue;
            f = pronunciation2.getProbability();
            pronunciation = pronunciation2;
        }
        return pronunciation;
    }

    public int hashCode() {
        return this.spelling.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Word && this.spelling.equals(((Word)object).spelling);
    }

    public String toString() {
        return this.spelling;
    }

    @Override
    public int compareTo(Word word) {
        return this.getSpelling().compareTo(word.getSpelling());
    }

    static {
        Pronunciation[] pronunciationArray = new Pronunciation[]{Pronunciation.UNKNOWN};
        UNKNOWN = new Word("<unk>", pronunciationArray, false);
        Pronunciation.UNKNOWN.setWord(UNKNOWN);
    }
}

