/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.flat.BranchOutState;
import edu.cmu.sphinx.linguist.flat.HMMStateState;
import edu.cmu.sphinx.linguist.flat.LoopBackState;
import edu.cmu.sphinx.linguist.flat.NonEmittingHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.flat.UnknownWordState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CIPhoneLoop {
    public final AcousticModel model;
    private final float logPhoneInsertionProbability;
    public final float logOne = 0.0f;

    public CIPhoneLoop(AcousticModel acousticModel, float f) {
        this.model = acousticModel;
        this.logPhoneInsertionProbability = f;
    }

    public SearchGraph getSearchGraph() {
        return new PhoneLoopSearchGraph();
    }

    protected class PhoneLoopSearchGraph
    implements SearchGraph {
        protected final Map<String, SearchState> existingStates = new HashMap<String, SearchState>();
        protected final SentenceHMMState firstState = new UnknownWordState();

        public PhoneLoopSearchGraph() {
            BranchOutState branchOutState = new BranchOutState(this.firstState);
            this.attachState(this.firstState, branchOutState, 0.0f, 0.0f);
            LoopBackState loopBackState = new LoopBackState(this.firstState);
            loopBackState.setFinalState(true);
            this.attachState(loopBackState, branchOutState, 0.0f, 0.0f);
            Iterator<Unit> iterator = CIPhoneLoop.this.model.getContextIndependentUnitIterator();
            while (iterator.hasNext()) {
                UnitState unitState = new UnitState(iterator.next(), HMMPosition.UNDEFINED);
                this.attachState(branchOutState, unitState, 0.0f, CIPhoneLoop.this.logPhoneInsertionProbability);
                HMM hMM = CIPhoneLoop.this.model.lookupNearestHMM(unitState.getUnit(), unitState.getPosition(), false);
                HMMState hMMState = hMM.getInitialState();
                HMMStateState hMMStateState = new HMMStateState(unitState, hMMState);
                this.addStateToCache(hMMStateState);
                this.attachState(unitState, hMMStateState, 0.0f, 0.0f);
                HMMStateState hMMStateState2 = this.expandHMMTree(unitState, hMMStateState);
                this.attachState(hMMStateState2, loopBackState, 0.0f, 0.0f);
            }
        }

        @Override
        public SearchState getInitialState() {
            return this.firstState;
        }

        @Override
        public int getNumStateOrder() {
            return 5;
        }

        @Override
        public boolean getWordTokenFirst() {
            return false;
        }

        private SentenceHMMState getExistingState(SentenceHMMState sentenceHMMState) {
            return (SentenceHMMState)this.existingStates.get(sentenceHMMState.getSignature());
        }

        protected void addStateToCache(SentenceHMMState sentenceHMMState) {
            this.existingStates.put(sentenceHMMState.getSignature(), sentenceHMMState);
        }

        protected HMMStateState expandHMMTree(UnitState unitState, HMMStateState hMMStateState) {
            HMMStateState hMMStateState2 = hMMStateState;
            for (HMMStateArc hMMStateArc : hMMStateState.getHMMState().getSuccessors()) {
                HMMStateState hMMStateState3 = hMMStateArc.getHMMState().isEmitting() ? new HMMStateState(unitState, hMMStateArc.getHMMState()) : new NonEmittingHMMState(unitState, hMMStateArc.getHMMState());
                SentenceHMMState sentenceHMMState = this.getExistingState(hMMStateState3);
                float f = hMMStateArc.getLogProbability();
                if (sentenceHMMState != null) {
                    this.attachState(hMMStateState, sentenceHMMState, 0.0f, f);
                    continue;
                }
                this.attachState(hMMStateState, hMMStateState3, 0.0f, f);
                this.addStateToCache(hMMStateState3);
                hMMStateState2 = this.expandHMMTree(unitState, hMMStateState3);
            }
            return hMMStateState2;
        }

        protected void attachState(SentenceHMMState sentenceHMMState, SentenceHMMState sentenceHMMState2, float f, float f2) {
            SentenceHMMStateArc sentenceHMMStateArc = new SentenceHMMStateArc(sentenceHMMState2, f, f2);
            sentenceHMMState.connect(sentenceHMMStateArc);
        }
    }
}

