/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.BranchState;
import edu.cmu.sphinx.linguist.flat.CIPhoneLoop;
import edu.cmu.sphinx.linguist.flat.ContextPair;
import edu.cmu.sphinx.linguist.flat.ExtendedUnitState;
import edu.cmu.sphinx.linguist.flat.GrammarState;
import edu.cmu.sphinx.linguist.flat.HMMStateState;
import edu.cmu.sphinx.linguist.flat.NonEmittingHMMState;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.UnitContext;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.Cache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatLinguist
implements Linguist,
Configurable {
    @S4Component(type=Grammar.class)
    public static final String PROP_GRAMMAR = "grammar";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DUMP_GSTATES = "dumpGstates";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_OUT_OF_GRAMMAR_BRANCH = "addOutOfGrammarBranch";
    @S4Double(defaultValue=1.0)
    public static final String PROP_OUT_OF_GRAMMAR_PROBABILITY = "outOfGrammarProbability";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_PHONE_LOOP_ACOUSTIC_MODEL = "phoneLoopAcousticModel";
    @S4Double(defaultValue=1.0)
    public static final String PROP_PHONE_INSERTION_PROBABILITY = "phoneInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_COMPILATION_PROGRESS = "showCompilationProgress";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SPREAD_WORD_PROBABILITIES_ACROSS_PRONUNCIATIONS = "spreadWordProbabilitiesAcrossPronunciations";
    protected static final float logOne = 0.0f;
    protected Grammar grammar;
    private AcousticModel acousticModel;
    private UnitManager unitManager;
    protected LogMath logMath;
    protected AcousticModel phoneLoopAcousticModel;
    protected boolean addOutOfGrammarBranch;
    protected float logOutOfGrammarBranchProbability;
    protected float logPhoneInsertionProbability;
    private float logWordInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logFillerInsertionProbability;
    private float logUnitInsertionProbability;
    private boolean showCompilationProgress = true;
    private boolean spreadWordProbabilitiesAcrossPronunciations;
    private boolean dumpGStates;
    private float languageWeight;
    protected StatisticsVariable totalStates;
    protected StatisticsVariable totalArcs;
    protected StatisticsVariable actualArcs;
    private transient int totalStateCounter;
    private static final boolean tracing = false;
    private transient Collection<SentenceHMMState> stateSet;
    private String name;
    protected Map<GrammarNode, GState> nodeStateMap;
    protected Cache<SentenceHMMStateArc> arcPool;
    protected GrammarNode initialGrammarState;
    protected SearchGraph searchGraph;

    @Override
    public SearchGraph getSearchGraph() {
        return this.searchGraph;
    }

    public FlatLinguist(AcousticModel acousticModel, Grammar grammar, UnitManager unitManager, double d, double d2, double d3, double d4, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d5, double d6, AcousticModel acousticModel2) {
        this.acousticModel = acousticModel;
        this.logMath = LogMath.getLogMath();
        this.grammar = grammar;
        this.unitManager = unitManager;
        this.logWordInsertionProbability = this.logMath.linearToLog(d);
        this.logSilenceInsertionProbability = this.logMath.linearToLog(d2);
        this.logFillerInsertionProbability = this.logMath.linearToLog(d3);
        this.logUnitInsertionProbability = this.logMath.linearToLog(d4);
        this.languageWeight = f;
        this.dumpGStates = bl;
        this.showCompilationProgress = bl2;
        this.spreadWordProbabilitiesAcrossPronunciations = bl3;
        this.addOutOfGrammarBranch = bl4;
        if (bl4) {
            this.logOutOfGrammarBranchProbability = this.logMath.linearToLog(d5);
            this.logPhoneInsertionProbability = this.logMath.linearToLog(d6);
            this.phoneLoopAcousticModel = acousticModel2;
        }
        this.name = null;
    }

    public FlatLinguist() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        this.acousticModel = (AcousticModel)propertySheet.getComponent(PROP_ACOUSTIC_MODEL);
        this.grammar = (Grammar)propertySheet.getComponent(PROP_GRAMMAR);
        this.unitManager = (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER);
        this.logWordInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("silenceInsertionProbability"));
        this.logFillerInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("fillerInsertionProbability"));
        this.logUnitInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("unitInsertionProbability"));
        this.languageWeight = propertySheet.getFloat("languageWeight");
        this.dumpGStates = propertySheet.getBoolean(PROP_DUMP_GSTATES);
        this.showCompilationProgress = propertySheet.getBoolean(PROP_SHOW_COMPILATION_PROGRESS);
        this.spreadWordProbabilitiesAcrossPronunciations = propertySheet.getBoolean(PROP_SPREAD_WORD_PROBABILITIES_ACROSS_PRONUNCIATIONS);
        this.addOutOfGrammarBranch = propertySheet.getBoolean(PROP_ADD_OUT_OF_GRAMMAR_BRANCH);
        if (this.addOutOfGrammarBranch) {
            this.logOutOfGrammarBranchProbability = this.logMath.linearToLog(propertySheet.getDouble(PROP_OUT_OF_GRAMMAR_PROBABILITY));
            this.logPhoneInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble(PROP_PHONE_INSERTION_PROBABILITY));
            this.phoneLoopAcousticModel = (AcousticModel)propertySheet.getComponent(PROP_PHONE_LOOP_ACOUSTIC_MODEL);
        }
        this.name = propertySheet.getInstanceName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void allocate() throws IOException {
        this.allocateAcousticModel();
        this.grammar.allocate();
        this.totalStates = StatisticsVariable.getStatisticsVariable(this.getName(), "totalStates");
        this.totalArcs = StatisticsVariable.getStatisticsVariable(this.getName(), "totalArcs");
        this.actualArcs = StatisticsVariable.getStatisticsVariable(this.getName(), "actualArcs");
        this.stateSet = this.compileGrammar();
        this.totalStates.value = this.stateSet.size();
    }

    protected void allocateAcousticModel() throws IOException {
        this.acousticModel.allocate();
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel.allocate();
        }
    }

    @Override
    public void deallocate() {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        this.grammar.deallocate();
    }

    @Override
    public void startRecognition() {
        if (this.grammarHasChanged()) {
            this.stateSet = this.compileGrammar();
            this.totalStates.value = this.stateSet.size();
        }
    }

    @Override
    public void stopRecognition() {
    }

    public float getLogSilenceInsertionProbability() {
        return this.logSilenceInsertionProbability;
    }

    protected Collection<SentenceHMMState> compileGrammar() {
        this.initialGrammarState = this.grammar.getInitialNode();
        this.nodeStateMap = new HashMap<GrammarNode, GState>();
        this.arcPool = new Cache();
        ArrayList<GState> arrayList = new ArrayList<GState>();
        TimerPool.getTimer(this, "Compile").start();
        TimerPool.getTimer(this, "Create States").start();
        for (GrammarNode iterator : this.grammar.getGrammarNodes()) {
            GState gState = this.createGState(iterator);
            arrayList.add(gState);
        }
        TimerPool.getTimer(this, "Create States").stop();
        this.addStartingPath();
        TimerPool.getTimer(this, "Collect Contexts").start();
        for (GState gState : arrayList) {
            gState.collectContexts();
        }
        TimerPool.getTimer(this, "Collect Contexts").stop();
        TimerPool.getTimer(this, "Expand States").start();
        for (GState gState : arrayList) {
            gState.expand();
        }
        TimerPool.getTimer(this, "Expand States").stop();
        TimerPool.getTimer(this, "Connect Nodes").start();
        for (GState gState : arrayList) {
            gState.connect();
        }
        TimerPool.getTimer(this, "Connect Nodes").stop();
        SentenceHMMState sentenceHMMState = this.findStartingState();
        if (this.addOutOfGrammarBranch) {
            CIPhoneLoop cIPhoneLoop = new CIPhoneLoop(this.phoneLoopAcousticModel, this.logPhoneInsertionProbability);
            SentenceHMMState sentenceHMMState2 = (SentenceHMMState)cIPhoneLoop.getSearchGraph().getInitialState();
            sentenceHMMState.connect(this.getArc(sentenceHMMState2, 0.0f, this.logOutOfGrammarBranchProbability));
        }
        this.searchGraph = new FlatSearchGraph(sentenceHMMState);
        TimerPool.getTimer(this, "Compile").stop();
        if (this.dumpGStates) {
            for (GrammarNode grammarNode : this.grammar.getGrammarNodes()) {
                GState gState = this.getGState(grammarNode);
                gState.dumpInfo();
            }
        }
        this.nodeStateMap = null;
        this.arcPool = null;
        return SentenceHMMState.collectStates(sentenceHMMState);
    }

    protected GState createGState(GrammarNode grammarNode) {
        return new GState(grammarNode);
    }

    protected void addStartingPath() {
        this.addStartingPath(this.grammar.getInitialNode());
    }

    protected void addStartingPath(GrammarNode grammarNode) {
        GrammarNode grammarNode2 = grammarNode;
        GState gState = this.getGState(grammarNode2);
        gState.addLeftContext(UnitContext.SILENCE);
    }

    protected boolean grammarHasChanged() {
        return this.initialGrammarState == null || this.initialGrammarState != this.grammar.getInitialNode();
    }

    protected SentenceHMMState findStartingState() {
        GrammarNode grammarNode = this.grammar.getInitialNode();
        GState gState = this.getGState(grammarNode);
        return gState.getEntryPoint();
    }

    protected SentenceHMMStateArc getArc(SentenceHMMState sentenceHMMState, float f, float f2) {
        SentenceHMMStateArc sentenceHMMStateArc = new SentenceHMMStateArc(sentenceHMMState, f * this.languageWeight, f2);
        SentenceHMMStateArc sentenceHMMStateArc2 = this.arcPool.cache(sentenceHMMStateArc);
        this.actualArcs.value = this.arcPool.getMisses();
        this.totalArcs.value = this.arcPool.getHits() + this.arcPool.getMisses();
        return sentenceHMMStateArc2 == null ? sentenceHMMStateArc : sentenceHMMStateArc2;
    }

    protected GState getGState(GrammarNode grammarNode) {
        return this.nodeStateMap.get(grammarNode);
    }

    private void T(String string) {
    }

    protected class GState {
        private final Map<ContextPair, List<SearchState>> entryPoints = new HashMap<ContextPair, List<SearchState>>();
        private final Map<ContextPair, List<SearchState>> exitPoints = new HashMap<ContextPair, List<SearchState>>();
        private final Map<String, SentenceHMMState> existingStates = new HashMap<String, SentenceHMMState>();
        private final GrammarNode node;
        private final Set<UnitContext> rightContexts = new HashSet<UnitContext>();
        private final Set<UnitContext> leftContexts = new HashSet<UnitContext>();
        private Set<UnitContext> startingContexts;
        private int exitConnections;

        protected GState(GrammarNode grammarNode) {
            this.node = grammarNode;
            FlatLinguist.this.nodeStateMap.put(grammarNode, this);
        }

        private Set<UnitContext> getStartingContexts() {
            block4: {
                if (this.startingContexts != null) break block4;
                this.startingContexts = new HashSet<UnitContext>();
                if (this.node.isEmpty()) {
                    GrammarArc[] grammarArcArray;
                    for (GrammarArc grammarArc : grammarArcArray = this.getSuccessors()) {
                        GState gState = FlatLinguist.this.getGState(grammarArc.getGrammarNode());
                        this.startingContexts.addAll(gState.getStartingContexts());
                    }
                } else {
                    Pronunciation[] pronunciationArray;
                    Word word = this.node.getWord();
                    for (Pronunciation pronunciation : pronunciationArray = word.getPronunciations()) {
                        UnitContext unitContext = this.getStartingContext(pronunciation);
                        this.startingContexts.add(unitContext);
                    }
                }
            }
            return this.startingContexts;
        }

        private UnitContext getStartingContext(Pronunciation pronunciation) {
            int n = this.getRightContextSize();
            Unit[] unitArray = pronunciation.getUnits();
            Unit[] unitArray2 = unitArray.length > n ? Arrays.copyOf(unitArray, n) : unitArray;
            return UnitContext.get(unitArray2);
        }

        Collection<UnitContext> getEndingContexts() {
            ArrayList<UnitContext> arrayList = new ArrayList<UnitContext>();
            if (!this.node.isEmpty()) {
                Pronunciation[] pronunciationArray;
                int n = this.getLeftContextSize();
                Word word = this.node.getWord();
                for (Pronunciation pronunciation : pronunciationArray = word.getPronunciations()) {
                    Unit[] unitArray = pronunciation.getUnits();
                    int n2 = unitArray.length;
                    Unit[] unitArray2 = n2 > n ? Arrays.copyOfRange(unitArray, n2 - n, n2) : unitArray;
                    arrayList.add(UnitContext.get(unitArray2));
                }
            }
            return arrayList;
        }

        private void pullRightContexts() {
            GrammarArc[] grammarArcArray;
            for (GrammarArc grammarArc : grammarArcArray = this.getSuccessors()) {
                GState gState = FlatLinguist.this.getGState(grammarArc.getGrammarNode());
                this.rightContexts.addAll(gState.getStartingContexts());
            }
        }

        private GrammarArc[] getSuccessors() {
            return this.node.getSuccessors();
        }

        void pushLeftContexts() {
            Collection<UnitContext> collection = this.getEndingContexts();
            HashSet<GrammarNode> hashSet = new HashSet<GrammarNode>();
            this.pushLeftContexts(hashSet, collection);
        }

        void pushLeftContexts(Set<GrammarNode> set, Collection<UnitContext> collection) {
            if (set.contains(this.getNode())) {
                return;
            }
            set.add(this.getNode());
            for (GrammarArc grammarArc : this.getSuccessors()) {
                GState gState = FlatLinguist.this.getGState(grammarArc.getGrammarNode());
                gState.addLeftContext(collection);
                if (!gState.getNode().isEmpty()) continue;
                gState.pushLeftContexts(set, collection);
            }
        }

        private void addLeftContext(Collection<UnitContext> collection) {
            this.leftContexts.addAll(collection);
        }

        private void addLeftContext(UnitContext unitContext) {
            this.leftContexts.add(unitContext);
        }

        private List<SearchState> getEntryPoints(ContextPair contextPair) {
            return this.entryPoints.get(contextPair);
        }

        public SentenceHMMState getEntryPoint() {
            ContextPair contextPair = ContextPair.get(UnitContext.SILENCE, UnitContext.SILENCE);
            List<SearchState> list = this.getEntryPoints(contextPair);
            return list == null || list.isEmpty() ? null : (SentenceHMMState)list.get(0);
        }

        public void collectContexts() {
            this.pullRightContexts();
            this.pushLeftContexts();
        }

        public void expand() {
            Object object;
            for (UnitContext object2 : this.leftContexts) {
                for (UnitContext unitContext : this.getStartingContexts()) {
                    object = ContextPair.get(object2, unitContext);
                    this.entryPoints.put((ContextPair)object, new ArrayList());
                }
            }
            if (this.node.isFinalNode()) {
                Iterator<Object> iterator = new GrammarState(this.node);
                for (List<SearchState> list : this.entryPoints.values()) {
                    list.add((SearchState)((Object)iterator));
                }
            } else if (!this.node.isEmpty()) {
                for (UnitContext unitContext : this.leftContexts) {
                    this.expandWord(unitContext);
                }
            } else {
                for (Map.Entry entry : this.entryPoints.entrySet()) {
                    ContextPair contextPair = (ContextPair)entry.getKey();
                    List list = (List)entry.getValue();
                    object = new BranchState(contextPair.getLeftContext().toString(), contextPair.getRightContext().toString(), this.node.getID());
                    list.add(object);
                    this.addExitPoint(contextPair, (SentenceHMMState)object);
                }
            }
            this.addEmptyEntryPoints();
        }

        private void addEmptyEntryPoints() {
            HashMap hashMap = new HashMap();
            for (Map.Entry<ContextPair, List<SearchState>> entry : this.entryPoints.entrySet()) {
                ContextPair contextPair = entry.getKey();
                if (!this.needsEmptyVersion(contextPair)) continue;
                ContextPair contextPair2 = ContextPair.get(contextPair.getLeftContext(), UnitContext.EMPTY);
                ArrayList arrayList = (ArrayList)hashMap.get(contextPair2);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(contextPair2, arrayList);
                }
                arrayList.addAll(entry.getValue());
            }
            this.entryPoints.putAll(hashMap);
        }

        private boolean needsEmptyVersion(ContextPair contextPair) {
            UnitContext unitContext = contextPair.getLeftContext();
            Unit[] unitArray = unitContext.getUnits();
            return unitArray.length > 0 && this.getRightContextSize(unitArray[0]) < this.getRightContextSize();
        }

        private GrammarNode getNode() {
            return this.node;
        }

        private void expandWord(UnitContext unitContext) {
            Word word = this.node.getWord();
            FlatLinguist.this.T("  Expanding word " + word + " for lc " + unitContext);
            Pronunciation[] pronunciationArray = word.getPronunciations();
            for (int i = 0; i < pronunciationArray.length; ++i) {
                this.expandPronunciation(unitContext, pronunciationArray[i], i);
            }
        }

        private void expandPronunciation(UnitContext unitContext, Pronunciation pronunciation, int n) {
            UnitContext unitContext2 = this.getStartingContext(pronunciation);
            String string = "P(" + pronunciation.getWord() + '[' + unitContext + ',' + unitContext2 + "])-G" + this.getNode().getID();
            PronunciationState pronunciationState = new PronunciationState(string, pronunciation, n);
            FlatLinguist.this.T("     Expanding " + pronunciationState.getPronunciation() + " for lc " + unitContext);
            ContextPair contextPair = ContextPair.get(unitContext, unitContext2);
            List<SearchState> list = this.entryPoints.get(contextPair);
            if (list == null) {
                throw new Error("No EP list for context pair " + contextPair);
            }
            list.add(pronunciationState);
            Unit[] unitArray = pronunciation.getUnits();
            int n2 = unitArray.length - this.getRightContextSize();
            if (n2 < 0) {
                n2 = 0;
            }
            SentenceHMMState sentenceHMMState = pronunciationState;
            for (int i = 0; sentenceHMMState != null && i < n2; ++i) {
                sentenceHMMState = this.attachUnit(pronunciationState, sentenceHMMState, unitArray, i, unitContext, UnitContext.EMPTY);
            }
            PronunciationState pronunciationState2 = sentenceHMMState;
            for (UnitContext unitContext3 : this.rightContexts) {
                sentenceHMMState = pronunciationState2;
                for (int i = n2; sentenceHMMState != null && i < unitArray.length; ++i) {
                    sentenceHMMState = this.attachUnit(pronunciationState, sentenceHMMState, unitArray, i, unitContext, unitContext3);
                }
            }
        }

        private SentenceHMMState attachUnit(PronunciationState pronunciationState, SentenceHMMState sentenceHMMState, Unit[] unitArray, int n, UnitContext unitContext, UnitContext unitContext2) {
            Unit[] unitArray2 = this.getLC(unitContext, unitArray, n);
            Unit[] unitArray3 = this.getRC(unitArray, n, unitContext2);
            UnitContext unitContext3 = UnitContext.get(unitArray3);
            LeftRightContext leftRightContext = LeftRightContext.get(unitArray2, unitArray3);
            Unit unit = FlatLinguist.this.unitManager.getUnit(unitArray[n].getName(), unitArray[n].isFiller(), leftRightContext);
            ExtendedUnitState extendedUnitState = new ExtendedUnitState(pronunciationState, n, unit);
            float f = extendedUnitState.getUnit().isSilence() ? FlatLinguist.this.logSilenceInsertionProbability : (extendedUnitState.getUnit().isFiller() ? FlatLinguist.this.logFillerInsertionProbability : (extendedUnitState.getWhich() == 0 ? FlatLinguist.this.logWordInsertionProbability : FlatLinguist.this.logUnitInsertionProbability));
            SentenceHMMState sentenceHMMState2 = this.getExistingState(extendedUnitState);
            if (sentenceHMMState2 != null) {
                this.attachState(sentenceHMMState, sentenceHMMState2, 0.0f, f);
                return null;
            }
            this.attachState(sentenceHMMState, extendedUnitState, 0.0f, f);
            this.addStateToCache(extendedUnitState);
            sentenceHMMState = this.expandUnit(extendedUnitState);
            if (extendedUnitState.isLast()) {
                UnitContext unitContext4 = this.generateNextLeftContext(unitContext, unitArray[n]);
                ContextPair contextPair = ContextPair.get(unitContext4, unitContext3);
                this.addExitPoint(contextPair, sentenceHMMState);
            }
            return sentenceHMMState;
        }

        private void addExitPoint(ContextPair contextPair, SentenceHMMState sentenceHMMState) {
            List<SearchState> list = this.exitPoints.get(contextPair);
            if (list == null) {
                list = new ArrayList<SearchState>();
                this.exitPoints.put(contextPair, list);
            }
            list.add(sentenceHMMState);
        }

        private Unit[] getLC(UnitContext unitContext, Unit[] unitArray, int n) {
            Unit[] unitArray2 = unitContext.getUnits();
            int n2 = unitArray2.length + n;
            int n3 = Math.min(n2, this.getLeftContextSize(unitArray[n]));
            int n4 = n - n3;
            Unit[] unitArray3 = new Unit[n3];
            for (int i = 0; i < unitArray3.length; ++i) {
                int n5 = n4 + i;
                unitArray3[i] = n5 < 0 ? unitArray2[unitArray2.length + n5] : unitArray[n5];
            }
            return unitArray3;
        }

        private Unit[] getRC(Unit[] unitArray, int n, UnitContext unitContext) {
            Unit[] unitArray2 = unitContext.getUnits();
            int n2 = n + 1;
            int n3 = unitArray.length - n2 + unitArray2.length;
            int n4 = Math.min(n3, this.getRightContextSize(unitArray[n]));
            Unit[] unitArray3 = new Unit[n4];
            for (int i = 0; i < unitArray3.length; ++i) {
                int n5 = n2 + i;
                unitArray3[i] = n5 < unitArray.length ? unitArray[n5] : unitArray2[n5 - unitArray.length];
            }
            return unitArray3;
        }

        private int getLeftContextSize(Unit unit) {
            return unit.isFiller() ? 0 : this.getLeftContextSize();
        }

        private int getRightContextSize(Unit unit) {
            return unit.isFiller() ? 0 : this.getRightContextSize();
        }

        protected int getLeftContextSize() {
            return FlatLinguist.this.acousticModel.getLeftContextSize();
        }

        protected int getRightContextSize() {
            return FlatLinguist.this.acousticModel.getRightContextSize();
        }

        UnitContext generateNextLeftContext(UnitContext unitContext, Unit unit) {
            Unit[] unitArray = unitContext.getUnits();
            int n = Math.min(unitArray.length, this.getLeftContextSize());
            if (n == 0) {
                return UnitContext.EMPTY;
            }
            Unit[] unitArray2 = Arrays.copyOfRange(unitArray, 1, n + 1);
            unitArray2[n - 1] = unit;
            return UnitContext.get(unitArray2);
        }

        protected SentenceHMMState expandUnit(UnitState unitState) {
            HMMStateState hMMStateState = this.getHMMStates(unitState);
            if (unitState.getUnit().isSilence()) {
                this.attachState(hMMStateState, unitState, 0.0f, FlatLinguist.this.logSilenceInsertionProbability);
            }
            return hMMStateState;
        }

        private HMMStateState getHMMStates(UnitState unitState) {
            Unit unit = unitState.getUnit();
            HMMPosition hMMPosition = unitState.getPosition();
            HMM hMM = FlatLinguist.this.acousticModel.lookupNearestHMM(unit, hMMPosition, false);
            HMMState hMMState = hMM.getInitialState();
            HMMStateState hMMStateState = new HMMStateState(unitState, hMMState);
            this.attachState(unitState, hMMStateState, 0.0f, 0.0f);
            this.addStateToCache(hMMStateState);
            HMMStateState hMMStateState2 = this.expandHMMTree(unitState, hMMStateState);
            return hMMStateState2;
        }

        private HMMStateState expandHMMTree(UnitState unitState, HMMStateState hMMStateState) {
            HMMStateState hMMStateState2 = hMMStateState;
            for (HMMStateArc hMMStateArc : hMMStateState.getHMMState().getSuccessors()) {
                HMMStateState hMMStateState3 = hMMStateArc.getHMMState().isEmitting() ? new HMMStateState(unitState, hMMStateArc.getHMMState()) : new NonEmittingHMMState(unitState, hMMStateArc.getHMMState());
                SentenceHMMState sentenceHMMState = this.getExistingState(hMMStateState3);
                float f = hMMStateArc.getLogProbability();
                if (sentenceHMMState != null) {
                    this.attachState(hMMStateState, sentenceHMMState, 0.0f, f);
                    continue;
                }
                this.attachState(hMMStateState, hMMStateState3, 0.0f, f);
                this.addStateToCache(hMMStateState3);
                hMMStateState2 = this.expandHMMTree(unitState, hMMStateState3);
            }
            return hMMStateState2;
        }

        public void connect() {
            for (GrammarArc grammarArc : this.getSuccessors()) {
                GState gState = FlatLinguist.this.getGState(grammarArc.getGrammarNode());
                if (!gState.getNode().isEmpty() && gState.getNode().getWord().getSpelling().equals("<s>")) continue;
                float f = grammarArc.getProbability();
                if (FlatLinguist.this.spreadWordProbabilitiesAcrossPronunciations && !gState.getNode().isEmpty()) {
                    int n = gState.getNode().getWord().getPronunciations().length;
                    f -= FlatLinguist.this.logMath.linearToLog(n);
                }
                float f2 = f;
                for (Map.Entry<ContextPair, List<SearchState>> entry : this.exitPoints.entrySet()) {
                    List<SearchState> list = gState.getEntryPoints(entry.getKey());
                    if (list == null) continue;
                    List<SearchState> list2 = entry.getValue();
                    this.connect(list2, list, f2);
                }
            }
        }

        private void connect(List<SearchState> list, List<SearchState> list2, float f) {
            for (SearchState searchState : list) {
                SentenceHMMState sentenceHMMState = (SentenceHMMState)searchState;
                for (SearchState searchState2 : list2) {
                    SentenceHMMState sentenceHMMState2 = (SentenceHMMState)searchState2;
                    sentenceHMMState.connect(FlatLinguist.this.getArc(sentenceHMMState2, f, 0.0f));
                    ++this.exitConnections;
                }
            }
        }

        protected void attachState(SentenceHMMState sentenceHMMState, SentenceHMMState sentenceHMMState2, float f, float f2) {
            sentenceHMMState.connect(FlatLinguist.this.getArc(sentenceHMMState2, f, f2));
            if (FlatLinguist.this.showCompilationProgress && FlatLinguist.this.totalStateCounter++ % 1000 == 0) {
                System.out.print(".");
            }
        }

        public Collection<SearchState> getStates() {
            ArrayList<SearchState> arrayList = new ArrayList<SearchState>(this.existingStates.values());
            for (List<SearchState> list : this.entryPoints.values()) {
                arrayList.addAll(list);
            }
            return arrayList;
        }

        private SentenceHMMState getExistingState(SentenceHMMState sentenceHMMState) {
            return this.existingStates.get(sentenceHMMState.getSignature());
        }

        private void addStateToCache(SentenceHMMState sentenceHMMState) {
            this.existingStates.put(sentenceHMMState.getSignature(), sentenceHMMState);
        }

        void dumpInfo() {
            System.out.println(" ==== " + this + " ========");
            System.out.print("Node: " + this.node);
            if (this.node.isEmpty()) {
                System.out.print("  (Empty)");
            } else {
                System.out.print(" " + this.node.getWord());
            }
            System.out.print(" ep: " + this.entryPoints.size());
            System.out.print(" exit: " + this.exitPoints.size());
            System.out.print(" cons: " + this.exitConnections);
            System.out.print(" tot: " + this.getStates().size());
            System.out.print(" sc: " + this.getStartingContexts().size());
            System.out.print(" rc: " + this.leftContexts.size());
            System.out.println(" lc: " + this.rightContexts.size());
            this.dumpDetails();
        }

        void dumpDetails() {
            this.dumpCollection(" entryPoints", this.entryPoints.keySet());
            this.dumpCollection(" entryPoints states", this.entryPoints.values());
            this.dumpCollection(" exitPoints", this.exitPoints.keySet());
            this.dumpCollection(" exitPoints states", this.exitPoints.values());
            this.dumpNextNodes();
            this.dumpExitPoints(this.exitPoints.values());
            this.dumpCollection(" startingContexts", this.getStartingContexts());
            this.dumpCollection(" branchingInFrom", this.leftContexts);
            this.dumpCollection(" branchingOutTo", this.rightContexts);
            this.dumpCollection(" existingStates", this.existingStates.keySet());
        }

        private void dumpNextNodes() {
            System.out.println("     Next Grammar Nodes: ");
            for (GrammarArc grammarArc : this.node.getSuccessors()) {
                System.out.println("          " + grammarArc.getGrammarNode());
            }
        }

        private void dumpExitPoints(Collection<List<SearchState>> collection) {
            for (List<SearchState> list : collection) {
                for (SearchState searchState : list) {
                    System.out.println("      Arcs from: " + searchState);
                    for (SearchStateArc searchStateArc : searchState.getSuccessors()) {
                        System.out.println("          " + searchStateArc.getState());
                    }
                }
            }
        }

        private void dumpCollection(String string, Collection<?> collection) {
            System.out.println("     " + string);
            for (Object obj : collection) {
                System.out.println("         " + obj);
            }
        }

        public String toString() {
            if (this.node.isEmpty()) {
                return "GState " + this.node + "(empty)";
            }
            return "GState " + this.node + " word " + this.node.getWord();
        }
    }

    protected class FlatSearchGraph
    implements SearchGraph {
        private final SearchState initialState;

        public FlatSearchGraph(SearchState searchState) {
            this.initialState = searchState;
        }

        @Override
        public boolean getWordTokenFirst() {
            return true;
        }

        @Override
        public SearchState getInitialState() {
            return this.initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 7;
        }
    }
}

