/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.AlternativeState;
import edu.cmu.sphinx.linguist.flat.GrammarState;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.flat.WordState;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GrammarPoint {
    private GrammarNode node;
    private int alternativeIndex;
    private int wordIndex;
    private int pronunciationIndex;
    private int unitIndex;
    private static boolean bounded;

    public GrammarPoint(SentenceHMMState sentenceHMMState) {
        while (sentenceHMMState != null) {
            if (sentenceHMMState instanceof UnitState) {
                this.unitIndex = sentenceHMMState.getWhich();
            } else if (sentenceHMMState instanceof PronunciationState) {
                this.pronunciationIndex = sentenceHMMState.getWhich();
            } else if (sentenceHMMState instanceof WordState) {
                this.wordIndex = sentenceHMMState.getWhich();
            } else if (sentenceHMMState instanceof AlternativeState) {
                this.alternativeIndex = sentenceHMMState.getWhich();
            } else if (sentenceHMMState instanceof GrammarState) {
                this.node = ((GrammarState)sentenceHMMState).getGrammarNode();
            }
            sentenceHMMState = sentenceHMMState.getParent();
        }
        assert (this.node != null);
    }

    public GrammarPoint(GrammarNode grammarNode) {
        this(grammarNode, -1, 0, 0, 0);
    }

    public GrammarPoint(PronunciationState pronunciationState, int n) {
        this(pronunciationState);
        this.unitIndex = n;
    }

    public GrammarPoint(GrammarNode grammarNode, int n, int n2, int n3, int n4) {
        assert (grammarNode != null);
        this.node = grammarNode;
        this.alternativeIndex = n;
        this.wordIndex = n2;
        this.pronunciationIndex = n3;
        this.unitIndex = n4;
    }

    private Unit getUnit() {
        Unit[] unitArray;
        Pronunciation[] pronunciationArray;
        Word[] wordArray;
        Unit unit = null;
        Word[][] wordArray2 = this.node.getAlternatives();
        if (this.alternativeIndex != -1 && this.alternativeIndex < wordArray2.length && this.wordIndex < (wordArray = wordArray2[this.alternativeIndex]).length && this.pronunciationIndex < (pronunciationArray = wordArray[this.wordIndex].getPronunciations()).length && this.unitIndex < (unitArray = pronunciationArray[this.pronunciationIndex].getUnits()).length) {
            unit = unitArray[this.unitIndex];
        }
        return unit;
    }

    private Unit getUnitOrFill() {
        Unit unit = this.getUnit();
        if (unit == null) {
            unit = UnitManager.SILENCE;
        }
        return unit;
    }

    public List<Unit[]> getRightContexts(int n, boolean bl, int n2) {
        ArrayList<Unit[]> arrayList = new ArrayList<Unit[]>();
        List<GrammarPoint> list = this.getNextGrammarPoints(bl);
        if (list.isEmpty()) {
            Unit[] unitArray = Unit.getEmptyContext(n);
            this.addContext(arrayList, unitArray);
        } else {
            for (GrammarPoint grammarPoint : list) {
                Object object;
                if (n == 1) {
                    object = new Unit[n];
                    object[0] = grammarPoint.getUnitOrFill();
                    this.addContext(arrayList, (Unit[])object);
                } else {
                    object = grammarPoint.getRightContexts(n - 1, false, n2 - arrayList.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Unit[] unitArray = (Unit[])iterator.next();
                        Unit[] unitArray2 = Unit.getEmptyContext(unitArray.length + 1);
                        unitArray2[0] = grammarPoint.getUnitOrFill();
                        System.arraycopy(unitArray, 0, unitArray2, 1, unitArray.length);
                        this.addContext(arrayList, unitArray2);
                    }
                }
                if (arrayList.size() < n2) continue;
                break;
            }
        }
        return arrayList;
    }

    private void addContext(List<Unit[]> list, Unit[] unitArray) {
        for (Unit[] unitArray2 : list) {
            if (!Unit.isContextMatch(unitArray2, unitArray)) continue;
            return;
        }
        list.add(unitArray);
    }

    private List<GrammarPoint> getNextGrammarPoints(boolean bl) {
        ArrayList<GrammarPoint> arrayList = new ArrayList<GrammarPoint>();
        int n = 0;
        if (this.alternativeIndex == -1 && this.node.getAlternatives().length > 0) {
            for (int i = 0; i < this.node.getAlternatives().length; ++i) {
                GrammarPoint grammarPoint = new GrammarPoint(this.node, i, 0, 0, 0);
                arrayList.add(grammarPoint);
            }
        } else if (this.node.getAlternatives().length == 0) {
            GrammarPoint.addNextGrammarPointsWithWords(this.node, arrayList);
        } else {
            GrammarPoint grammarPoint = bl ? this : new GrammarPoint(this.node, this.alternativeIndex, this.wordIndex, this.pronunciationIndex, this.unitIndex + 1);
            Pronunciation[] pronunciationArray = this.node.getAlternatives()[this.alternativeIndex][this.wordIndex].getPronunciations();
            n = pronunciationArray[this.pronunciationIndex].getUnits().length;
            if (grammarPoint.unitIndex < n) {
                arrayList.add(grammarPoint);
            } else {
                grammarPoint.unitIndex = 0;
                Word[] wordArray = grammarPoint.node.getAlternatives()[this.alternativeIndex];
                if (++grammarPoint.wordIndex < wordArray.length) {
                    Word word = wordArray[grammarPoint.wordIndex];
                    for (int i = 0; i < word.getPronunciations().length; ++i) {
                        GrammarPoint grammarPoint2 = new GrammarPoint(grammarPoint.node, grammarPoint.alternativeIndex, grammarPoint.wordIndex, i, 0);
                        arrayList.add(grammarPoint2);
                    }
                } else if (!bounded) {
                    GrammarPoint.addNextGrammarPointsWithWords(grammarPoint.node, arrayList);
                }
            }
        }
        return arrayList;
    }

    private static List<GrammarNode> getNextGrammarNodesWithWords(GrammarNode grammarNode) {
        ArrayList<GrammarNode> arrayList = new ArrayList<GrammarNode>();
        for (GrammarArc grammarArc : grammarNode.getSuccessors()) {
            GrammarNode grammarNode2 = grammarArc.getGrammarNode();
            if (grammarNode2.getAlternatives().length == 0) {
                if (grammarNode2.isFinalNode()) {
                    arrayList.add(grammarNode2);
                    continue;
                }
                arrayList.addAll(GrammarPoint.getNextGrammarNodesWithWords(grammarNode2));
                continue;
            }
            arrayList.add(grammarNode2);
        }
        return arrayList;
    }

    private static void addNextGrammarPointsWithWords(GrammarNode grammarNode, List<GrammarPoint> list) {
        for (GrammarNode grammarNode2 : GrammarPoint.getNextGrammarNodesWithWords(grammarNode)) {
            for (int i = 0; i < grammarNode2.getAlternatives().length; ++i) {
                GrammarPoint grammarPoint = new GrammarPoint(grammarNode2, i, 0, 0, 0);
                list.add(grammarPoint);
            }
        }
    }

    static void setBounded(boolean bl) {
        bounded = bl;
    }
}

