/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateVisitor;
import edu.cmu.sphinx.linguist.flat.WordState;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class SentenceHMMState
implements Serializable,
SearchState {
    private static final int MASK_IS_FINAL = 1;
    private static final int MASK_COLOR_RED = 2;
    private static final int MASK_PROCESSED = 4;
    private static final int MASK_FAN_IN = 8;
    private static final int MASK_IS_WORD_START = 16;
    private static final int MASK_IS_SHARED_STATE = 32;
    private static final int MASK_WHICH = 65535;
    private static final int SHIFT_WHICH = 8;
    private static int globalStateNumber = -1000;
    private int stateNumber = globalStateNumber--;
    private int fields;
    private String name;
    private final Map<String, SentenceHMMStateArc> arcs = new LinkedHashMap<String, SentenceHMMStateArc>();
    private SentenceHMMState parent;
    private String cachedName;
    private String fullName;
    private SentenceHMMStateArc[] successorArray;

    protected SentenceHMMState(String string, SentenceHMMState sentenceHMMState, int n) {
        this();
        this.name = string + n;
        this.parent = sentenceHMMState;
        this.setWhich(n);
        this.setProcessed(false);
        this.setColor(Color.RED);
    }

    protected SentenceHMMState() {
    }

    public boolean isWordStart() {
        return (this.fields & 0x10) == 16;
    }

    public void setWordStart(boolean bl) {
        this.fields = bl ? (this.fields |= 0x10) : (this.fields &= 0xFFFFFFEF);
    }

    public boolean isSharedState() {
        return (this.fields & 0x20) == 32;
    }

    public void setSharedState(boolean bl) {
        this.fields = bl ? (this.fields |= 0x20) : (this.fields &= 0xFFFFFFDF);
    }

    public Word getAssociatedWord() {
        SentenceHMMState sentenceHMMState;
        Word word = null;
        for (sentenceHMMState = this; sentenceHMMState != null && !(sentenceHMMState instanceof WordState); sentenceHMMState = sentenceHMMState.getParent()) {
        }
        if (sentenceHMMState != null) {
            WordState wordState = (WordState)sentenceHMMState;
            word = wordState.getWord();
        }
        return word;
    }

    public String getTypeLabel() {
        return "state";
    }

    public boolean isFanIn() {
        return (this.fields & 8) == 8;
    }

    public void setFanIn(boolean bl) {
        this.fields = bl ? (this.fields |= 8) : (this.fields &= 0xFFFFFFF7);
    }

    public void setProcessed(boolean bl) {
        this.fields = bl ? (this.fields |= 4) : (this.fields &= 0xFFFFFFFB);
    }

    public boolean isProcessed() {
        return (this.fields & 4) == 4;
    }

    public void resetAllProcessed() {
        SentenceHMMState.visitStates(new SentenceHMMStateVisitor(){

            @Override
            public boolean visit(SentenceHMMState sentenceHMMState) {
                sentenceHMMState.setProcessed(false);
                return false;
            }
        }, this, false);
    }

    @Override
    public WordSequence getWordHistory() {
        return WordSequence.EMPTY;
    }

    public int getNumSuccessors() {
        return this.arcs.size();
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        if (this.successorArray == null) {
            this.successorArray = this.arcs.values().toArray(new SentenceHMMStateArc[this.arcs.size()]);
        }
        return this.successorArray;
    }

    @Override
    public SentenceHMMState getLexState() {
        return this;
    }

    void deleteSuccessor(SentenceHMMStateArc sentenceHMMStateArc) {
        this.arcs.values().remove(sentenceHMMStateArc);
    }

    public void connect(SentenceHMMStateArc sentenceHMMStateArc) {
        if (this.successorArray != null) {
            this.successorArray = null;
        }
        this.rawConnect(sentenceHMMStateArc);
    }

    private void rawConnect(SentenceHMMStateArc sentenceHMMStateArc) {
        SentenceHMMState sentenceHMMState = (SentenceHMMState)sentenceHMMStateArc.getState();
        this.arcs.put(sentenceHMMState.getValueSignature() + sentenceHMMState.getStateNumber(), sentenceHMMStateArc);
    }

    @Override
    public boolean isEmitting() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return (this.fields & 1) == 1;
    }

    public void setFinalState(boolean bl) {
        this.fields = bl ? (this.fields |= 1) : (this.fields &= 0xFFFFFFFE);
    }

    public boolean isUnit() {
        return false;
    }

    public void dumpAll() {
        SentenceHMMState.visitStates(new SentenceHMMStateVisitor(){

            @Override
            public boolean visit(SentenceHMMState sentenceHMMState) {
                sentenceHMMState.dump();
                return false;
            }
        }, this, true);
    }

    protected String getAnnotation() {
        return "";
    }

    private void dump() {
        System.out.println(" ----- " + this.getTitle() + " ---- ");
        for (int i = 0; i < this.getSuccessors().length; ++i) {
            SentenceHMMStateArc sentenceHMMStateArc = (SentenceHMMStateArc)this.getSuccessors()[i];
            System.out.println("   -> " + sentenceHMMStateArc.getState().toPrettyString());
        }
    }

    public void validateAll() {
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.getName();
    }

    public String toString() {
        if (this.cachedName == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isEmitting()) {
                stringBuilder.append('*');
            }
            stringBuilder.append(this.getName());
            if (this.parent != null) {
                stringBuilder.append('_');
                stringBuilder.append(this.parent);
            }
            if (this.isFinal()) {
                stringBuilder.append('!');
            }
            this.cachedName = stringBuilder.toString();
        }
        return this.cachedName;
    }

    @Override
    public String toPrettyString() {
        return this.toString();
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.parent == null ? this.getName() : this.getName() + '.' + this.parent.getFullName();
        }
        return this.fullName;
    }

    @Override
    public String getSignature() {
        return this.getFullName();
    }

    public String getTitle() {
        return this.getFullName() + ':' + this.stateNumber;
    }

    public int getWhich() {
        return this.fields >> 8 & 0xFFFF;
    }

    public void setWhich(int n) {
        assert (n >= 0 && n <= 65535);
        this.fields |= (n & 0xFFFF) << 8;
    }

    public SentenceHMMState getParent() {
        return this.parent;
    }

    public SentenceHMMStateArc findArc(SentenceHMMState sentenceHMMState) {
        return this.arcs.get(sentenceHMMState.getValueSignature());
    }

    public String getValueSignature() {
        return this.getFullName();
    }

    public static boolean visitStates(SentenceHMMStateVisitor sentenceHMMStateVisitor, SentenceHMMState sentenceHMMState, boolean bl) {
        Object object;
        Object object2 = SentenceHMMState.collectStates(sentenceHMMState);
        if (bl) {
            object = new TreeSet<SentenceHMMState>(new Comparator<SentenceHMMState>(){

                @Override
                public int compare(SentenceHMMState sentenceHMMState, SentenceHMMState sentenceHMMState2) {
                    SentenceHMMState sentenceHMMState3 = sentenceHMMState;
                    SentenceHMMState sentenceHMMState4 = sentenceHMMState2;
                    return sentenceHMMState3.stateNumber - sentenceHMMState4.stateNumber;
                }
            });
            ((TreeSet)object).addAll(object2);
            object2 = object;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            SentenceHMMState sentenceHMMState2 = (SentenceHMMState)object.next();
            if (!sentenceHMMStateVisitor.visit(sentenceHMMState2)) continue;
            return true;
        }
        return false;
    }

    public void setColor(Color color) {
        this.fields = color == Color.RED ? (this.fields |= 2) : (this.fields &= 0xFFFFFFFD);
    }

    public Color getColor() {
        if ((this.fields & 2) == 2) {
            return Color.RED;
        }
        return Color.GREEN;
    }

    private int getStateNumber() {
        return this.stateNumber;
    }

    public static Set<SentenceHMMState> collectStates(SentenceHMMState sentenceHMMState) {
        HashSet<SentenceHMMState> hashSet = new HashSet<SentenceHMMState>();
        LinkedList<SentenceHMMState> linkedList = new LinkedList<SentenceHMMState>();
        linkedList.add(sentenceHMMState);
        while (!linkedList.isEmpty()) {
            SearchStateArc[] searchStateArcArray;
            SentenceHMMState sentenceHMMState2 = (SentenceHMMState)linkedList.remove(0);
            hashSet.add(sentenceHMMState2);
            for (SearchStateArc searchStateArc : searchStateArcArray = sentenceHMMState2.getSuccessors()) {
                SentenceHMMState sentenceHMMState3 = (SentenceHMMState)searchStateArc.getState();
                if (hashSet.contains(sentenceHMMState3) || linkedList.contains(sentenceHMMState3)) continue;
                linkedList.add(sentenceHMMState3);
            }
        }
        return hashSet;
    }

    @Override
    public abstract int getOrder();

    public static enum Color {
        RED,
        GREEN;

    }
}

