/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.util.Cache;

class UnitContext {
    private static final Cache<UnitContext> unitContextCache = new Cache();
    private final Unit[] context;
    private int hashCode = 12;
    public static final UnitContext EMPTY = new UnitContext(Unit.EMPTY_ARRAY);
    public static final UnitContext SILENCE = new UnitContext(new Unit[]{UnitManager.SILENCE});

    private UnitContext(Unit[] unitArray) {
        this.context = unitArray;
        this.hashCode = 12;
        for (int i = 0; i < unitArray.length; ++i) {
            this.hashCode += unitArray[i].getName().hashCode() * ((i + 1) * 34);
        }
    }

    static UnitContext get(Unit[] unitArray) {
        UnitContext unitContext = new UnitContext(unitArray);
        UnitContext unitContext2 = unitContextCache.cache(unitContext);
        return unitContext2 == null ? unitContext : unitContext2;
    }

    public Unit[] getUnits() {
        return this.context;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UnitContext) {
            UnitContext unitContext = (UnitContext)object;
            if (this.context.length != unitContext.context.length) {
                return false;
            }
            for (int i = 0; i < this.context.length; ++i) {
                if (this.context[i] == unitContext.context[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static void dumpInfo() {
        System.out.println("Total number of UnitContexts : " + unitContextCache.getMisses() + " folded: " + unitContextCache.getHits());
    }

    public String toString() {
        return LeftRightContext.getContextName(this.context);
    }

    static {
        unitContextCache.cache(EMPTY);
        unitContextCache.cache(SILENCE);
    }
}

