/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;

public class UnitState
extends SentenceHMMState
implements UnitSearchState {
    private final Unit unit;
    private HMMPosition position = HMMPosition.INTERNAL;

    public UnitState(PronunciationState pronunciationState, int n, Unit unit) {
        super("U", pronunciationState, n);
        this.unit = unit;
        Unit[] unitArray = pronunciationState.getPronunciation().getUnits();
        int n2 = unitArray.length;
        if (unitArray[n2 - 1] == UnitManager.SILENCE && n2 > 1) {
            --n2;
        }
        if (n2 == 1) {
            this.position = HMMPosition.SINGLE;
        } else if (n == 0) {
            this.position = HMMPosition.BEGIN;
        } else if (n == n2 - 1) {
            this.position = HMMPosition.END;
        }
    }

    public UnitState(Unit unit, HMMPosition hMMPosition) {
        this.unit = unit;
        this.position = hMMPosition;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public boolean isLast() {
        return this.position == HMMPosition.SINGLE || this.position == HMMPosition.END;
    }

    @Override
    public String getName() {
        return super.getName() + '<' + this.unit + '>';
    }

    @Override
    public String getValueSignature() {
        return this.unit.toString();
    }

    @Override
    public String getPrettyName() {
        return this.unit.toString();
    }

    @Override
    public String getTypeLabel() {
        return "Unit";
    }

    public HMMPosition getPosition() {
        return this.position;
    }

    @Override
    public boolean isUnit() {
        return true;
    }

    @Override
    public int getOrder() {
        return 5;
    }
}

