/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.g2p;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableFst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.ArcSort;
import edu.cmu.sphinx.fst.operations.Compose;
import edu.cmu.sphinx.fst.operations.ILabelCompare;
import edu.cmu.sphinx.fst.operations.NShortestPaths;
import edu.cmu.sphinx.fst.operations.OLabelCompare;
import edu.cmu.sphinx.fst.operations.Project;
import edu.cmu.sphinx.fst.operations.ProjectType;
import edu.cmu.sphinx.fst.operations.RmEpsilon;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.semiring.TropicalSemiring;
import edu.cmu.sphinx.fst.utils.Utils;
import edu.cmu.sphinx.linguist.g2p.Path;
import edu.cmu.sphinx.linguist.g2p.PathComparator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class G2PConverter {
    String eps = "<eps>";
    String se = "</s>";
    String sb = "<s>";
    String skip = "_";
    String tie = "|";
    HashSet<String> skipSeqs = new HashSet();
    ArrayList<String>[] clusters = null;
    ImmutableFst g2pmodel;
    Fst epsilonFilter;

    public G2PConverter(URL uRL) throws IOException {
        try {
            this.g2pmodel = ImmutableFst.loadModel(uRL.openStream());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Failed to load the model from " + uRL, classNotFoundException);
        }
        this.init();
    }

    public G2PConverter(String string) {
        this.g2pmodel = ImmutableFst.loadModel(string);
        this.init();
    }

    private void init() {
        this.skipSeqs.add(this.eps);
        this.skipSeqs.add(this.sb);
        this.skipSeqs.add(this.se);
        this.skipSeqs.add(this.skip);
        this.skipSeqs.add("-");
        Compose.augment(0, this.g2pmodel, this.g2pmodel.getSemiring());
        ArcSort.apply(this.g2pmodel, new ILabelCompare());
        String[] stringArray = this.g2pmodel.getIsyms();
        this.loadClusters(stringArray);
        this.epsilonFilter = Compose.getFilter(this.g2pmodel.getIsyms(), this.g2pmodel.getSemiring());
        ArcSort.apply(this.epsilonFilter, new ILabelCompare());
    }

    public ArrayList<Path> phoneticize(ArrayList<String> arrayList, int n) {
        Fst fst = this.entryToFSA(arrayList);
        Semiring semiring = fst.getSemiring();
        Compose.augment(1, fst, semiring);
        ArcSort.apply(fst, new OLabelCompare());
        Fst fst2 = Compose.compose(fst, this.epsilonFilter, semiring, true);
        ArcSort.apply(fst2, new OLabelCompare());
        fst2 = Compose.compose(fst2, this.g2pmodel, semiring, true);
        Project.apply(fst2, ProjectType.OUTPUT);
        fst2 = n == 1 ? NShortestPaths.get(fst2, 1, false) : NShortestPaths.get(fst2, n * 10, false);
        fst2 = RmEpsilon.get(fst2);
        ArrayList<Path> arrayList2 = this.findAllPaths(fst2, n, this.skipSeqs, this.tie);
        return arrayList2;
    }

    public ArrayList<Path> phoneticize(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(string.length());
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (Utils.getIndex(this.g2pmodel.getIsyms(), string2) < 0) continue;
            arrayList.add(string2);
        }
        return this.phoneticize(arrayList, n);
    }

    private Fst entryToFSA(ArrayList<String> arrayList) {
        int n;
        int n2;
        TropicalSemiring tropicalSemiring = new TropicalSemiring();
        Fst fst = new Fst(tropicalSemiring);
        State state = new State(tropicalSemiring.zero());
        fst.addState(state);
        fst.setStart(state);
        for (n2 = 0; n2 < arrayList.size() + 1; ++n2) {
            state = new State(tropicalSemiring.zero());
            fst.addState(state);
            if (n2 >= 1) {
                int n3 = Utils.getIndex(this.g2pmodel.getIsyms(), arrayList.get(n2 - 1));
                fst.getState(n2).addArc(new Arc(n3, n3, 0.0f, state));
            } else if (n2 == 0) {
                int n4 = Utils.getIndex(this.g2pmodel.getIsyms(), this.sb);
                fst.getStart().addArc(new Arc(n4, n4, 0.0f, state));
            }
            if (n2 != arrayList.size()) continue;
            State state2 = new State(tropicalSemiring.zero());
            fst.addState(state2);
            n = Utils.getIndex(this.g2pmodel.getIsyms(), this.se);
            state.addArc(new Arc(n, n, 0.0f, state2));
            state2.setFinalWeight(0.0f);
        }
        for (n2 = 0; n2 < this.clusters.length; ++n2) {
            ArrayList<String> arrayList2 = this.clusters[n2];
            if (arrayList2 == null) continue;
            n = 0;
            int n5 = 0;
            while (n5 != -1) {
                n5 = Utils.search(arrayList, arrayList2, n);
                if (n5 == -1) continue;
                State state3 = fst.getState(n + n5 + 1);
                state3.addArc(new Arc(n2, n2, 0.0f, fst.getState(n + n5 + arrayList2.size() + 1)));
                n = n + n5 + arrayList2.size();
            }
        }
        fst.setIsyms(this.g2pmodel.getIsyms());
        fst.setOsyms(this.g2pmodel.getIsyms());
        return fst;
    }

    private ArrayList<Path> findAllPaths(Fst fst, int n, HashSet<String> hashSet, String string) {
        Object object;
        Semiring semiring = fst.getSemiring();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<State, Path> hashMap2 = new HashMap<State, Path>();
        LinkedList<State> linkedList = new LinkedList<State>();
        Path path = new Path(fst.getSemiring());
        path.setCost(semiring.one());
        hashMap2.put(fst.getStart(), path);
        linkedList.add(fst.getStart());
        String[] stringArray = fst.getOsyms();
        while (!linkedList.isEmpty()) {
            object = (State)linkedList.remove();
            Path path2 = (Path)hashMap2.get(object);
            if (((State)object).getFinalWeight() != semiring.zero()) {
                String string2 = path2.getPath().toString();
                if (hashMap.containsKey(string2)) {
                    Path path3 = (Path)hashMap.get(string2);
                    if (path3.getCost() > path2.getCost()) {
                        hashMap.put(string2, path2);
                    }
                } else {
                    hashMap.put(string2, path2);
                }
            }
            int n2 = ((State)object).getNumArcs();
            for (int i = 0; i < n2; ++i) {
                Arc arc = ((State)object).getArc(i);
                path = new Path(fst.getSemiring());
                Path path4 = (Path)hashMap2.get(object);
                path.setCost(path4.getCost());
                path.setPath((ArrayList)path4.getPath().clone());
                String string3 = stringArray[arc.getOlabel()];
                String[] stringArray2 = string3.split("\\" + string);
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string4 = stringArray2[j];
                    if (hashSet.contains(string4)) continue;
                    path.getPath().add(string4);
                }
                path.setCost(semiring.times(path.getCost(), arc.getWeight()));
                State state = arc.getNextState();
                hashMap2.put(state, path);
                if (linkedList.contains(state)) continue;
                linkedList.add(state);
            }
        }
        object = new ArrayList();
        for (Path path5 : hashMap.values()) {
            ((ArrayList)object).add(path5);
        }
        Collections.sort(object, new PathComparator());
        int n3 = ((ArrayList)object).size();
        for (int i = n; i < n3; ++i) {
            ((ArrayList)object).remove(((ArrayList)object).size() - 1);
        }
        return object;
    }

    private void loadClusters(String[] stringArray) {
        int n;
        this.clusters = new ArrayList[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.clusters[n] = null;
        }
        for (n = 2; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (!string.contains(this.tie)) continue;
            String[] stringArray2 = string.split(Pattern.quote(this.tie));
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
            this.clusters[n] = arrayList;
        }
    }
}

