/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.classes.ClassMap;
import edu.cmu.sphinx.linguist.language.classes.ClassProbability;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ClassBasedLanguageModel
implements LanguageModel {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_CLASS_LANGUAGE_MODEL = "classLanguageModel";
    @S4Component(type=ClassMap.class)
    public static final String PROP_CLASS_MAP = "classMap";
    private LanguageModel classLM;
    private Set<String> vocabulary;
    private boolean allocated = false;
    private ClassMap classMap;

    public ClassBasedLanguageModel(ClassMap classMap, LanguageModel languageModel) {
        this.classMap = classMap;
        this.classLM = languageModel;
    }

    public ClassBasedLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        if (this.allocated) {
            throw new PropertyException(ClassBasedLanguageModel.class.getName(), null, "Can't change properties after allocation");
        }
        this.classMap = (ClassMap)propertySheet.getComponent(PROP_CLASS_MAP);
        this.classLM = (LanguageModel)propertySheet.getComponent(PROP_CLASS_LANGUAGE_MODEL);
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.classMap.allocate();
            this.classLM.allocate();
            this.makeVocabulary();
        }
    }

    @Override
    public void deallocate() throws IOException {
        this.allocated = false;
        this.classLM.deallocate();
        this.classMap.deallocate();
        this.vocabulary = null;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Word[] wordArray = new Word[wordSequence.size()];
        float f = 0.0f;
        for (int i = 0; i < wordArray.length; ++i) {
            Word word = wordSequence.getWord(i);
            ClassProbability classProbability = this.classMap.getClassProbability(word.getSpelling());
            Word word2 = wordArray[i] = classProbability == null ? word : this.classMap.getClassAsWord(classProbability.getClassName());
            if (i != wordArray.length - 1 || classProbability == null) continue;
            f = classProbability.getLogProbability();
        }
        float f2 = this.classLM.getProbability(new WordSequence(wordArray));
        return f2 + f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        return this.classLM.getMaxDepth();
    }

    @Override
    public void onUtteranceEnd() {
    }

    private void makeVocabulary() {
        this.vocabulary = new HashSet<String>();
        for (String string : this.classLM.getVocabulary()) {
            Set<String> set = this.classMap.getWordsInClass(string);
            if (set == null) {
                this.vocabulary.add(string);
                continue;
            }
            this.vocabulary.addAll(set);
        }
    }
}

