/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.classes.ClassProbability;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassMap
implements Configurable {
    @S4String
    public static final String PROP_CLASS_DEFS_LOCATION = "classDefsLocation";
    private Logger logger;
    private boolean allocated;
    private URL classDefsLocation;
    private LogMath logMath;
    private Map<String, Word> classVocabulary = new HashMap<String, Word>();
    private Map<String, ClassProbability> wordToClassProbabilities = new HashMap<String, ClassProbability>();
    private final HashMap<String, Set<String>> classToWord = new HashMap();

    public ClassMap(URL uRL) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.classDefsLocation = uRL;
        this.logMath = LogMath.getLogMath();
    }

    public ClassMap() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.classDefsLocation = ConfigurationManagerUtils.getResource(PROP_CLASS_DEFS_LOCATION, propertySheet);
    }

    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.loadClassDefs();
        }
    }

    public void deallocate() {
        this.allocated = false;
        this.wordToClassProbabilities = null;
        this.classVocabulary = null;
    }

    public ClassProbability getClassProbability(String string) {
        return this.wordToClassProbabilities.get(string);
    }

    public Word getClassAsWord(String string) {
        return this.classVocabulary.get(string);
    }

    public Set<String> getWordsInClass(String string) {
        return this.classToWord.get(string);
    }

    private void loadClassDefs() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.classDefsLocation.openStream()));
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f=");
            if (stringTokenizer.countTokens() != 3) {
                throw new IOException("corrupt word to class def: " + string + "; " + stringTokenizer.countTokens());
            }
            String string2 = stringTokenizer.nextToken();
            float f = Float.parseFloat(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(string3 + " --> " + string2 + " " + f);
            }
            this.wordToClassProbabilities.put(string3, new ClassProbability(string2, this.logMath.linearToLog(f)));
            this.classVocabulary.put(string2, new Word(string2, null, false));
            this.addWordInClass(string2, string3);
        }
        bufferedReader.close();
        this.checkClasses();
        this.logger.info("Loaded word to class mappings for " + this.wordToClassProbabilities.size() + " words");
    }

    private void checkClasses() {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        for (ClassProbability object : this.wordToClassProbabilities.values()) {
            Float f = (Float)hashMap.get(object.getClassName());
            if (f == null) {
                hashMap.put(object.getClassName(), Float.valueOf(0.0f));
                continue;
            }
            hashMap.put(object.getClassName(), Float.valueOf((float)this.logMath.logToLinear(object.getLogProbability()) + f.floatValue()));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!(Math.abs(1.0 - (double)((Float)entry.getValue()).floatValue()) > 0.001)) continue;
            this.logger.warning("Word probabilities for class " + (String)entry.getKey() + " sum to " + entry.getValue());
        }
    }

    private void addWordInClass(String string, String string2) {
        Set<String> set = this.classToWord.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.classToWord.put(string, set);
        }
        set.add(string2);
    }
}

