/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.classes.ClassMap;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;

public class ClassPresentingDictionary
implements Dictionary {
    @S4Component(type=ClassMap.class)
    public static final String PROP_CLASS_MAP = "classMap";
    @S4Component(type=Dictionary.class)
    public static final String PROP_WORD_DICTIONARY = "wordDictionary";
    private boolean allocated = false;
    private Dictionary wordDictionary;
    private ClassMap classMap;

    public ClassPresentingDictionary(ClassMap classMap, Dictionary dictionary) {
        this.classMap = classMap;
        this.wordDictionary = dictionary;
    }

    public ClassPresentingDictionary() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.classMap = (ClassMap)propertySheet.getComponent(PROP_CLASS_MAP);
        this.wordDictionary = (Dictionary)propertySheet.getComponent(PROP_WORD_DICTIONARY);
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.wordDictionary.allocate();
            this.classMap.allocate();
        }
    }

    @Override
    public void deallocate() {
        this.allocated = false;
        this.wordDictionary = null;
    }

    @Override
    public Word getWord(String string) {
        Word word = this.classMap.getClassAsWord(string);
        return word != null ? word : this.wordDictionary.getWord(string);
    }

    @Override
    public Word getSentenceStartWord() {
        return this.wordDictionary.getSentenceStartWord();
    }

    @Override
    public Word getSentenceEndWord() {
        return this.wordDictionary.getSentenceEndWord();
    }

    @Override
    public Word getSilenceWord() {
        return this.wordDictionary.getSilenceWord();
    }

    @Override
    public Word[] getFillerWords() {
        return this.wordDictionary.getFillerWords();
    }

    public String toString() {
        return "Word dictionary:\n" + this.wordDictionary.toString() + "Classes:\n" + this.classMap.toString();
    }
}

