/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSTGrammar
extends Grammar {
    @S4String(defaultValue="default.arpa_gram")
    public static final String PROP_PATH = "path";
    private boolean addInitialSilenceNode;
    private boolean addOptionalSilence;
    private final boolean ignoreUnknownTransitions = true;
    private String path;
    private LogMath logMath;
    private final Map<String, GrammarNode> nodes = new HashMap<String, GrammarNode>();
    private final Set<GrammarNode> expandedNodes = new HashSet<GrammarNode>();

    @Override
    protected GrammarNode createGrammar(String string) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    public FSTGrammar(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) {
        super(bl, bl2, bl3, bl4, dictionary);
        this.path = string;
        this.logMath = LogMath.getLogMath();
    }

    public FSTGrammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.path = propertySheet.getString(PROP_PATH);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        GrammarNode grammarNode = null;
        GrammarNode grammarNode2 = null;
        int n = this.createNodes(this.path);
        grammarNode2 = this.createGrammarNode(++n, "<sil>");
        grammarNode2.setFinalNode(true);
        n = this.expandWordNodes(n);
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(this.path, true);
        while (!extendedStreamTokenizer.isEOF()) {
            GrammarNode grammarNode3;
            GrammarNode grammarNode4;
            int n2;
            extendedStreamTokenizer.skipwhite();
            String string = extendedStreamTokenizer.getString();
            if (string == null) break;
            if (string.equals("I")) {
                assert (grammarNode == null);
                n2 = extendedStreamTokenizer.getInt("initial ID");
                String string2 = "G" + n2;
                grammarNode = this.createGrammarNode(n2, "<sil>");
                this.nodes.put(string2, grammarNode);
                if (!this.addInitialSilenceNode) continue;
                grammarNode4 = this.createGrammarNode(++n, "<sil>");
                grammarNode.add(grammarNode4, 0.0f);
                grammarNode4.add(grammarNode, 0.0f);
                continue;
            }
            if (string.equals("T")) {
                n2 = extendedStreamTokenizer.getInt("this id");
                int n3 = extendedStreamTokenizer.getInt("next id");
                grammarNode4 = this.get(n2);
                grammarNode3 = this.get(n3);
                if (this.hasEndNode(grammarNode4)) {
                    grammarNode4 = this.getEndNode(grammarNode4);
                }
                float f = 0.0f;
                String string3 = extendedStreamTokenizer.getString();
                if (string3 == null || string3.equals(",")) {
                    if (string3 != null && string3.equals(",")) {
                        extendedStreamTokenizer.getString();
                        f = extendedStreamTokenizer.getFloat("probability");
                    }
                    if (this.hasEndNode(grammarNode3)) {
                        grammarNode3 = this.getEndNode(grammarNode3);
                    }
                } else {
                    String string4 = extendedStreamTokenizer.getString();
                    f = extendedStreamTokenizer.getFloat("probability");
                    if (string4.equals("<unknown>")) continue;
                    assert (this.hasWord(grammarNode3));
                }
                grammarNode4.add(grammarNode3, this.convertProbability(f));
                continue;
            }
            if (!string.equals("F")) continue;
            n2 = extendedStreamTokenizer.getInt("this id");
            float f = extendedStreamTokenizer.getFloat("probability");
            grammarNode4 = this.get(n2);
            grammarNode3 = grammarNode2;
            if (this.hasEndNode(grammarNode4)) {
                grammarNode4 = this.getEndNode(grammarNode4);
            }
            grammarNode4.add(grammarNode3, this.convertProbability(f));
        }
        extendedStreamTokenizer.close();
        assert (grammarNode != null);
        return grammarNode;
    }

    private int createNodes(String string) throws IOException {
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(string, true);
        int n = 0;
        while (!extendedStreamTokenizer.isEOF()) {
            String string2;
            extendedStreamTokenizer.skipwhite();
            String string3 = extendedStreamTokenizer.getString();
            if (string3 == null) break;
            if (!string3.equals("T")) continue;
            extendedStreamTokenizer.getInt("src id");
            int n2 = extendedStreamTokenizer.getInt("dest id");
            if (n2 > n) {
                n = n2;
            }
            if ((string2 = extendedStreamTokenizer.getString()) == null) continue;
            String string4 = extendedStreamTokenizer.getString();
            extendedStreamTokenizer.getString();
            String string5 = "G" + n2;
            GrammarNode grammarNode = this.nodes.get(string5);
            if (grammarNode == null) {
                grammarNode = string4.equals(",") ? this.createGrammarNode(n2, false) : this.createGrammarNode(n2, string4);
                this.nodes.put(string5, grammarNode);
                continue;
            }
            if (!string4.equals(",")) assert (string4.equals(this.getWord(grammarNode)));
        }
        extendedStreamTokenizer.close();
        return n;
    }

    private int expandWordNodes(int n) {
        Collection<GrammarNode> collection = this.nodes.values();
        String[][] stringArray = new String[][]{{"<sil>"}};
        for (GrammarNode grammarNode : collection) {
            if (grammarNode.getNumAlternatives() <= 0) continue;
            GrammarNode grammarNode2 = this.createGrammarNode(++n, false);
            grammarNode.add(grammarNode2, 0.0f);
            if (this.addOptionalSilence) {
                GrammarNode grammarNode3 = this.createGrammarNode(++n, stringArray);
                grammarNode.add(grammarNode3, 0.0f);
                grammarNode3.add(grammarNode2, 0.0f);
            }
            this.expandedNodes.add(grammarNode);
        }
        return n;
    }

    private float convertProbability(float f) {
        return this.logMath.lnToLog(-f);
    }

    private GrammarNode get(int n) {
        String string = "G" + n;
        GrammarNode grammarNode = this.nodes.get(string);
        if (grammarNode == null) {
            grammarNode = this.createGrammarNode(n, false);
            this.nodes.put(string, grammarNode);
        }
        return grammarNode;
    }

    private boolean hasWord(GrammarNode grammarNode) {
        return grammarNode.getNumAlternatives() > 0;
    }

    private String getWord(GrammarNode grammarNode) {
        String string = null;
        if (grammarNode.getNumAlternatives() > 0) {
            Word[][] wordArray = grammarNode.getAlternatives();
            string = wordArray[0][0].getSpelling();
        }
        return string;
    }

    private boolean hasEndNode(GrammarNode grammarNode) {
        return this.expandedNodes.contains(grammarNode);
    }

    private GrammarNode getEndNode(GrammarNode grammarNode) {
        GrammarArc[] grammarArcArray = grammarNode.getSuccessors();
        assert (grammarArcArray != null && grammarArcArray.length > 0);
        return grammarArcArray[0].getGrammarNode();
    }
}

