/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarInterface;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Grammar
implements Configurable,
GrammarInterface {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_GRAMMAR = "showGrammar";
    @S4Boolean(defaultValue=true)
    public static final String PROP_OPTIMIZE_GRAMMAR = "optimizeGrammar";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_SIL_WORDS = "addSilenceWords";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_FILLER_WORDS = "addFillerWords";
    @S4Component(type=Dictionary.class)
    public static final String PROP_DICTIONARY = "dictionary";
    protected Logger logger;
    private boolean optimizeGrammar = true;
    private boolean addSilenceWords;
    private boolean addFillerWords;
    protected Dictionary dictionary;
    protected GrammarNode initialNode;
    private Set<GrammarNode> grammarNodes;
    private static final Word[][] EMPTY_ALTERNATIVE = new Word[0][0];
    private final Random randomizer = new Random(56L);
    private int maxIdentity;
    private boolean idCheck;

    public Grammar(boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.optimizeGrammar = bl2;
        this.addSilenceWords = bl3;
        this.addFillerWords = bl4;
        this.dictionary = dictionary;
    }

    public Grammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.optimizeGrammar = propertySheet.getBoolean(PROP_OPTIMIZE_GRAMMAR);
        this.addSilenceWords = propertySheet.getBoolean(PROP_ADD_SIL_WORDS);
        this.addFillerWords = propertySheet.getBoolean(PROP_ADD_FILLER_WORDS);
        this.dictionary = (Dictionary)propertySheet.getComponent(PROP_DICTIONARY);
    }

    public void allocate() throws IOException {
        this.dictionary.allocate();
        this.newGrammar();
        Timer timer = TimerPool.getTimer(this, "grammarLoad");
        timer.start();
        this.initialNode = this.createGrammar();
        timer.stop();
    }

    public void deallocate() {
        this.initialNode = null;
        this.grammarNodes = null;
        this.dictionary.deallocate();
    }

    @Override
    public GrammarNode getInitialNode() {
        return this.initialNode;
    }

    protected void postProcessGrammar() {
        if (this.addFillerWords) {
            this.addFillerWords();
        } else if (this.addSilenceWords) {
            this.addSilenceWords();
        }
        if (this.optimizeGrammar) {
            this.optimizeGrammar();
        }
        this.dumpStatistics();
    }

    public void dumpStatistics() {
        if (this.logger.isLoggable(Level.INFO)) {
            int n = 0;
            this.logger.info("Num nodes : " + this.getNumNodes());
            for (GrammarNode grammarNode : this.grammarNodes) {
                n += grammarNode.getSuccessors().length;
            }
            this.logger.info("Num arcs  : " + n);
            this.logger.info("Avg arcs  : " + (float)n / (float)this.getNumNodes());
        }
    }

    public void dumpRandomSentences(String string, int n) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < n; ++i) {
                String string2 = this.getRandomSentence();
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
                printWriter.println(string2);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            this.logger.severe("Can't write random sentences to " + string + ' ' + iOException);
        }
    }

    public void dumpRandomSentences(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.getRandomSentence();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            System.out.println(string);
        }
    }

    public String getRandomSentence() {
        StringBuilder stringBuilder = new StringBuilder();
        GrammarNode grammarNode = this.getInitialNode();
        while (!grammarNode.isFinalNode()) {
            Word word;
            if (!grammarNode.isEmpty() && !(word = grammarNode.getWord()).isFiller()) {
                stringBuilder.append(word.getSpelling()).append(' ');
            }
            grammarNode = this.selectRandomSuccessor(grammarNode);
        }
        return stringBuilder.toString().trim();
    }

    private GrammarNode selectRandomSuccessor(GrammarNode grammarNode) {
        GrammarArc[] grammarArcArray = grammarNode.getSuccessors();
        if (grammarArcArray.length > 1) {
            int n;
            double[] dArray = new double[grammarArcArray.length];
            double d = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = ((double)grammarArcArray[0].getProbability() + 1.0E-10) / ((double)grammarArcArray[n].getProbability() + 1.0E-10);
                d += dArray[n];
            }
            n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
            double d2 = this.randomizer.nextDouble();
            int n3 = 0;
            int n4 = 0;
            while (d2 > 1.0E-10) {
                n3 = n4;
                d2 -= dArray[n4];
                ++n4;
            }
            return grammarArcArray[n3].getGrammarNode();
        }
        return grammarArcArray[0].getGrammarNode();
    }

    public void dumpGrammar(String string) {
        this.getInitialNode().dumpDot(string);
    }

    public int getNumNodes() {
        return this.grammarNodes.size();
    }

    @Override
    public Set<GrammarNode> getGrammarNodes() {
        return this.grammarNodes;
    }

    protected void newGrammar() {
        this.maxIdentity = 0;
        this.grammarNodes = new HashSet<GrammarNode>();
        this.initialNode = null;
    }

    protected abstract GrammarNode createGrammar() throws IOException;

    protected GrammarNode createGrammar(String string) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    protected GrammarNode createGrammarNode(int n, String[][] stringArray) {
        Word[][] wordArray = new Word[stringArray.length][];
        block0: for (int i = 0; i < wordArray.length; ++i) {
            wordArray[i] = new Word[stringArray[i].length];
            for (int j = 0; j < stringArray[i].length; ++j) {
                Word word = this.getDictionary().getWord(stringArray[i][j]);
                if (word == null) {
                    wordArray = EMPTY_ALTERNATIVE;
                    continue block0;
                }
                wordArray[i][j] = word;
            }
        }
        GrammarNode grammarNode = new GrammarNode(n, wordArray);
        this.add(grammarNode);
        return grammarNode;
    }

    protected GrammarNode createGrammarNode(String string) {
        GrammarNode grammarNode = this.createGrammarNode(this.maxIdentity + 1, string);
        return grammarNode;
    }

    protected GrammarNode createGrammarNode(boolean bl) {
        return this.createGrammarNode(this.maxIdentity + 1, bl);
    }

    protected GrammarNode createGrammarNode(int n, String string) {
        GrammarNode grammarNode;
        Word[][] wordArray = EMPTY_ALTERNATIVE;
        Word word = this.getDictionary().getWord(string);
        if (word != null) {
            wordArray = new Word[][]{new Word[1]};
            wordArray[0][0] = word;
            grammarNode = new GrammarNode(n, wordArray);
            this.add(grammarNode);
        } else {
            grammarNode = this.createGrammarNode(n, false);
            this.logger.warning("Can't find pronunciation for " + string);
        }
        return grammarNode;
    }

    protected GrammarNode createGrammarNode(int n, boolean bl) {
        GrammarNode grammarNode = new GrammarNode(n, bl);
        this.add(grammarNode);
        return grammarNode;
    }

    private void add(GrammarNode grammarNode) throws Error {
        if (grammarNode.getID() > this.maxIdentity) {
            this.maxIdentity = grammarNode.getID();
        }
        if (this.idCheck) {
            for (GrammarNode grammarNode2 : this.grammarNodes) {
                if (grammarNode2.getID() != grammarNode.getID()) continue;
                throw new Error("DUP ID " + grammarNode2 + " and " + grammarNode);
            }
        }
        this.grammarNodes.add(grammarNode);
    }

    private void optimizeGrammar() {
        Set<GrammarNode> set = this.getGrammarNodes();
        for (GrammarNode grammarNode : set) {
            grammarNode.optimize();
        }
    }

    private void addSilenceWords() {
        HashSet<GrammarNode> hashSet = new HashSet<GrammarNode>(this.getGrammarNodes());
        for (GrammarNode grammarNode : hashSet) {
            if (grammarNode.isEmpty() || grammarNode.getWord().isFiller()) continue;
            GrammarNode grammarNode2 = this.createGrammarNode(this.maxIdentity + 1, this.dictionary.getSilenceWord().getSpelling());
            GrammarNode grammarNode3 = grammarNode.splitNode(this.maxIdentity + 1);
            this.add(grammarNode3);
            grammarNode.add(grammarNode2, 0.0f);
            grammarNode2.add(grammarNode3, 0.0f);
            grammarNode2.add(grammarNode2, 0.0f);
        }
    }

    private void addFillerWords() {
        HashSet<GrammarNode> hashSet = new HashSet<GrammarNode>(this.getGrammarNodes());
        Word[] wordArray = this.getInterWordFillers();
        if (wordArray.length == 0) {
            return;
        }
        for (GrammarNode grammarNode : hashSet) {
            if (grammarNode.isEmpty() || grammarNode.getWord().isFiller()) continue;
            GrammarNode grammarNode2 = grammarNode.splitNode(this.maxIdentity + 1);
            this.add(grammarNode2);
            GrammarNode grammarNode3 = this.createGrammarNode(false);
            GrammarNode grammarNode4 = this.createGrammarNode(false);
            grammarNode4.add(grammarNode3, 0.0f);
            grammarNode4.add(grammarNode2, 0.0f);
            grammarNode.add(grammarNode3, 0.0f);
            for (Word word : wordArray) {
                GrammarNode grammarNode5 = this.createGrammarNode(this.maxIdentity + 1, word.getSpelling());
                grammarNode3.add(grammarNode5, 0.0f);
                grammarNode5.add(grammarNode4, 0.0f);
            }
        }
    }

    private Word[] getInterWordFillers() {
        Word[] wordArray;
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (Word word : wordArray = this.dictionary.getFillerWords()) {
            if (word == this.dictionary.getSentenceStartWord() || word == this.dictionary.getSentenceEndWord()) continue;
            arrayList.add(word);
        }
        return arrayList.toArray(new Word[arrayList.size()]);
    }
}

