/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class GrammarNode {
    private final int identity;
    private boolean isFinal;
    private Word[][] alternatives;
    private List<GrammarArc> arcList = new ArrayList<GrammarArc>();

    public GrammarNode(int n, Word[][] wordArray) {
        this(n, false);
        this.alternatives = wordArray;
    }

    protected GrammarNode(int n, boolean bl) {
        this.identity = n;
        this.isFinal = bl;
        this.alternatives = new Word[0][0];
    }

    public int getID() {
        return this.identity;
    }

    public Word[][] getAlternatives() {
        return this.alternatives;
    }

    void optimize() {
        GrammarArc grammarArc;
        for (int i = 0; i < this.arcList.size(); ++i) {
            grammarArc = this.arcList.get(i);
            this.arcList.set(i, this.optimizeArc(grammarArc));
        }
        if (this.isEmpty()) {
            ListIterator<GrammarArc> listIterator = this.arcList.listIterator();
            while (listIterator.hasNext()) {
                grammarArc = listIterator.next();
                if (this != grammarArc.getGrammarNode()) continue;
                listIterator.remove();
            }
        }
    }

    GrammarArc optimizeArc(GrammarArc grammarArc) {
        GrammarNode grammarNode = grammarArc.getGrammarNode();
        while (grammarNode.isEmpty() && grammarNode.arcList.size() == 1) {
            GrammarArc grammarArc2 = grammarNode.arcList.get(0);
            grammarArc = new GrammarArc(grammarArc2.getGrammarNode(), grammarArc.getProbability() + grammarArc2.getProbability());
            grammarNode = grammarArc.getGrammarNode();
        }
        return grammarArc;
    }

    public Word[] getWords(int n) {
        return this.alternatives[n];
    }

    public Word getWord() {
        return this.alternatives[0][0];
    }

    public int getNumAlternatives() {
        return this.alternatives.length;
    }

    public boolean isEmpty() {
        return this.getNumAlternatives() == 0;
    }

    public GrammarArc[] getSuccessors() {
        return this.arcList.toArray(new GrammarArc[this.arcList.size()]);
    }

    public boolean isFinalNode() {
        return this.isFinal;
    }

    public void setFinalNode(boolean bl) {
        this.isFinal = bl;
    }

    public void add(GrammarNode grammarNode, float f) {
        if (this.isEmpty() && this == grammarNode) {
            return;
        }
        this.arcList.add(new GrammarArc(grammarNode, f));
    }

    public String toString() {
        return "G" + this.getID();
    }

    private String traverse(int n, Set<GrammarNode> set, float f) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("    ");
        }
        stringBuilder.append("N(").append(this.getID()).append("):");
        stringBuilder.append("p:").append(f);
        if (this.isFinalNode()) {
            stringBuilder.append(" !");
        }
        Word[][] wordArray = this.getAlternatives();
        for (int i = 0; i < wordArray.length; ++i) {
            for (int j = 0; j < wordArray[i].length; ++j) {
                stringBuilder.append(' ').append(wordArray[i][j].getSpelling());
            }
            if (i >= wordArray.length - 1) continue;
            stringBuilder.append('|');
        }
        System.out.println(stringBuilder);
        if (!this.isFinalNode() && !set.contains(this)) {
            GrammarArc[] grammarArcArray;
            set.add(this);
            for (GrammarArc grammarArc : grammarArcArray = this.getSuccessors()) {
                GrammarNode grammarNode = grammarArc.getGrammarNode();
                grammarNode.traverse(n + 1, set, grammarArc.getProbability());
            }
        } else if (this.isFinalNode()) {
            set.add(this);
        }
        return stringBuilder.toString();
    }

    private void traverseGDL(PrintWriter printWriter, Set<GrammarNode> set) throws IOException {
        if (!set.contains(this)) {
            GrammarArc[] grammarArcArray;
            set.add(this);
            printWriter.println("   node: { title: " + this.getGDLID(this) + " label: " + this.getGDLLabel(this) + " shape: " + this.getGDLShape(this) + " color: " + this.getGDLColor(this) + '}');
            for (GrammarArc grammarArc : grammarArcArray = this.getSuccessors()) {
                GrammarNode grammarNode = grammarArc.getGrammarNode();
                float f = grammarArc.getProbability();
                printWriter.println("   edge: { source: " + this.getGDLID(this) + " target: " + this.getGDLID(grammarNode) + " label: \"" + f + "\"}");
                grammarNode.traverseGDL(printWriter, set);
            }
        }
    }

    String getGDLID(GrammarNode grammarNode) {
        return "\"" + grammarNode.getID() + '\"';
    }

    String getGDLLabel(GrammarNode grammarNode) {
        String string = grammarNode.isEmpty() ? "" : grammarNode.getWord().getSpelling();
        return '\"' + string + '\"';
    }

    String getGDLShape(GrammarNode grammarNode) {
        return grammarNode.isEmpty() ? "circle" : "box";
    }

    String getGDLColor(GrammarNode grammarNode) {
        String string = "grey";
        if (grammarNode.isFinalNode()) {
            string = "red";
        } else if (!grammarNode.isEmpty()) {
            string = "green";
        }
        return string;
    }

    public void dumpGDL(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            printWriter.println("graph: {");
            printWriter.println("    orientation: left_to_right");
            printWriter.println("    layout_algorithm: dfs");
            this.traverseGDL(printWriter, new HashSet<GrammarNode>());
            printWriter.println("}");
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't write to " + string + ' ' + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Trouble writing to " + string + ' ' + iOException);
        }
    }

    public void dump() {
        System.out.println(this.traverse(0, new HashSet<GrammarNode>(), 1.0f));
    }

    GrammarNode splitNode(int n) {
        GrammarNode grammarNode = new GrammarNode(n, false);
        grammarNode.arcList = this.arcList;
        this.arcList = new ArrayList<GrammarArc>();
        this.add(grammarNode, 0.0f);
        return grammarNode;
    }

    public void dumpDot(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            printWriter.println("digraph \"" + string + "\" {");
            printWriter.println("rankdir = LR\n");
            this.traverseDot(printWriter, new HashSet<GrammarNode>());
            printWriter.println("}");
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't write to " + string + ' ' + fileNotFoundException);
        }
    }

    private void traverseDot(PrintWriter printWriter, Set<GrammarNode> set) {
        if (!set.contains(this)) {
            GrammarArc[] grammarArcArray;
            set.add(this);
            printWriter.println("\tnode" + this.getID() + " [ label=" + this.getGDLLabel(this) + ", color=" + this.getGDLColor(this) + ", shape=" + this.getGDLShape(this) + " ]\n");
            for (GrammarArc grammarArc : grammarArcArray = this.getSuccessors()) {
                GrammarNode grammarNode = grammarArc.getGrammarNode();
                float f = grammarArc.getProbability();
                printWriter.write("\tnode" + this.getID() + " -> node" + grammarNode.getID() + " [ label=" + f + " ]\n");
                grammarNode.traverseDot(printWriter, set);
            }
        }
    }
}

