/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class LMGrammar
extends Grammar {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_LANGUAGE_MODEL = "languageModel";
    private LanguageModel languageModel;

    public LMGrammar(LanguageModel languageModel, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) {
        super(bl, bl2, bl3, bl4, dictionary);
        this.languageModel = languageModel;
    }

    public LMGrammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.languageModel = (LanguageModel)propertySheet.getComponent(PROP_LANGUAGE_MODEL);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        this.languageModel.allocate();
        TimerPool.getTimer(this, "LMGrammar.create").start();
        GrammarNode grammarNode = null;
        if (this.languageModel.getMaxDepth() > 2) {
            System.out.println("Warning: LMGrammar  limited to bigrams");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set<String> set = this.languageModel.getVocabulary();
        for (String object : set) {
            GrammarNode grammarNode2 = this.createGrammarNode(object);
            if (grammarNode2 == null || grammarNode2.isEmpty()) continue;
            if (grammarNode2.getWord().equals(this.getDictionary().getSentenceStartWord())) {
                grammarNode = grammarNode2;
            } else if (grammarNode2.getWord().equals(this.getDictionary().getSentenceEndWord())) {
                grammarNode2.setFinalNode(true);
            }
            arrayList.add(grammarNode2);
        }
        if (grammarNode == null) {
            throw new Error("No sentence start found in language model");
        }
        for (GrammarNode grammarNode3 : arrayList) {
            if (grammarNode3.isFinalNode()) continue;
            for (GrammarNode grammarNode4 : arrayList) {
                String string = grammarNode3.getWord().getSpelling();
                String string2 = grammarNode4.getWord().getSpelling();
                Word[] wordArray = new Word[]{this.getDictionary().getWord(string), this.getDictionary().getWord(string2)};
                float f = this.languageModel.getProbability(new WordSequence(wordArray));
                grammarNode3.add(grammarNode4, f);
            }
        }
        TimerPool.getTimer(this, "LMGrammar.create").stop();
        this.languageModel.deallocate();
        return grammarNode;
    }
}

