/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.IOException;
import java.util.HashMap;

public class LatticeGrammar
extends Grammar {
    public Lattice lattice;

    public LatticeGrammar(Lattice lattice, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) {
        super(bl, bl2, bl3, bl4, dictionary);
        this.lattice = lattice;
    }

    public LatticeGrammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        GrammarNode grammarNode;
        if (this.lattice == null) {
            return this.createGrammarNode("<s>");
        }
        GrammarNode grammarNode2 = null;
        HashMap<Node, GrammarNode> hashMap = new HashMap<Node, GrammarNode>();
        for (Node object : this.lattice.getNodes()) {
            String string = object.getWord().toString();
            grammarNode = this.createGrammarNode(string);
            if (object.equals(this.lattice.getInitialNode())) {
                grammarNode2 = grammarNode;
            }
            if (object.equals(this.lattice.getTerminalNode())) {
                grammarNode.setFinalNode(true);
            }
            hashMap.put(object, grammarNode);
        }
        if (grammarNode2 == null) {
            throw new Error("No lattice start found");
        }
        for (Edge edge : this.lattice.getEdges()) {
            float f = (float)edge.getLMScore();
            grammarNode = (GrammarNode)hashMap.get(edge.getFromNode());
            GrammarNode grammarNode3 = (GrammarNode)hashMap.get(edge.getToNode());
            grammarNode.add(grammarNode3, f);
        }
        return grammarNode2;
    }

    public void setLattice(Lattice lattice) throws IOException {
        this.lattice = lattice;
        this.allocate();
    }
}

