/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.LinkedList;

public class SimpleWordListGrammar
extends Grammar
implements Configurable {
    @S4String(defaultValue="spelling.gram")
    public static final String PROP_PATH = "path";
    @S4Boolean(defaultValue=true)
    public static final String PROP_LOOP = "isLooping";
    private String path;
    private boolean isLooping;
    private LogMath logMath;

    public SimpleWordListGrammar(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Dictionary dictionary) {
        super(bl2, bl3, bl4, bl5, dictionary);
        this.path = string;
        this.isLooping = bl;
        this.logMath = LogMath.getLogMath();
    }

    public SimpleWordListGrammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.path = propertySheet.getString(PROP_PATH);
        this.isLooping = propertySheet.getBoolean(PROP_LOOP);
    }

    @Override
    protected GrammarNode createGrammar(String string) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        ExtendedStreamTokenizer extendedStreamTokenizer = new ExtendedStreamTokenizer(this.path, true);
        GrammarNode grammarNode = this.createGrammarNode("<sil>");
        GrammarNode grammarNode2 = this.createGrammarNode(false);
        GrammarNode grammarNode3 = this.createGrammarNode("<sil>");
        grammarNode3.setFinalNode(true);
        LinkedList<GrammarNode> linkedList = new LinkedList<GrammarNode>();
        while (!extendedStreamTokenizer.isEOF()) {
            String string;
            while ((string = extendedStreamTokenizer.getString()) != null) {
                GrammarNode grammarNode4 = this.createGrammarNode(string);
                linkedList.add(grammarNode4);
            }
        }
        grammarNode.add(grammarNode2, 0.0f);
        float f = this.logMath.linearToLog(1.0 / (double)linkedList.size());
        for (GrammarNode grammarNode5 : linkedList) {
            grammarNode2.add(grammarNode5, f);
            grammarNode5.add(grammarNode3, 0.0f);
            if (!this.isLooping) continue;
            grammarNode5.add(grammarNode2, 0.0f);
        }
        return grammarNode;
    }
}

