/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DynamicTrigramModel
implements LanguageModel {
    private Dictionary dictionary;
    private final Set<String> vocabulary = new HashSet<String>();
    private int maxDepth;
    private float unigramWeight;
    private List<String> sentences;
    private Map<WordSequence, Float> logProbs = new HashMap<WordSequence, Float>();
    private Map<WordSequence, Float> logBackoffs = new HashMap<WordSequence, Float>();

    public DynamicTrigramModel() {
    }

    public DynamicTrigramModel(Dictionary dictionary) {
        this();
        this.dictionary = dictionary;
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.dictionary = (Dictionary)propertySheet.getComponent("dictionary");
        this.maxDepth = propertySheet.getInt("maxDepth");
        this.unigramWeight = propertySheet.getFloat("unigramWeight");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void allocate() throws IOException {
        TreeSet<WordSequence> treeSet;
        Iterator iterator;
        Object object4;
        Object object2;
        Object object3;
        this.vocabulary.clear();
        this.logProbs.clear();
        this.logBackoffs.clear();
        HashMap<WordSequence, Integer> hashMap = new HashMap<WordSequence, Integer>();
        HashMap<WordSequence, Integer> hashMap2 = new HashMap<WordSequence, Integer>();
        HashMap<WordSequence, Integer> hashMap3 = new HashMap<WordSequence, Integer>();
        int n = 0;
        for (String string : this.sentences) {
            void i;
            object3 = string.split("\\s+");
            object2 = new ArrayList<Word>();
            object2.add(this.dictionary.getSentenceStartWord());
            for (Object object4 : object3) {
                if (((String)object4).length() == 0) continue;
                this.vocabulary.add((String)object4);
                iterator = this.dictionary.getWord((String)object4);
                if (iterator == null) {
                    object2.add(Word.UNKNOWN);
                    continue;
                }
                object2.add(iterator);
            }
            object2.add(this.dictionary.getSentenceEndWord());
            if (object2.size() > 0) {
                this.addSequence(hashMap, new WordSequence((Word)object2.get(0)));
                ++n;
            }
            if (object2.size() > 1) {
                ++n;
                this.addSequence(hashMap, new WordSequence((Word)object2.get(1)));
                this.addSequence(hashMap2, new WordSequence((Word)object2.get(0), (Word)object2.get(1)));
            }
            int entry = 2;
            while (i < object2.size()) {
                ++n;
                this.addSequence(hashMap, new WordSequence((Word)object2.get((int)i)));
                this.addSequence(hashMap2, new WordSequence((Word)object2.get((int)(i - true)), (Word)object2.get((int)i)));
                this.addSequence(hashMap3, new WordSequence((Word)object2.get((int)(i - 2)), (Word)object2.get((int)(i - true)), (Word)object2.get((int)i)));
                ++i;
            }
        }
        float f = 0.5f;
        float f2 = 1.0f - f;
        object3 = new HashMap();
        for (Map.Entry f3 : hashMap.entrySet()) {
            object3.put(f3.getKey(), Float.valueOf((float)((Integer)f3.getValue()).intValue() * f2 / (float)n));
        }
        object2 = LogMath.getLogMath();
        float f3 = ((LogMath)object2).linearToLog(this.unigramWeight);
        float f4 = ((LogMath)object2).linearToLog(1.0f - this.unigramWeight);
        float f5 = -((LogMath)object2).linearToLog(object3.size());
        object4 = new TreeSet(hashMap.keySet());
        iterator = new TreeSet(hashMap2.keySet()).iterator();
        WordSequence wordSequence = iterator.hasNext() ? (WordSequence)iterator.next() : null;
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            int f9;
            treeSet = (WordSequence)object5.next();
            float f6 = ((LogMath)object2).linearToLog(((Float)object3.get(treeSet)).floatValue());
            f6 += f3;
            f6 = ((LogMath)object2).addAsLinear(f6, f5 + f4);
            this.logProbs.put((WordSequence)((Object)treeSet), Float.valueOf(f6));
            float n3 = 0.0f;
            while (wordSequence != null && (f9 = wordSequence.getOldest().compareTo((WordSequence)((Object)treeSet))) <= 0) {
                if (f9 == 0) {
                    n3 += ((Float)object3.get(wordSequence.getNewest())).floatValue();
                }
                wordSequence = iterator.hasNext() ? (WordSequence)iterator.next() : null;
            }
            this.logBackoffs.put((WordSequence)((Object)treeSet), Float.valueOf(((LogMath)object2).linearToLog(f / (1.0f - n3))));
        }
        object5 = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            int entry2 = hashMap.get(((WordSequence)entry.getKey()).getOldest());
            object5.put(entry.getKey(), Float.valueOf((float)((Integer)entry.getValue()).intValue() * f2 / (float)entry2));
        }
        treeSet = new TreeSet<WordSequence>(hashMap2.keySet());
        iterator = new TreeSet(hashMap3.keySet()).iterator();
        wordSequence = iterator.hasNext() ? (WordSequence)iterator.next() : null;
        for (WordSequence wordSequence2 : treeSet) {
            int n2;
            this.logProbs.put(wordSequence2, Float.valueOf(((LogMath)object2).linearToLog(((Float)object5.get(wordSequence2)).floatValue())));
            float f7 = 0.0f;
            while (wordSequence != null && (n2 = wordSequence.getOldest().compareTo(wordSequence2)) <= 0) {
                if (n2 == 0) {
                    f7 += ((Float)object5.get(wordSequence.getNewest())).floatValue();
                }
                wordSequence = iterator.hasNext() ? (WordSequence)iterator.next() : null;
            }
            this.logBackoffs.put(wordSequence2, Float.valueOf(((LogMath)object2).linearToLog(f / (1.0f - f7))));
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            float f8 = (float)((Integer)entry.getValue()).intValue() * f2;
            this.logProbs.put((WordSequence)entry.getKey(), Float.valueOf(((LogMath)object2).linearToLog(f8 /= (float)hashMap2.get(((WordSequence)entry.getKey()).getOldest()).intValue())));
        }
    }

    private void addSequence(HashMap<WordSequence, Integer> hashMap, WordSequence wordSequence) {
        Integer n = hashMap.get(wordSequence);
        if (n != null) {
            hashMap.put(wordSequence, n + 1);
        } else {
            hashMap.put(wordSequence, 1);
        }
    }

    @Override
    public void deallocate() throws IOException {
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float f;
        float f2 = this.logProbs.containsKey(wordSequence) ? this.logProbs.get(wordSequence).floatValue() : (wordSequence.size() > 1 ? ((f = this.logBackoffs.get(wordSequence.getOldest())) == null ? 0.0f + this.getProbability(wordSequence.getNewest()) : f.floatValue() + this.getProbability(wordSequence.getNewest())) : -3.4028235E38f);
        return f2;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void onUtteranceEnd() {
    }

    public void setText(List<String> list) {
        this.sentences = list;
    }
}

