/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4StringList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InterpolatedLanguageModel
implements LanguageModel {
    @S4ComponentList(type=LanguageModel.class)
    public static final String PROP_LANGUAGE_MODELS = "languageModels";
    @S4StringList
    public static final String PROP_LANGUAGE_MODEL_WEIGHTS = "languageModelWeights";
    private LogMath logMath;
    private boolean allocated = false;
    private List<LanguageModel> languageModels;
    private float[] weights;
    private int numberOfLanguageModels;
    private Set<String> vocabulary;
    private static final double EPSILON = 0.001;

    public InterpolatedLanguageModel(List<LanguageModel> list, float[] fArray) {
        this.logMath = LogMath.getLogMath();
        this.languageModels = list;
        this.numberOfLanguageModels = list.size();
        this.weights = new float[fArray.length];
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
            this.weights[i] = this.logMath.linearToLog(fArray[i]);
        }
        if ((double)f < 0.999 || (double)f > 1.001) {
            throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Weights do not sum to 1.0");
        }
    }

    public InterpolatedLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.languageModels = propertySheet.getComponentList(PROP_LANGUAGE_MODELS, LanguageModel.class);
        this.numberOfLanguageModels = this.languageModels.size();
        List<String> list = propertySheet.getStringList(PROP_LANGUAGE_MODEL_WEIGHTS);
        if (list.size() != this.numberOfLanguageModels) {
            throw new RuntimeException("Number of weights not equal to number of language models");
        }
        float[] fArray = new float[list.size()];
        this.weights = new float[fArray.length];
        float f = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            try {
                fArray[i] = Float.parseFloat(list.get(i));
                f += fArray[i];
                this.weights[i] = this.logMath.linearToLog(fArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Float value expected from the property list. But found:" + list.get(i));
            }
        }
        if ((double)f < 0.999 || (double)f > 1.001) {
            throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Weights do not sum to 1.0");
        }
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.vocabulary = new HashSet<String>();
            for (LanguageModel languageModel : this.languageModels) {
                languageModel.allocate();
                this.vocabulary.addAll(languageModel.getVocabulary());
            }
        }
    }

    @Override
    public void deallocate() throws IOException {
        this.allocated = false;
        for (LanguageModel languageModel : this.languageModels) {
            languageModel.deallocate();
        }
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float f = 0.0f;
        for (int i = 0; i < this.numberOfLanguageModels; ++i) {
            float f2 = this.weights[i] + this.languageModels.get(i).getProbability(wordSequence);
            f = i == 0 ? f2 : this.logMath.addAsLinear(f, f2);
        }
        return f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 1.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        int n = 0;
        for (LanguageModel languageModel : this.languageModels) {
            int n2 = languageModel.getMaxDepth();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public void onUtteranceEnd() {
    }
}

