/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class KeywordOptimizerModel
implements LanguageModel {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_PARENT = "parent";
    public HashMap<String, Float> keywordProbs;
    private LanguageModel parent;

    public KeywordOptimizerModel(LanguageModel languageModel) {
        this.parent = languageModel;
    }

    public KeywordOptimizerModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.parent = (LanguageModel)propertySheet.getComponent(PROP_PARENT);
    }

    @Override
    public void allocate() throws IOException {
        this.parent.allocate();
    }

    @Override
    public void deallocate() throws IOException {
        this.parent.deallocate();
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float f = this.parent.getProbability(wordSequence);
        if (this.keywordProbs == null) {
            return f;
        }
        for (Word word : wordSequence.getWords()) {
            String string = word.toString();
            if (!this.keywordProbs.containsKey(string)) continue;
            f *= this.keywordProbs.get(string).floatValue();
        }
        return f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return this.parent.getSmear(wordSequence);
    }

    @Override
    public int getMaxDepth() {
        return this.parent.getMaxDepth();
    }

    @Override
    public Set<String> getVocabulary() {
        return this.parent.getVocabulary();
    }

    @Override
    public void onUtteranceEnd() {
    }
}

