/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class NetworkLanguageModel
implements LanguageModel {
    @S4String(defaultValue="localhost")
    public static final String PROP_HOST = "host";
    @S4Integer(defaultValue=2525)
    public static final String PROP_PORT = "port";
    LogMath logMath;
    private String host;
    private int port;
    private URL location;
    int maxDepth;
    Socket socket;
    private BufferedReader inReader;
    private PrintWriter outWriter;
    LRUCache<WordSequence, Float> cache;
    private boolean allocated;

    public NetworkLanguageModel(String string, int n, URL uRL, int n2) {
        this.host = string;
        this.port = n;
        this.maxDepth = n2;
        this.location = uRL;
        this.logMath = LogMath.getLogMath();
    }

    public NetworkLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.host = propertySheet.getString(PROP_HOST);
        this.port = propertySheet.getInt(PROP_PORT);
        this.location = ConfigurationManagerUtils.getResource("location", propertySheet);
        this.maxDepth = propertySheet.getInt("maxDepth");
        if (this.maxDepth == -1) {
            this.maxDepth = 3;
        }
    }

    @Override
    public void allocate() throws IOException {
        this.allocated = true;
        this.socket = new Socket(this.host, this.port);
        this.inReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.outWriter = new PrintWriter(this.socket.getOutputStream(), true);
        String string = this.inReader.readLine();
        if (!string.equals("probserver ready")) {
            throw new IOException("Incorrect input");
        }
        this.cache = new LRUCache(1000);
    }

    @Override
    public void deallocate() {
        this.allocated = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float f = (Float)this.cache.get(wordSequence);
        if (f != null) {
            return f.floatValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (wordSequence.size() == 0) {
            return 0.0f;
        }
        for (Word word : wordSequence.getWords()) {
            stringBuilder.append(word.toString());
            stringBuilder.append(' ');
        }
        this.outWriter.println(stringBuilder.toString());
        Object object = "0";
        try {
            object = this.inReader.readLine();
            if (((String)object).charAt(0) == '\u0000') {
                object = ((String)object).substring(1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        f = !((String)object).equals("-inf") ? Float.valueOf(this.logMath.log10ToLog(Float.parseFloat((String)object))) : Float.valueOf(-3.4028235E38f);
        this.cache.put(wordSequence, f);
        return f.floatValue();
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.location.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                hashSet.add(string.trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashSet;
    }

    @Override
    public void onUtteranceEnd() {
    }
}

