/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.Probability;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SimpleNGramModel
implements LanguageModel {
    private String name;
    private LogMath logMath;
    private URL urlLocation;
    private float unigramWeight;
    private Dictionary dictionary;
    private int desiredMaxDepth;
    private int maxNGram;
    private Map<WordSequence, Probability> map;
    private Set<String> vocabulary;
    protected int lineNumber;
    protected BufferedReader reader;
    protected String fileName;
    private boolean allocated;
    private LinkedList<WordSequence> tokens;

    public SimpleNGramModel(String string, Dictionary dictionary, float f, int n) throws MalformedURLException, ClassNotFoundException {
        this(ConfigurationManagerUtils.resourceToURL(string), dictionary, f, n);
    }

    public SimpleNGramModel(URL uRL, Dictionary dictionary, float f, int n) {
        this.urlLocation = uRL;
        this.unigramWeight = f;
        this.logMath = LogMath.getLogMath();
        this.desiredMaxDepth = n;
        this.dictionary = dictionary;
        this.map = new HashMap<WordSequence, Probability>();
        this.vocabulary = new HashSet<String>();
        this.tokens = new LinkedList();
    }

    public SimpleNGramModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.urlLocation = ConfigurationManagerUtils.getResource("location", propertySheet);
        this.unigramWeight = propertySheet.getFloat("unigramWeight");
        this.desiredMaxDepth = propertySheet.getInt("maxDepth");
        this.dictionary = (Dictionary)propertySheet.getComponent("dictionary");
        this.map = new HashMap<WordSequence, Probability>();
        this.vocabulary = new HashSet<String>();
        this.tokens = new LinkedList();
    }

    @Override
    public void allocate() throws IOException {
        this.allocated = true;
        this.load(this.urlLocation, this.unigramWeight, this.dictionary);
        if (this.desiredMaxDepth > 0 && this.desiredMaxDepth < this.maxNGram) {
            this.maxNGram = this.desiredMaxDepth;
        }
    }

    @Override
    public void deallocate() {
        this.allocated = false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float f = 0.0f;
        Probability probability = this.getProb(wordSequence);
        f = probability == null ? (wordSequence.size() > 1 ? this.getBackoff(wordSequence.getOldest()) + this.getProbability(wordSequence.getNewest()) : -3.4028235E38f) : probability.logProbability;
        return f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    public float getBackoff(WordSequence wordSequence) {
        float f = 0.0f;
        Probability probability = this.getProb(wordSequence);
        if (probability != null) {
            f = probability.logBackoff;
        }
        return f;
    }

    @Override
    public int getMaxDepth() {
        return this.maxNGram;
    }

    @Override
    public Set<String> getVocabulary() {
        return Collections.unmodifiableSet(this.vocabulary);
    }

    @Override
    public void onUtteranceEnd() {
    }

    private Probability getProb(WordSequence wordSequence) {
        return this.map.get(wordSequence);
    }

    private String listToString(List<Word> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Word word : list) {
            stringBuilder.append(word).append(' ');
        }
        return stringBuilder.toString();
    }

    public void dump() {
        for (Map.Entry<WordSequence, Probability> entry : this.map.entrySet()) {
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
    }

    private String getRepresentation(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append('+');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private void load(URL uRL, float f, Dictionary dictionary) throws IOException {
        int n;
        String string;
        float f2 = this.logMath.linearToLog(f);
        float f3 = this.logMath.linearToLog(1.0 - (double)f);
        this.open(uRL);
        this.readUntil("\\data\\");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while ((string = this.readLine()) != null) {
            if (string.startsWith("ngram")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f=");
                if (stringTokenizer.countTokens() != 3) {
                    this.corrupt("corrupt ngram field " + string + ' ' + stringTokenizer.countTokens());
                }
                stringTokenizer.nextToken();
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                arrayList.add(n2 - 1, n);
                this.maxNGram = Math.max(n2, this.maxNGram);
                continue;
            }
            if (!string.equals("\\1-grams:")) continue;
        }
        int n3 = (Integer)arrayList.get(0) - 1;
        float f4 = -this.logMath.linearToLog(n3);
        for (n = 0; n < arrayList.size(); ++n) {
            int n4 = n + 1;
            int n5 = (Integer)arrayList.get(n);
            for (int i = 0; i < n5; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.readLine());
                int n6 = stringTokenizer.countTokens();
                if (n6 != n4 + 1 && n6 != n4 + 2) {
                    this.corrupt("Bad format");
                }
                float f5 = Float.parseFloat(stringTokenizer.nextToken());
                float f6 = 0.0f;
                ArrayList<Word> arrayList2 = new ArrayList<Word>(this.maxNGram);
                for (int j = 0; j < n4; ++j) {
                    String string2 = stringTokenizer.nextToken();
                    this.vocabulary.add(string2);
                    Word word = dictionary.getWord(string2);
                    if (word == null) {
                        word = Word.UNKNOWN;
                    }
                    arrayList2.add(word);
                }
                WordSequence wordSequence = new WordSequence(arrayList2);
                if (stringTokenizer.hasMoreTokens()) {
                    f6 = Float.parseFloat(stringTokenizer.nextToken());
                }
                float f7 = this.logMath.log10ToLog(f5);
                float f8 = this.logMath.log10ToLog(f6);
                if (n4 == 1) {
                    float f9 = f7 + f2;
                    float f10 = f4 + f3;
                    f7 = this.logMath.addAsLinear(f9, f10);
                }
                this.put(wordSequence, f7, f8);
            }
            if (n >= arrayList.size() - 1) continue;
            String string3 = "\\" + (n4 + 1) + "-grams:";
            this.readUntil(string3);
        }
        this.readUntil("\\end\\");
        this.close();
    }

    private void put(WordSequence wordSequence, float f, float f2) {
        this.map.put(wordSequence, new Probability(f, f2));
        this.tokens.add(wordSequence);
    }

    public LinkedList<WordSequence> getNGrams() {
        return this.tokens;
    }

    private String readLine() throws IOException {
        ++this.lineNumber;
        String string = this.reader.readLine();
        if (string == null) {
            this.corrupt("Premature EOF");
        }
        return string.trim();
    }

    private void open(URL uRL) throws IOException {
        this.lineNumber = 0;
        this.fileName = uRL.toString();
        this.reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
    }

    private void readUntil(String string) throws IOException {
        try {
            while (!this.readLine().equals(string)) {
            }
        }
        catch (IOException iOException) {
            this.corrupt("Premature EOF while waiting for " + string);
        }
    }

    private void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    private void corrupt(String string) throws IOException {
        throw new IOException("Corrupt Language Model " + this.fileName + " at line " + this.lineNumber + ':' + string);
    }
}

