/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.language.ngram.large.UnigramProbability;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Utilities;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryLoader {
    private static final String DARPA_TG_HEADER = "Darpa Trigram LM";
    private static final String DARPA_QG_HEADER = "Darpa Quadrigram LM";
    private static final String DARPA_NG_HEADER = "Darpa \\d-gram LM";
    private static final int LOG2_NGRAM_SEGMENT_SIZE = 9;
    private static final float MIN_PROBABILITY = -99.0f;
    private static final int MAX_PROB_TABLE_SIZE = Integer.MAX_VALUE;
    private LogMath logMath;
    private int maxNGram;
    private float unigramWeight;
    private float languageWeight;
    private double wip;
    private boolean bigEndian = true;
    private boolean applyLanguageWeightAndWip;
    private long bytesRead;
    private UnigramProbability[] unigrams;
    private String[] words;
    private long[] NGramOffset;
    private int[] numberNGrams;
    private int logNGramSegmentSize;
    private int startWordID = -1;
    private int endWordID = -1;
    private int[][] NGramSegmentTable;
    private float[][] NGramProbTable;
    private float[][] NGramBackoffTable;
    private RandomAccessFile file;
    private int bytesPerField;

    public BinaryLoader(File file, String string, boolean bl, float f, double d, float f2) throws IOException {
        this(string, bl, f, d, f2);
        this.loadModelLayout(new FileInputStream(file));
        this.file = new RandomAccessFile(file, "r");
    }

    public BinaryLoader(String string, boolean bl, float f, double d, float f2) {
        this.applyLanguageWeightAndWip = bl;
        this.logMath = LogMath.getLogMath();
        this.languageWeight = f;
        this.wip = d;
        this.unigramWeight = f2;
    }

    public void deallocate() throws IOException {
        if (null != this.file) {
            this.file.close();
        }
    }

    public int getNumberUnigrams() {
        return this.getNumberNGrams(1);
    }

    public int getNumberBigrams() {
        return this.getNumberNGrams(2);
    }

    public int getNumberTrigrams() {
        return this.getNumberNGrams(3);
    }

    public int getNumberNGrams(int n) {
        assert (n <= this.maxNGram & n > 0);
        return this.numberNGrams[n - 1];
    }

    public UnigramProbability[] getUnigrams() {
        return this.unigrams;
    }

    public float[] getBigramProbabilities() {
        return this.getNGramProbabilities(2);
    }

    public float[] getTrigramProbabilities() {
        return this.getNGramProbabilities(3);
    }

    public float[] getTrigramBackoffWeights() {
        return this.getNGramBackoffWeights(3);
    }

    public int[] getTrigramSegments() {
        return this.getNGramSegments(3);
    }

    public int getLogBigramSegmentSize() {
        return this.logNGramSegmentSize;
    }

    public float[] getNGramProbabilities(int n) {
        assert (n <= this.maxNGram && n > 1);
        return this.NGramProbTable[n - 1];
    }

    public float[] getNGramBackoffWeights(int n) {
        assert (n <= this.maxNGram & n > 2);
        return this.NGramBackoffTable[n - 1];
    }

    public int[] getNGramSegments(int n) {
        assert (n <= this.maxNGram & n > 2);
        return this.NGramSegmentTable[n - 1];
    }

    public int getLogNGramSegmentSize() {
        return this.logNGramSegmentSize;
    }

    public String[] getWords() {
        return this.words;
    }

    public long getBigramOffset() {
        return this.getNGramOffset(2);
    }

    public long getTrigramOffset() {
        return this.getNGramOffset(3);
    }

    public long getNGramOffset(int n) {
        assert (n <= this.maxNGram & n > 1);
        return this.NGramOffset[n - 1];
    }

    public int getMaxDepth() {
        return this.maxNGram;
    }

    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public int getBytesPerField() {
        return this.bytesPerField;
    }

    public byte[] loadBuffer(long l, int n) throws IOException {
        this.file.seek(l);
        byte[] byArray = new byte[n];
        if (this.file.read(byArray) != n) {
            throw new IOException("Incorrect number of bytes read. Size = " + n + ". Position =" + l + ".");
        }
        return byArray;
    }

    protected void loadModelLayout(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.readHeader(dataInputStream);
        this.unigrams = this.readUnigrams(dataInputStream, this.numberNGrams[0] + 1, this.bigEndian);
        this.skipNGrams(dataInputStream);
        for (n = 1; n < this.maxNGram; ++n) {
            if (this.numberNGrams[n] <= 0) continue;
            if (n == 1) {
                this.NGramProbTable[n] = this.readFloatTable(dataInputStream, this.bigEndian);
                continue;
            }
            this.NGramBackoffTable[n] = this.readFloatTable(dataInputStream, this.bigEndian);
            this.NGramProbTable[n] = this.readFloatTable(dataInputStream, this.bigEndian);
            int n2 = 1 << this.logNGramSegmentSize;
            int n3 = (this.numberNGrams[n - 1] + 1) / n2 + 1;
            this.NGramSegmentTable[n] = this.readIntTable(dataInputStream, this.bigEndian, n3);
        }
        n = this.readInt(dataInputStream, this.bigEndian);
        if (n <= 0) {
            throw new Error("Bad word string size: " + n);
        }
        this.words = this.readWords(dataInputStream, n, this.numberNGrams[0]);
        if (this.startWordID > -1) {
            UnigramProbability unigramProbability = this.unigrams[this.startWordID];
            unigramProbability.setLogProbability(-99.0f);
        }
        if (this.endWordID > -1) {
            UnigramProbability unigramProbability = this.unigrams[this.endWordID];
            unigramProbability.setLogBackoff(-99.0f);
        }
        this.applyUnigramWeight();
        if (this.applyLanguageWeightAndWip) {
            for (int i = 0; i <= this.maxNGram; ++i) {
                this.applyLanguageWeight(this.NGramProbTable[i], this.languageWeight);
                this.applyWip(this.NGramProbTable[i], this.wip);
                if (i <= 1) continue;
                this.applyLanguageWeight(this.NGramBackoffTable[i], this.languageWeight);
            }
        }
        dataInputStream.close();
    }

    private void readHeader(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = this.readInt(dataInputStream, this.bigEndian);
        if (n2 != DARPA_TG_HEADER.length() + 1 && n2 != DARPA_QG_HEADER.length() + 1 && n2 != DARPA_NG_HEADER.length() - 1) {
            if ((n2 = Utilities.swapInteger(n2)) == DARPA_TG_HEADER.length() + 1 || n2 == DARPA_QG_HEADER.length() + 1 || n2 == DARPA_NG_HEADER.length() - 1) {
                this.bigEndian = false;
            } else {
                throw new Error("Bad binary LM file magic number: " + n2 + ", not an LM dumpfile?");
            }
        }
        String string = this.readString(dataInputStream, n2 - 1);
        dataInputStream.readByte();
        ++this.bytesRead;
        if (!(string.equals(DARPA_TG_HEADER) || string.equals(DARPA_QG_HEADER) || Pattern.matches(DARPA_NG_HEADER, string))) {
            throw new Error("Bad binary LM file header: " + string);
        }
        if (string.equals(DARPA_TG_HEADER)) {
            this.maxNGram = 3;
        } else if (string.equals(DARPA_QG_HEADER)) {
            this.maxNGram = 4;
        } else {
            Pattern pattern = Pattern.compile("\\d");
            Matcher matcher = pattern.matcher(string);
            this.maxNGram = Integer.parseInt(matcher.group());
        }
        int n3 = this.readInt(dataInputStream, this.bigEndian);
        this.skipStreamBytes(dataInputStream, n3);
        this.numberNGrams = new int[this.maxNGram];
        this.NGramOffset = new long[this.maxNGram];
        this.NGramProbTable = new float[this.maxNGram][];
        this.NGramBackoffTable = new float[this.maxNGram][];
        this.NGramSegmentTable = new int[this.maxNGram][];
        this.numberNGrams[0] = 0;
        this.logNGramSegmentSize = 9;
        int n4 = this.readInt(dataInputStream, this.bigEndian);
        this.bytesPerField = 2;
        if (n4 <= 0) {
            this.readInt(dataInputStream, this.bigEndian);
            if (n4 <= -3) {
                this.bytesPerField = 4;
            }
            while ((n = this.readInt(dataInputStream, this.bigEndian)) != 0) {
                this.bytesRead += (long)dataInputStream.skipBytes(n);
            }
            if (n4 == -2) {
                this.logNGramSegmentSize = this.readInt(dataInputStream, this.bigEndian);
                if (this.logNGramSegmentSize < 1 || this.logNGramSegmentSize > 15) {
                    throw new Error("log2(bg_seg_sz) outside range 1..15");
                }
            }
            this.numberNGrams[0] = this.readInt(dataInputStream, this.bigEndian);
        } else {
            this.numberNGrams[0] = n4;
        }
        if (this.numberNGrams[0] <= 0) {
            throw new Error("Bad number of unigrams: " + this.numberNGrams[0] + ", must be > 0.");
        }
        for (n = 1; n < this.maxNGram; ++n) {
            this.numberNGrams[n] = this.readInt(dataInputStream, this.bigEndian);
            if (this.numberNGrams[n] >= 0) continue;
            throw new Error("Bad number of " + String.valueOf(n) + "-grams: " + this.numberNGrams[n]);
        }
    }

    private void skipNGrams(DataInputStream dataInputStream) throws IOException {
        this.NGramOffset[1] = this.bytesRead;
        long l = (this.numberNGrams[1] + 1) * 4 * this.getBytesPerField();
        this.skipStreamBytes(dataInputStream, l);
        for (int i = 2; i < this.maxNGram; ++i) {
            if (this.numberNGrams[i] > 0 && i < this.maxNGram - 1) {
                this.NGramOffset[i] = this.bytesRead;
                l = (long)(this.numberNGrams[i] + 1) * 4L * (long)this.getBytesPerField();
                this.skipStreamBytes(dataInputStream, l);
                continue;
            }
            if (this.numberNGrams[i] <= 0 || i != this.maxNGram - 1) continue;
            this.NGramOffset[i] = this.bytesRead;
            l = (long)this.numberNGrams[i] * 2L * (long)this.getBytesPerField();
            this.skipStreamBytes(dataInputStream, l);
        }
    }

    private void skipStreamBytes(DataInputStream dataInputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = dataInputStream.skip(l);
            this.bytesRead += l2;
            l -= l2;
        }
    }

    private void applyUnigramWeight() {
        float f = this.logMath.linearToLog(this.unigramWeight);
        float f2 = this.logMath.linearToLog(1.0f - this.unigramWeight);
        float f3 = this.logMath.linearToLog(1.0f / (float)this.numberNGrams[0]);
        float f4 = this.logMath.linearToLog(this.wip);
        float f5 = f3 + f2;
        for (int i = 0; i < this.numberNGrams[0]; ++i) {
            UnigramProbability unigramProbability = this.unigrams[i];
            float f6 = unigramProbability.getLogProbability();
            if (i != this.startWordID) {
                f6 += f;
                f6 = this.logMath.addAsLinear(f6, f5);
            }
            if (this.applyLanguageWeightAndWip) {
                f6 = f6 * this.languageWeight + f4;
                unigramProbability.setLogBackoff(unigramProbability.getLogBackoff() * this.languageWeight);
            }
            unigramProbability.setLogProbability(f6);
        }
    }

    private void applyLanguageWeight(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray[i] * f;
        }
    }

    private void applyWip(float[] fArray, double d) {
        float f = this.logMath.linearToLog(d);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray[i] + f;
        }
    }

    private float[] readFloatTable(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n = this.readInt(dataInputStream, bl);
        if (n <= 0 || n > Integer.MAX_VALUE) {
            throw new Error("Bad probabilities table size: " + n);
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.logMath.log10ToLog(this.readFloat(dataInputStream, bl));
        }
        return fArray;
    }

    private int[] readIntTable(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        int n2 = this.readInt(dataInputStream, bl);
        if (n2 != n) {
            throw new Error("Bad NGram seg table size: " + n2);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.readInt(dataInputStream, bl);
        }
        return nArray;
    }

    private UnigramProbability[] readUnigrams(DataInputStream dataInputStream, int n, boolean bl) throws IOException {
        UnigramProbability[] unigramProbabilityArray = new UnigramProbability[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt(dataInputStream, bl);
            if (n2 < 1) {
                n2 = i;
            }
            if (i != n - 1) assert (n2 == i);
            float f = this.readFloat(dataInputStream, bl);
            float f2 = this.readFloat(dataInputStream, bl);
            int n3 = this.readInt(dataInputStream, bl);
            float f3 = this.logMath.log10ToLog(f);
            float f4 = this.logMath.log10ToLog(f2);
            unigramProbabilityArray[i] = new UnigramProbability(n2, f3, f4, n3);
        }
        return unigramProbabilityArray;
    }

    private int readInt(DataInputStream dataInputStream, boolean bl) throws IOException {
        this.bytesRead += 4L;
        if (bl) {
            return dataInputStream.readInt();
        }
        return Utilities.readLittleEndianInt(dataInputStream);
    }

    private float readFloat(DataInputStream dataInputStream, boolean bl) throws IOException {
        this.bytesRead += 4L;
        if (bl) {
            return dataInputStream.readFloat();
        }
        return Utilities.readLittleEndianFloat(dataInputStream);
    }

    private String readString(DataInputStream dataInputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[n];
        this.bytesRead += (long)dataInputStream.read(byArray);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    private String[] readWords(DataInputStream dataInputStream, int n, int n2) throws IOException {
        String[] stringArray = new String[n2];
        byte[] byArray = new byte[n];
        this.bytesRead += (long)dataInputStream.read(byArray);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            ++this.bytesRead;
            if (c != '\u0000') continue;
            stringArray[n3] = new String(byArray, n4, i - n4);
            n4 = i + 1;
            if (stringArray[n3].equals("<s>")) {
                this.startWordID = n3;
            } else if (stringArray[n3].equals("</s>")) {
                this.endWordID = n3;
            }
            ++n3;
        }
        assert (n3 == n2);
        return stringArray;
    }
}

