/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.large.LargeNGramModel;
import java.util.HashMap;

public class KeywordOptimizerLargeNGramModel
extends LargeNGramModel {
    public HashMap<String, Float> keywordProbs;

    @Override
    public float getProbability(WordSequence wordSequence) {
        float f = super.getProbability(wordSequence);
        if (this.keywordProbs == null) {
            return f;
        }
        for (Word word : wordSequence.getWords()) {
            String string = word.toString();
            if (!this.keywordProbs.containsKey(string)) continue;
            f *= this.keywordProbs.get(string).floatValue();
        }
        return f;
    }
}

