/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.large.BinaryLoader;
import edu.cmu.sphinx.linguist.language.ngram.large.BinaryStreamLoader;
import edu.cmu.sphinx.linguist.language.ngram.large.NGramBuffer;
import edu.cmu.sphinx.linguist.language.ngram.large.NGramProbability;
import edu.cmu.sphinx.linguist.language.ngram.large.NMaxGramBuffer;
import edu.cmu.sphinx.linguist.language.ngram.large.UnigramProbability;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LargeNGramModel
implements LanguageModel {
    @S4String(mandatory=false)
    public static final String PROP_QUERY_LOG_FILE = "queryLogFile";
    @S4Integer(defaultValue=100000)
    public static final String PROP_NGRAM_CACHE_SIZE = "ngramCacheSize";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CLEAR_CACHES_AFTER_UTTERANCE = "clearCachesAfterUtterance";
    @S4Double(defaultValue=1.0)
    public static final String PROP_LANGUAGE_WEIGHT = "languageWeight";
    @S4Boolean(defaultValue=false)
    public static final String PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP = "applyLanguageWeightAndWip";
    @S4Double(defaultValue=1.0)
    public static final String PROP_WORD_INSERTION_PROBABILITY = "wordInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_FULL_SMEAR = "fullSmear";
    public static final int BYTES_PER_NGRAM = 4;
    public static final int BYTES_PER_NMAXGRAM = 2;
    private static final int SMEAR_MAGIC = -1060454374;
    URL location;
    protected Logger logger;
    protected LogMath logMath;
    protected int maxDepth;
    protected int ngramCacheSize;
    protected boolean clearCacheAfterUtterance;
    protected boolean fullSmear;
    protected Dictionary dictionary;
    protected String format;
    protected boolean applyLanguageWeightAndWip;
    protected float languageWeight;
    protected float unigramWeight;
    protected double wip;
    private int ngramMisses;
    private int ngramHits;
    private int smearTermCount;
    protected String ngramLogFile;
    private BinaryLoader loader;
    private PrintWriter logFile;
    private Map<Word, UnigramProbability> unigramIDMap;
    private Map<WordSequence, NGramBuffer>[] loadedNGramBuffers;
    private LRUCache<WordSequence, Float> ngramProbCache;
    private Map<Long, Float> bigramSmearMap;
    private NGramBuffer[] loadedBigramBuffers;
    private UnigramProbability[] unigrams;
    private int[][] ngramSegmentTable;
    private float[][] ngramProbTable;
    private float[][] ngramBackoffTable;
    private float[] unigramSmearTerm;
    int smearCount;
    int smearBigramHit;

    public LargeNGramModel(String string, URL uRL, String string2, int n, boolean bl, int n2, Dictionary dictionary, boolean bl2, float f, double d, float f2, boolean bl3) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.format = string;
        this.location = uRL;
        this.ngramLogFile = string2;
        this.ngramCacheSize = n;
        this.clearCacheAfterUtterance = bl;
        this.maxDepth = n2;
        this.logMath = LogMath.getLogMath();
        this.dictionary = dictionary;
        this.applyLanguageWeightAndWip = bl2;
        this.languageWeight = f;
        this.wip = d;
        this.unigramWeight = f2;
        this.fullSmear = bl3;
    }

    public LargeNGramModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.location = ConfigurationManagerUtils.getResource("location", propertySheet);
        this.ngramLogFile = propertySheet.getString(PROP_QUERY_LOG_FILE);
        this.ngramCacheSize = propertySheet.getInt(PROP_NGRAM_CACHE_SIZE);
        this.clearCacheAfterUtterance = propertySheet.getBoolean(PROP_CLEAR_CACHES_AFTER_UTTERANCE);
        this.maxDepth = propertySheet.getInt("maxDepth");
        this.dictionary = (Dictionary)propertySheet.getComponent("dictionary");
        this.applyLanguageWeightAndWip = propertySheet.getBoolean(PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP);
        this.languageWeight = propertySheet.getFloat(PROP_LANGUAGE_WEIGHT);
        this.wip = propertySheet.getDouble(PROP_WORD_INSERTION_PROBABILITY);
        this.unigramWeight = propertySheet.getFloat("unigramWeight");
        this.fullSmear = propertySheet.getBoolean(PROP_FULL_SMEAR);
    }

    @Override
    public void allocate() throws IOException {
        int n;
        TimerPool.getTimer(this, "Load LM").start();
        this.logger.info("Loading n-gram language model from: " + this.location);
        if (this.ngramLogFile != null) {
            this.logFile = new PrintWriter(new FileOutputStream(this.ngramLogFile));
        }
        if (this.location.getProtocol() == null || this.location.getProtocol().equals("file")) {
            try {
                this.loader = new BinaryLoader(new File(this.location.toURI()), this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
            }
            catch (Exception exception) {
                this.loader = new BinaryLoader(new File(this.location.getPath()), this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
            }
        } else {
            this.loader = new BinaryStreamLoader(this.location, this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
        }
        this.unigramIDMap = new HashMap<Word, UnigramProbability>();
        this.unigrams = this.loader.getUnigrams();
        this.loadedNGramBuffers = new Map[this.loader.getMaxDepth()];
        this.ngramProbTable = new float[this.loader.getMaxDepth()][];
        this.ngramBackoffTable = new float[this.loader.getMaxDepth()][];
        this.ngramSegmentTable = new int[this.loader.getMaxDepth()][];
        for (n = 1; n <= this.loader.getMaxDepth(); ++n) {
            this.loadedNGramBuffers[n - 1] = new HashMap<WordSequence, NGramBuffer>();
            if (n >= 2) {
                this.ngramProbTable[n - 1] = this.loader.getNGramProbabilities(n);
            }
            if (n <= 2) continue;
            this.ngramBackoffTable[n - 1] = this.loader.getNGramBackoffWeights(n);
            this.ngramSegmentTable[n - 1] = this.loader.getNGramSegments(n);
        }
        this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        if (this.dictionary != null) {
            this.buildUnigramIDMap(this.dictionary);
        } else {
            this.buildUnigramIDMap();
        }
        this.loadedBigramBuffers = new NGramBuffer[this.unigrams.length];
        if (this.maxDepth <= 0 || this.maxDepth > this.loader.getMaxDepth()) {
            this.maxDepth = this.loader.getMaxDepth();
        }
        for (n = 1; n <= this.loader.getMaxDepth(); ++n) {
            this.logger.info(Integer.toString(n) + "-grams: " + this.loader.getNumberNGrams(n));
        }
        if (this.fullSmear) {
            System.out.println("Full Smear");
            try {
                System.out.println("... Reading ...");
                this.readSmearInfo("smear.dat");
                System.out.println("... Done ");
            }
            catch (IOException iOException) {
                System.out.println("... " + iOException);
                System.out.println("... Calculating");
                this.buildSmearInfo();
                System.out.println("... Writing");
                System.out.println("... Done");
            }
        }
        TimerPool.getTimer(this, "Load LM").stop();
    }

    @Override
    public void deallocate() throws IOException {
        this.loader.deallocate();
    }

    private void buildUnigramIDMap(Dictionary dictionary) {
        int n = 0;
        String[] stringArray = this.loader.getWords();
        for (int i = 0; i < stringArray.length; ++i) {
            Word word = dictionary.getWord(stringArray[i]);
            if (word == null) {
                this.logger.warning("The dictionary is missing a phonetic transcription for the word '" + stringArray[i] + "'");
                ++n;
            }
            this.unigramIDMap.put(word, this.unigrams[i]);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Word: " + word);
        }
        if (n > 0) {
            this.logger.warning("Dictionary is missing " + n + " words that are contained in the language model.");
        }
    }

    private void buildUnigramIDMap() {
        String[] stringArray = this.loader.getWords();
        for (int i = 0; i < stringArray.length; ++i) {
            Word word = new Word(stringArray[i], null, false);
            this.unigramIDMap.put(word, this.unigrams[i]);
        }
    }

    @Override
    public void onUtteranceEnd() {
        this.clearCache();
        if (this.logFile != null) {
            this.logFile.println("<END_UTT>");
            this.logFile.flush();
        }
    }

    private void clearCache() {
        int n;
        for (n = 0; n < this.loadedBigramBuffers.length; ++n) {
            NGramBuffer nGramBuffer = this.loadedBigramBuffers[n];
            if (nGramBuffer == null) continue;
            if (!nGramBuffer.getUsed()) {
                this.loadedBigramBuffers[n] = null;
                continue;
            }
            nGramBuffer.setUsed(false);
        }
        this.loadedBigramBuffers = new NGramBuffer[this.unigrams.length];
        for (n = 2; n <= this.loader.getMaxDepth(); ++n) {
            this.loadedNGramBuffers[n - 1] = new HashMap<WordSequence, NGramBuffer>();
        }
        this.logger.info("LM Cache Size: " + this.ngramProbCache.size() + " Hits: " + this.ngramHits + " Misses: " + this.ngramMisses);
        if (this.clearCacheAfterUtterance) {
            this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        }
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float f;
        int n = wordSequence.size();
        if (n > this.maxDepth) {
            throw new Error("Unsupported NGram: " + wordSequence.size());
        }
        if (n == this.maxDepth) {
            f = (Float)this.ngramProbCache.get(wordSequence);
            if (f != null) {
                ++this.ngramHits;
                return f.floatValue();
            }
            ++this.ngramMisses;
        }
        f = this.getNGramProbability(wordSequence);
        if (n == this.maxDepth) {
            this.ngramProbCache.put(wordSequence, f);
        }
        if (this.logFile != null && f != null) {
            this.logFile.println(wordSequence.toString().replace("][", " ") + " : " + Float.toString(f.floatValue()));
        }
        return f.floatValue();
    }

    private Float getNGramProbability(WordSequence wordSequence) {
        int n = wordSequence.size();
        Word word = wordSequence.getWord(0);
        if (this.loader.getNumberNGrams(n) == 0 || !this.hasUnigram(word)) {
            return this.getNGramProbability(wordSequence.getNewest());
        }
        if (n < 2) {
            return Float.valueOf(this.getUnigramProbability(wordSequence));
        }
        NGramProbability nGramProbability = this.findNGram(wordSequence);
        if (nGramProbability != null) {
            return Float.valueOf(this.ngramProbTable[n - 1][nGramProbability.getProbabilityID()]);
        }
        if (n == 2) {
            UnigramProbability unigramProbability = this.getUnigram(word);
            UnigramProbability unigramProbability2 = this.getUnigram(wordSequence.getWord(1));
            return Float.valueOf(unigramProbability.getLogBackoff() + unigramProbability2.getLogProbability());
        }
        NGramProbability nGramProbability2 = this.findNGram(wordSequence.getOldest());
        if (nGramProbability2 != null) {
            return Float.valueOf(this.ngramBackoffTable[n - 1][nGramProbability2.getBackoffID()] + this.getProbability(wordSequence.getNewest()));
        }
        return Float.valueOf(this.getProbability(wordSequence.getNewest()));
    }

    private NGramProbability findNGram(WordSequence wordSequence) {
        int n = wordSequence.size();
        NGramProbability nGramProbability = null;
        WordSequence wordSequence2 = wordSequence.getOldest();
        NGramBuffer nGramBuffer = this.loadedNGramBuffers[n - 1].get(wordSequence2);
        if (nGramBuffer == null && (nGramBuffer = this.getNGramBuffer(wordSequence2)) != null) {
            this.loadedNGramBuffers[n - 1].put(wordSequence2, nGramBuffer);
        }
        if (nGramBuffer != null) {
            int n2 = this.getWordID(wordSequence.getWord(n - 1));
            nGramProbability = nGramBuffer.findNGram(n2);
        }
        return nGramProbability;
    }

    private boolean is32bits() {
        return this.loader.getBytesPerField() == 4;
    }

    private NGramBuffer loadNGramBuffer(WordSequence wordSequence) {
        int n = this.getWordID(wordSequence.getWord(0));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        int n5 = wordSequence.size() + 1;
        NGramBuffer nGramBuffer = null;
        NGramBuffer nGramBuffer2 = null;
        n2 = this.unigrams[n].getFirstBigramEntry();
        n3 = this.getNumberBigramFollowers(n) + 1;
        if (n3 == 1) {
            return null;
        }
        if (n5 == 2) {
            n4 = n3 * (this.loader.getMaxDepth() == n5 ? 2 : 4) * this.loader.getBytesPerField();
            l = this.loader.getNGramOffset(n5) + (long)(n2 * (this.loader.getMaxDepth() == n5 ? 2 : 4) * this.loader.getBytesPerField());
        } else {
            int n6 = this.getWordID(wordSequence.getWord(wordSequence.size() - 1));
            nGramBuffer2 = this.getNGramBuffer(wordSequence.getOldest());
            int n7 = nGramBuffer2.findNGramIndex(n6);
            if (n7 == -1) {
                return null;
            }
            int n8 = nGramBuffer2.getFirstNGramEntry();
            n2 = this.getFirstNGramEntry(nGramBuffer2.getNGramProbability(n7), n8, n5);
            int n9 = this.getFirstNGramEntry(nGramBuffer2.getNGramProbability(n7 + 1), n8, n5);
            n3 = n9 - n2;
            if (n3 == 0) {
                return null;
            }
            if (this.loader.getMaxDepth() != n5) {
                ++n3;
            }
            n4 = n3 * (this.loader.getMaxDepth() == n5 ? 2 : 4) * this.loader.getBytesPerField();
            l = this.loader.getNGramOffset(n5) + (long)n2 * (long)(this.loader.getMaxDepth() == n5 ? 2 : 4) * (long)this.loader.getBytesPerField();
        }
        try {
            byte[] byArray = this.loader.loadBuffer(l, n4);
            nGramBuffer = this.loader.getMaxDepth() == n5 ? new NMaxGramBuffer(byArray, n3, this.loader.getBigEndian(), this.is32bits(), n5, n2) : new NGramBuffer(byArray, n3, this.loader.getBigEndian(), this.is32bits(), n5, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("Error loading " + n5 + "-Grams.");
        }
        return nGramBuffer;
    }

    private NGramBuffer getNGramBuffer(WordSequence wordSequence) {
        NGramBuffer nGramBuffer = null;
        int n = wordSequence.size();
        if (n > 1) {
            nGramBuffer = this.loadedNGramBuffers[n - 1].get(wordSequence);
        }
        if (nGramBuffer == null && (nGramBuffer = this.loadNGramBuffer(wordSequence)) != null) {
            this.loadedNGramBuffers[n - 1].put(wordSequence, nGramBuffer);
        }
        return nGramBuffer;
    }

    private int getFirstNGramEntry(NGramProbability nGramProbability, int n, int n2) {
        int n3 = this.ngramSegmentTable[n2 - 1][n + nGramProbability.getWhichFollower() >> this.loader.getLogNGramSegmentSize()] + nGramProbability.getFirstNPlus1GramEntry();
        return n3;
    }

    private float getUnigramProbability(WordSequence wordSequence) {
        Word word = wordSequence.getWord(0);
        UnigramProbability unigramProbability = this.getUnigram(word);
        if (unigramProbability == null) {
            throw new Error("Unigram not in LM: " + word);
        }
        return unigramProbability.getLogProbability();
    }

    private UnigramProbability getUnigram(Word word) {
        return this.unigramIDMap.get(word);
    }

    private boolean hasUnigram(Word word) {
        return this.unigramIDMap.get(word) != null;
    }

    public final int getWordID(Word word) {
        UnigramProbability unigramProbability = this.getUnigram(word);
        if (unigramProbability == null) {
            throw new IllegalArgumentException("No word ID: " + word);
        }
        return unigramProbability.getWordID();
    }

    public boolean hasWord(Word word) {
        return this.unigramIDMap.get(new Word(word.toString(), null, false)) != null;
    }

    public float getSmearOld(WordSequence wordSequence) {
        int n;
        float f = 0.0f;
        if (this.fullSmear && (n = wordSequence.size()) > 0) {
            int n2 = this.getWordID(wordSequence.getWord(n - 1));
            f = this.unigramSmearTerm[n2];
        }
        if (this.fullSmear && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SmearTerm: " + f);
        }
        return f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        float f = 0.0f;
        if (this.fullSmear) {
            ++this.smearCount;
            int n = wordSequence.size();
            if (n == 1) {
                int n2 = this.getWordID(wordSequence.getWord(0));
                f = this.unigramSmearTerm[n2];
            } else if (n >= 2) {
                int n3;
                int n4 = wordSequence.size();
                int n5 = this.getWordID(wordSequence.getWord(n4 - 2));
                Float f2 = this.getSmearTerm(n5, n3 = this.getWordID(wordSequence.getWord(n4 - 1)));
                if (f2 == null) {
                    f = this.unigramSmearTerm[n3];
                } else {
                    f = f2.floatValue();
                    ++this.smearBigramHit;
                }
            }
            if (this.smearCount % 100000 == 0) {
                System.out.println("Smear hit: " + this.smearBigramHit + " tot: " + this.smearCount);
            }
        }
        if (this.fullSmear && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SmearTerm: " + f);
        }
        return f;
    }

    private int getNumberBigramFollowers(int n) {
        if (n == this.unigrams.length - 1) {
            return 0;
        }
        return this.unigrams[n + 1].getFirstBigramEntry() - this.unigrams[n].getFirstBigramEntry();
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.loader.getWords()));
        return Collections.unmodifiableSet(hashSet);
    }

    public int getNGramMisses() {
        return this.ngramMisses;
    }

    public int getNGramHits() {
        return this.ngramHits;
    }

    private NGramBuffer getBigramBuffer(int n) {
        Word[] wordArray = new Word[]{this.dictionary.getWord(this.loader.getWords()[n])};
        WordSequence wordSequence = new WordSequence(wordArray);
        return this.loadNGramBuffer(wordSequence);
    }

    private NGramBuffer loadTrigramBuffer(int n, int n2) {
        Word[] wordArray = new Word[]{this.dictionary.getWord(this.loader.getWords()[n]), this.dictionary.getWord(this.loader.getWords()[n2])};
        WordSequence wordSequence = new WordSequence(wordArray);
        return this.loadNGramBuffer(wordSequence);
    }

    private void buildSmearInfo() throws IOException {
        double d;
        double d2;
        int n;
        int n2;
        double d3 = 0.0;
        double d4 = 0.0;
        this.bigramSmearMap = new HashMap<Long, Float>();
        double[] dArray = new double[this.unigrams.length];
        double[] dArray2 = new double[this.unigrams.length];
        double[] dArray3 = new double[this.unigrams.length];
        this.unigramSmearTerm = new float[this.unigrams.length];
        UnigramProbability[] unigramProbabilityArray = this.unigrams;
        int n3 = unigramProbabilityArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            UnigramProbability unigramProbability = unigramProbabilityArray[n2];
            float f = unigramProbability.getLogProbability();
            double d5 = this.logMath.logToLinear(f);
            d3 += d5 * (double)f;
            d4 += d5 * (double)f * (double)f;
        }
        System.out.println("R0 S0 " + d4 + ' ' + d3);
        for (n = 0; n < this.loadedBigramBuffers.length; ++n) {
            NGramBuffer nGramBuffer = this.getBigramBuffer(n);
            if (nGramBuffer == null) {
                this.unigramSmearTerm[n] = 0.0f;
                continue;
            }
            dArray[n] = 0.0;
            dArray2[n] = 0.0;
            dArray3[n] = 0.0;
            float f = this.unigrams[n].getLogBackoff();
            double d6 = this.logMath.logToLinear(f);
            for (int i = 0; i < nGramBuffer.getNumberNGrams(); ++i) {
                int n4 = nGramBuffer.getWordID(i);
                NGramProbability nGramProbability = nGramBuffer.getNGramProbability(i);
                float f2 = this.unigrams[n4].getLogProbability();
                float f3 = this.ngramProbTable[1][nGramProbability.getProbabilityID()];
                d2 = this.logMath.logToLinear(f2);
                d = this.logMath.logToLinear(f3);
                double d7 = d6 * d2;
                double d8 = this.logMath.linearToLog(d7);
                int n5 = n;
                dArray[n5] = dArray[n5] + (d * (double)f3 - d7 * d8) * (double)f2;
                int n6 = n;
                dArray2[n6] = dArray2[n6] + (d - d7) * (double)f2;
            }
            int n7 = n;
            dArray[n7] = dArray[n7] + d6 * ((double)f * d3 + d4);
            dArray3[n] = dArray2[n] + d6 * d3;
            int n8 = n;
            dArray2[n8] = dArray2[n8] + d6 * d4;
            this.unigramSmearTerm[n] = (float)(dArray[n] / dArray2[n]);
        }
        for (n = 0; n < this.loadedBigramBuffers.length; ++n) {
            System.out.println("Processed " + n + " of " + this.loadedBigramBuffers.length);
            NGramBuffer nGramBuffer = this.getBigramBuffer(n);
            if (nGramBuffer == null) continue;
            for (n2 = 0; n2 < nGramBuffer.getNumberNGrams(); ++n2) {
                float f;
                NGramProbability nGramProbability = nGramBuffer.getNGramProbability(n2);
                float f4 = this.ngramBackoffTable[2][nGramProbability.getBackoffID()];
                double d9 = this.logMath.logToLinear(f4);
                int n9 = nGramBuffer.getWordID(n2);
                NGramBuffer nGramBuffer2 = this.loadTrigramBuffer(n, n9);
                if (nGramBuffer2 == null) {
                    f = this.unigramSmearTerm[n9];
                } else {
                    d2 = 0.0;
                    d = 0.0;
                    for (int i = 0; i < nGramBuffer2.getNumberNGrams(); ++i) {
                        int n10 = nGramBuffer2.getWordID(i);
                        float f5 = this.ngramProbTable[2][nGramBuffer2.getProbabilityID(i)];
                        double d10 = this.logMath.logToLinear(f5);
                        float f6 = this.getBigramProb(n9, n10);
                        double d11 = this.logMath.logToLinear(f6);
                        float f7 = this.unigrams[n10].getLogProbability();
                        double d12 = d9 * d11;
                        double d13 = this.logMath.linearToLog(d12);
                        d2 += (d10 * (double)f5 - d12 * d13) * (double)f7;
                        d += (d10 - d12) * (double)f7 * (double)f7;
                    }
                    f = (float)((d2 += d9 * ((double)f4 * dArray3[n9] - dArray[n9])) / (d += d9 * dArray2[n9]));
                    ++this.smearTermCount;
                }
                this.putSmearTerm(n, n9, f);
            }
        }
        System.out.println("Smear count is " + this.smearTermCount);
    }

    private void dumpProbs(double[] dArray, double[] dArray2, int n, int n2, float f, float f2, double d, double d2, double d3, double d4) {
        System.out.println("ubo " + d + ' ' + d2 + ' ' + d3);
        System.out.println("logubo " + f + ' ' + f2 + ' ' + d4);
        System.out.println("n/d " + n2 + ' ' + dArray[n] + ' ' + dArray2[n]);
        System.out.print(d + " " + d2 + ' ' + d3);
        System.out.print(" " + f + ' ' + f2 + ' ' + d4);
        System.out.println("  " + dArray[n] + ' ' + dArray2[n]);
    }

    private void writeSmearInfo(String string) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        dataOutputStream.writeInt(-1060454374);
        System.out.println("writing " + this.unigrams.length);
        dataOutputStream.writeInt(this.unigrams.length);
        for (n = 0; n < this.unigrams.length; ++n) {
            dataOutputStream.writeFloat(this.unigramSmearTerm[n]);
        }
        for (n = 0; n < this.unigrams.length; ++n) {
            System.out.println("Writing " + n + " of " + this.unigrams.length);
            NGramBuffer nGramBuffer = this.getBigramBuffer(n);
            if (nGramBuffer == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(nGramBuffer.getNumberNGrams());
            for (int i = 0; i < nGramBuffer.getNumberNGrams(); ++i) {
                int n2 = nGramBuffer.getWordID(i);
                Float f = this.getSmearTerm(n, n2);
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeFloat(f.floatValue());
            }
        }
        dataOutputStream.close();
    }

    private void readSmearInfo(String string) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        if (dataInputStream.readInt() != -1060454374) {
            dataInputStream.close();
            throw new IOException("Bad smear format for " + string);
        }
        if (dataInputStream.readInt() != this.unigrams.length) {
            dataInputStream.close();
            throw new IOException("Bad unigram length in " + string);
        }
        this.bigramSmearMap = new HashMap<Long, Float>();
        this.unigramSmearTerm = new float[this.unigrams.length];
        System.out.println("Reading " + this.unigrams.length);
        for (n = 0; n < this.unigrams.length; ++n) {
            this.unigramSmearTerm[n] = dataInputStream.readFloat();
        }
        for (n = 0; n < this.unigrams.length; ++n) {
            System.out.println("Processed " + n + " of " + this.loadedBigramBuffers.length);
            int n2 = dataInputStream.readInt();
            NGramBuffer nGramBuffer = this.getBigramBuffer(n);
            if (nGramBuffer.getNumberNGrams() != n2) {
                dataInputStream.close();
                throw new IOException("Bad ngrams for unigram " + n + " Found " + n2 + " expected " + nGramBuffer.getNumberNGrams());
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = nGramBuffer.getWordID(i);
                this.putSmearTerm(n, n3, dataInputStream.readFloat());
            }
        }
        dataInputStream.close();
    }

    private void putSmearTerm(int n, int n2, float f) {
        long l = (long)n << 32 | (long)n2;
        this.bigramSmearMap.put(l, Float.valueOf(f));
    }

    private Float getSmearTerm(int n, int n2) {
        long l = (long)n << 32 | (long)n2;
        return this.bigramSmearMap.get(l);
    }

    private float getBigramProb(int n, int n2) {
        NGramBuffer nGramBuffer = this.getBigramBuffer(n);
        NGramProbability nGramProbability = nGramBuffer.findNGram(n2);
        return this.ngramProbTable[1][nGramProbability.getProbabilityID()];
    }
}

