/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.language.ngram.large.NGramProbability;

class NGramBuffer {
    private final byte[] buffer;
    private final int numberNGrams;
    private int position;
    private final boolean bigEndian;
    private final boolean is32bits;
    private final int n;
    private boolean used;
    private int firstNGramEntry;

    public NGramBuffer(byte[] byArray, int n, boolean bl, boolean bl2, int n2, int n3) {
        this.buffer = byArray;
        this.numberNGrams = n;
        this.bigEndian = bl;
        this.is32bits = bl2;
        this.position = 0;
        this.n = n2;
        this.firstNGramEntry = n3;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getFirstNGramEntry() {
        return this.firstNGramEntry;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public int getNumberNGrams() {
        return this.numberNGrams;
    }

    protected int getPosition() {
        return this.position;
    }

    protected int getN() {
        return this.n;
    }

    protected void setPosition(int n) {
        this.position = n;
    }

    public final int getWordID(int n) {
        int n2 = n * (this.buffer.length / this.numberNGrams);
        this.setPosition(n2);
        return this.readBytesAsInt();
    }

    public final boolean isBigEndian() {
        return this.bigEndian;
    }

    public final boolean is32bits() {
        return this.is32bits;
    }

    public final int readBytesAsInt() {
        if (this.is32bits) {
            if (this.bigEndian) {
                int n = 0xFF & this.buffer[this.position++];
                n <<= 8;
                n |= 0xFF & this.buffer[this.position++];
                n <<= 8;
                n |= 0xFF & this.buffer[this.position++];
                n <<= 8;
                return n |= 0xFF & this.buffer[this.position++];
            }
            int n = 0xFF & this.buffer[this.position + 3];
            n <<= 8;
            n |= 0xFF & this.buffer[this.position + 2];
            n <<= 8;
            n |= 0xFF & this.buffer[this.position + 1];
            n <<= 8;
            this.position += 4;
            return n |= 0xFF & this.buffer[this.position];
        }
        if (this.bigEndian) {
            int n = 0xFF & this.buffer[this.position++];
            n <<= 8;
            return n |= 0xFF & this.buffer[this.position++];
        }
        int n = 0xFF & this.buffer[this.position + 1];
        n <<= 8;
        this.position += 2;
        return n |= 0xFF & this.buffer[this.position];
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public int findProbabilityID(int n) {
        int n2 = 0;
        int n3 = this.getNumberNGrams();
        int n4 = -1;
        while (n3 - n2 > 0) {
            int n5 = (n2 + n3) / 2;
            int n6 = this.getWordID(n5);
            if (n6 < n) {
                n2 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n3 = n5;
                continue;
            }
            n4 = this.getProbabilityID(n5);
            break;
        }
        return n4;
    }

    public int getProbabilityID(int n) {
        int n2 = 0;
        n2 = n * 4 * (this.is32bits ? 4 : 2);
        this.setPosition(n2 + (this.is32bits ? 4 : 2));
        return this.readBytesAsInt();
    }

    public NGramProbability findNGram(int n) {
        int n2 = 0;
        int n3 = this.getNumberNGrams() - 1;
        NGramProbability nGramProbability = null;
        while (n3 - n2 > 0) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.getWordID(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            nGramProbability = this.getNGramProbability(n4);
            break;
        }
        return nGramProbability;
    }

    public int findNGramIndex(int n) {
        int n2 = -1;
        int n3 = 0;
        int n4 = this.getNumberNGrams() - 1;
        while (n4 - n3 > 0) {
            n2 = (n3 + n4) / 2;
            int n5 = this.getWordID(n2);
            if (n5 < n) {
                n3 = n2 + 1;
                continue;
            }
            if (n5 <= n) break;
            n4 = n2;
        }
        return n2;
    }

    public NGramProbability getNGramProbability(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n2 = n * 4 * (this.is32bits ? 4 : 2);
        this.setPosition(n2);
        n3 = this.readBytesAsInt();
        n4 = this.readBytesAsInt();
        n5 = this.readBytesAsInt();
        n6 = this.readBytesAsInt();
        return new NGramProbability(n, n3, n4, n5, n6);
    }
}

