/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieModel;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieQuant;
import edu.cmu.sphinx.util.Utilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BinaryLoader {
    private static final String TRIE_HEADER = "Trie Language Model";
    private DataInputStream inStream;

    public BinaryLoader(File file) throws IOException {
        this.inStream = new DataInputStream(new FileInputStream(file));
    }

    private void loadModelData(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while (dataInputStream.read(byArray) >= 0) {
            byteArrayOutputStream.write(byArray);
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public BinaryLoader(URL uRL) throws IOException {
        this.loadModelData(uRL.openStream());
    }

    public void verifyHeader() throws IOException {
        String string = this.readString(this.inStream, TRIE_HEADER.length());
        if (!string.equals(TRIE_HEADER)) {
            throw new Error("Bad binary LM file header: " + string);
        }
    }

    public int[] readCounts() throws IOException {
        int n = this.readOrder();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Utilities.readLittleEndianInt(this.inStream);
        }
        return nArray;
    }

    public NgramTrieQuant readQuant(int n) throws IOException {
        int n2 = Utilities.readLittleEndianInt(this.inStream);
        if (n2 < 0 || n2 >= NgramTrieQuant.QuantType.values().length) {
            throw new Error("Unknown quantatization type: " + n2);
        }
        NgramTrieQuant.QuantType quantType = NgramTrieQuant.QuantType.values()[n2];
        NgramTrieQuant ngramTrieQuant = new NgramTrieQuant(n, quantType);
        for (int i = 2; i <= n; ++i) {
            ngramTrieQuant.setTable(this.readFloatArr(ngramTrieQuant.getProbTableLen()), i, true);
            if (i >= n) continue;
            ngramTrieQuant.setTable(this.readFloatArr(ngramTrieQuant.getBackoffTableLen()), i, false);
        }
        return ngramTrieQuant;
    }

    public NgramTrieModel.TrieUnigram[] readUnigrams(int n) throws IOException {
        NgramTrieModel.TrieUnigram[] trieUnigramArray = new NgramTrieModel.TrieUnigram[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            trieUnigramArray[i] = new NgramTrieModel.TrieUnigram();
            trieUnigramArray[i].prob = Utilities.readLittleEndianFloat(this.inStream);
            trieUnigramArray[i].backoff = Utilities.readLittleEndianFloat(this.inStream);
            trieUnigramArray[i].next = Utilities.readLittleEndianInt(this.inStream);
        }
        return trieUnigramArray;
    }

    public void readTrieByteArr(byte[] byArray) throws IOException {
        this.inStream.read(byArray);
    }

    public String[] readWords(int n) throws IOException {
        int n2 = Utilities.readLittleEndianInt(this.inStream);
        if (n2 <= 0) {
            throw new Error("Bad word string size: " + n2);
        }
        String[] stringArray = new String[n];
        byte[] byArray = new byte[n2];
        this.inStream.read(byArray);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c != '\u0000') continue;
            stringArray[n3] = new String(byArray, n4, i - n4);
            n4 = i + 1;
            ++n3;
        }
        assert (n3 == n);
        return stringArray;
    }

    public void close() throws IOException {
        this.inStream.close();
    }

    private int readOrder() throws IOException {
        return this.inStream.readByte();
    }

    private float[] readFloatArr(int n) throws IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Utilities.readLittleEndianFloat(this.inStream);
        }
        return fArray;
    }

    private String readString(DataInputStream dataInputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }
}

